#include "nc.h"

/*
 * The predefined symbols
 */

/* These symbols come in a variety of types.   Most must be declared as
   an external to be referenced.  Some can be referenced without being
   declared.  Such variables have OSF_PREDEF on.

   Some trigger special actions, such as the inclusion of a header line
   in the header parse list, or the setting of a boolean variable in the
   user code.  Header items have SPC_HEADER on.

   Various other codes are defined in "nc.h"
 */
 /*
  * Newsclip(TM) Compiler Source Code.
  * Copyright 1989 Looking Glass Software Limited.  All Rights Reserved.
  * Unless otherwise licenced, the only authorized use of this source
  * code is compilation into a binary of the newsclip compiler for the
  * use of licenced Newsclip customers.  Minor source code modifications
  * are allowed before compiling.
  * A short time evaluation of this product is also permitted.  See the file
  * 'Licence' in the library source directory for details.
  */

#define TL static struct typelist
#define TLL static dtype

TLL dta[] = {T_INTEGER};
TL oneint = { 1, 1, 1, dta };

TLL doneng[] = {T_NEWSGROUP};
TL oneng = { 1, 1, 1, doneng };

TLL dts[] = {T_STRING};
TL onestring = { 1, 1, 1, dts };

TLL dttext[] = {T_TEXT};
TL onetext = { 1, 1, 1, dttext };

TLL dt2s[] = {T_STRING,T_STRING};
TL twostring = { 2, 2, 2, dt2s };

TLL dtsi[] = {T_STRING, T_INTEGER};
TL stringint = { 2, 2, 2, dtsi };

TLL dunam[] = { T_USERNAME };
TL oneuname = { 1, 1, 1, dunam };

TLL donear[] = { T_GENARRAY };
TL onearray = { 1, 1, 1, donear };

TLL donedb[] = { T_DATABASE };
TL onedb = { 1, 1, 1, donedb };

TLL ddbstring[] = { T_DATABASE, T_STRING };
TL dbstring = { 2, 2, 2, ddbstring };

TLL darb[] = { T_STRING };		/* printf arbitrary arg stream */
TL strarb = { 1, 255, 1, darb };

TL none = { 0, 0, 0 };

TLL dwrdb[] = { T_DATABASE, T_STRING, T_DATE };
TL wrdb = { 3, 3, 3, dwrdb };

struct outsym predefs[] = {
{ "approved",		ST_VAR,	T_USERNAME,		SPC_HEADER },
{ "control",		ST_VAR,	T_STRING,		SPC_HEADER },
{ "date",		ST_VAR,	T_DATE,			SPC_HEADER },
{ "distribution",	ST_VAR,	arrayof(T_NEWSGROUP),	SPC_HEADER },
{ "rdistribution",	ST_VAR,	arrayof(T_NEWSGROUP),	SPC_NEWSGROUPS },
{ "expires",		ST_VAR,	T_DATE,			SPC_HEADER },
{ "followup_to",	ST_VAR,	arrayof(T_NEWSGROUP),	SPC_HEADER },
{ "rfollowup_to",	ST_VAR,	arrayof(T_NEWSGROUP),	SPC_NEWSGROUPS },
{ "from",		ST_VAR,	T_USERNAME,		SPC_HEADER },
{ "keywords",		ST_VAR,	arrayof(T_STRING),	SPC_HEADER },
{ "lines",		ST_VAR,	T_INTEGER,		SPC_HEADER },
{ "message_id",		ST_VAR,	T_STRING,		SPC_HEADER },
{ "newsgroups",		ST_VAR,	arrayof(T_NEWSGROUP),	OSF_PREDEF|SPC_HEADER|OSF_REFERENCED },
{ "organization",	ST_VAR,	T_STRING,		SPC_HEADER },
{ "path",		ST_VAR,	arrayof(T_STRING),	SPC_HEADER },
{ "posting_version",	ST_VAR,	T_STRING,		SPC_HEADER },
{ "references",		ST_VAR,	arrayof(T_STRING),	SPC_HEADER },
{ "reply_to",		ST_VAR,	T_USERNAME,		SPC_HEADER },
{ "rreply_to",		ST_VAR,	T_USERNAME,		SPC_FROM },
{ "sender",		ST_VAR,	T_USERNAME,		SPC_HEADER },
{ "rsender",		ST_VAR,	T_USERNAME,		SPC_FROM },
{ "subject",		ST_VAR,	T_STRING,		SPC_HEADER },
{ "summary",		ST_VAR,	T_STRING,		SPC_HEADER },
{ "xref",		ST_VAR,	arrayof(T_STRING),	SPC_HEADER },
/* useful variables */
{ "followup",		ST_VAR,		T_INTEGER,	SPC_REF },
{ "score",		ST_VAR,		T_INTEGER,	0 },
{ "article_filename",	ST_VAR,		T_STRING,	0 },
{ "article_number",	ST_VAR,		T_INTEGER,	0 },
{ "article_bytes",	ST_VAR,		T_INTEGER,	OSF_CONST|SPC_STAT },
{ "num_links",		ST_VAR,		T_INTEGER,	SPC_STAT },
{ "write_time",		ST_VAR,		T_DATE,		SPC_STAT },
/* size functions */
{ "byte_count",		ST_FUNC,	T_INTEGER,	OSF_PREDEF, &onetext },
{ "line_count",		ST_FUNC,	T_INTEGER,	OSF_PREDEF, &onetext },
/* calculated variables */
{ "distribution_level",	ST_VAR,		T_INTEGER,	SPC_DIST},
/* control variables */
{ "set_include_prefix",	ST_PROC,	0,			0, &onestring },
{ "preserve_case",	ST_VAR,		T_INTEGER,		0 },
{ "paragraph_scan",	ST_VAR,		T_INTEGER,		0 },
{ "white_compress",	ST_VAR,		T_INTEGER,		0 },
{ "set_signature_start",ST_PROC, 	0,			0, &onestring },
{ "subscribe",		ST_PROC, 	0,			0, &onestring },
{ "time_now",		ST_VAR,		T_DATE,			0 },
{ "my_domain",		ST_VAR,		T_STRING,		0 },
{ "my_mail_address",	ST_VAR,		T_STRING,		0 },
{ "options",		ST_VAR,		arrayof(T_STRING),	0 },
{ "accept_all",		ST_VAR,		T_INTEGER,	0 },
{ "reject_all",		ST_VAR,		T_INTEGER,	0 },
{ "main_newsgroup",	ST_VAR,		T_NEWSGROUP,	0 },
{ "dir_newsgroup",	ST_VAR,		T_NEWSGROUP,	0 },
{ "proc_mode",		ST_VAR,		T_STRING,	0 },
/* time and date constants */
{ "day",		ST_VAR,		T_DATE,		OSF_PREDEF|OSF_CONST },
{ "week",		ST_VAR,		T_DATE,		OSF_PREDEF|OSF_CONST },
{ "month",		ST_VAR,		T_DATE,		OSF_PREDEF|OSF_CONST },
/* special text variables */
{ "body",		ST_VAR,		T_TEXT,		OSF_PREDEF|OSF_CONST },
{ "text",		ST_VAR,		T_TEXT,		OSF_PREDEF|OSF_CONST },
{ "signature",		ST_VAR,		T_TEXT,		OSF_PREDEF|OSF_CONST },
{ "newtext",		ST_VAR,		T_TEXT,		OSF_PREDEF|OSF_CONST },
{ "included",		ST_VAR,		T_TEXT,		OSF_PREDEF|OSF_CONST },
/* null constants */
{ "false",		ST_VAR,		T_INTEGER,	OSF_PREDEF|OSF_CONST },
{ "true",		ST_VAR,		T_INTEGER,	OSF_PREDEF|OSF_CONST },
{ "nilstring",		ST_VAR,		T_STRING,	OSF_PREDEF|OSF_CONST },
{ "niluserid",		ST_VAR,		T_USERNAME,	OSF_PREDEF|OSF_CONST },
{ "nildatabase",	ST_VAR,		T_DATABASE,	OSF_PREDEF|OSF_CONST },
{ "nilnewsgroup",	ST_VAR,		T_NEWSGROUP,	OSF_PREDEF|OSF_CONST },
{ "nilarray",		ST_VAR,		T_ARRAY,	OSF_PREDEF|OSF_CONST },
/* Functions, procedures and macros */
{ "count",		ST_FUNC,	T_INTEGER,	OSF_CONST|OSF_PREDEF,
								&onearray },
{ "realname",		ST_FUNC,	T_STRING,	OSF_CONST|OSF_PREDEF,
								&oneuname },
{ "mailname",		ST_FUNC,	T_STRING,	OSF_CONST|OSF_PREDEF,
								&oneuname },
{ "domain",		ST_FUNC,	T_STRING,	0, &onestring },
{ "dlevel",		ST_FUNC,	T_INTEGER,	OSF_PREDEF, &oneng },
{ "chindex",		ST_FUNC,	T_INTEGER,	OSF_CONST, &stringint },
{ "read_database",	ST_FUNC,	T_DATABASE,	OSF_PREDEF, &onestring},
{ "exists",		ST_FUNC,	T_INTEGER,	0, &onestring },
{ "write_database",	ST_PROC,	0,		OSF_PREDEF, &wrdb },
{ "free_database",	ST_PROC,	0,		OSF_PREDEF, &onedb },
{ "fresh_database",	ST_FUNC,	T_DATABASE,	OSF_PREDEF, &oneint },
{ "db_delete",		ST_PROC,	0,		OSF_PREDEF, &dbstring },
{ "getenv",		ST_FUNC,	T_STRING,	0, &onestring },
{ "dprintf",		ST_PROC,	0,		OSF_PREDEF, &strarb },
{ "strlen",		ST_FUNC,	T_INTEGER,	0, &onestring },
{ "left",		ST_FUNC,	T_STRING,	0, &stringint },
{ "right",		ST_FUNC,	T_STRING,	0, &stringint },
{ "concat",		ST_FUNC,	T_STRING,	0, &twostring },
{ "drop_re",		ST_FUNC,	T_STRING,	0, &onestring },
{ "permstring",		ST_FUNC,	T_STRING,	0, &onestring },
{ "clipfront",		ST_FUNC,	T_STRING,	0, &stringint },
{ "leftmost",		ST_FUNC,	T_STRING,	0, &stringint },
{ "literal\_pattern",	ST_FUNC,	T_STRING,	0, &onestring },
{ "lower",		ST_FUNC,	T_STRING,	0, &onestring },
{ "named_group",	ST_FUNC,	T_INTEGER,	0, &oneng },
{ "newsrc_group",	ST_FUNC,	T_INTEGER,	0, &oneng },
{ 0, 0, 0, 0 }
};

/* some variables that get set based on what is used */

bool needs_stat = FALSE;
