
/* List .newsrc files on the system 
 * Copyright 1990 by Looking Glass Software Limited.
 * See the file READ.ME for licence details.
 */

#include <stdio.h>
#include <pwd.h>

char *pats_to_try[50];		/* patterns to try for .newsrc */
int rc_patterns = 0;		/* how many so far */

main( argc, argv )
int argc;	/* arg count */
char **argv;	/* arg vector */
{
	int argnum;
	char *strchr();
	char dirbuf[300];
	struct passwd *pw;
	int allflag;
	int i;

	pats_to_try[rc_patterns++] = ".newsrc";
	allflag = 0;

	for( argnum = 1; argnum < argc; argnum++ ) {
		char *argline;
		char *argstr;		/* argument string */
		int argval;
		int isplus;		/* boolean tells +arg vs -arg */
		argline = argv[argnum];

		if (argstr = strchr(argline, '=')) {
			argstr++;
			argval = atoi(argstr);
			switch( argline[0] ) {
				case 'p':
					pats_to_try[rc_patterns++] = argstr;
					break;
				default:
					error( "Bad Option %s\n", argline );
				}
			}
		else if( (isplus = argline[0] == '+') || argline[0] == '-' ) {
			switch( argline[1] ) {
				case 'a':
					allflag = isplus;
					break;
				default:
					error( "Bad Option %s\n", argline );
				}
			}
		else {
			/* code for untagged option */
			;
			}
		}
	/* body of program */

	while( pw = getpwent() ) {
		for( i = 0; i < rc_patterns; i++ ) {
			sprintf( dirbuf, "%s/%s", pw->pw_dir, pats_to_try[i] );
			if( access( dirbuf, 4 ) == 0 ) {
				printf( "%s\n", dirbuf );
				if( !allflag )
					break;
				}
			}
		}

}

error( form, a, b, c, d, e, f, g, h )
char *form;
{
	fprintf( stderr, form, a,b,c,d,e,f,g,h );
	exit(1);
}

