/*
 * in6_debug.c  --  Insipired by Craig Metz's Net/2 in6_debug.c, but
 *                  not quite as heavyweight (initially, anyway).
 *
 * The idea is to have globals here, and dump netinet6/ data structures.
 *
 * Copyright 1995 by Dan McDonald, Bao Phan, and Randall Atkinson,
 *	All Rights Reserved.  
 *      All Rights under this copyright have been assigned to NRL.
 */

/*----------------------------------------------------------------------
#       @(#)COPYRIGHT   1.1a (NRL) 17 August 1995

COPYRIGHT NOTICE

All of the documentation and software included in this software
distribution from the US Naval Research Laboratory (NRL) are
copyrighted by their respective developers.

This software and documentation were developed at NRL by various
people.  Those developers have each copyrighted the portions that they
developed at NRL and have assigned All Rights for those portions to
NRL.  Outside the USA, NRL also has copyright on the software
developed at NRL. The affected files all contain specific copyright
notices and those notices must be retained in any derived work.

NRL LICENSE

NRL grants permission for redistribution and use in source and binary
forms, with or without modification, of the software and documentation
created at NRL provided that the following conditions are met:

1. Redistributions of source code must retain the above copyright
   notice, this list of conditions and the following disclaimer.
2. Redistributions in binary form must reproduce the above copyright
   notice, this list of conditions and the following disclaimer in the
   documentation and/or other materials provided with the distribution.
3. All advertising materials mentioning features or use of this software
   must display the following acknowledgement:

        This product includes software developed at the Information
        Technology Division, US Naval Research Laboratory.

4. Neither the name of the NRL nor the names of its contributors
   may be used to endorse or promote products derived from this software
   without specific prior written permission.

THE SOFTWARE PROVIDED BY NRL IS PROVIDED BY NRL AND CONTRIBUTORS ``AS
IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL NRL OR
CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

The views and conclusions contained in the software and documentation
are those of the authors and should not be interpreted as representing
official policies, either expressed or implied, of the US Naval
Research Laboratory (NRL).

----------------------------------------------------------------------*/

#define _KEY_DEBUG_C 1

#ifdef linux
#include <netkey/osdep_linux.h>
#else /* linux */
#include <netkey/osdep_44bsd.h>
#include <sys/param.h>
#ifdef KERNEL
#include <sys/systm.h>
#include <sys/mbuf.h>
#include <sys/malloc.h>
#endif /* KERNEL */
#endif /* linux */
#include <netkey/key.h>

/* The following should be sysctl-tweakable. */

unsigned int key_debug_level = IDL_ERROR;  /* 0 is no debugging */

#ifdef KERNEL
/*----------------------------------------------------------------------
 * Dump a key_tblnode structrue
 ----------------------------------------------------------------------*/
void dump_keytblnode DEFARGS((ktblnode),
     struct key_tblnode *ktblnode)
{
#if defined(_GENERIC_DEBUG) && defined(KEY_DEBUG)
  if (!ktblnode) {
    printf("NULL key table node pointer!\n");
    return;
  }
  printf("solist=0x%x ", (unsigned int)ktblnode->solist);
  printf("secassoc=0x%x ", (unsigned int)ktblnode->secassoc);
  printf("next=0x%x\n", (unsigned int)ktblnode->next);
#endif /* defined(_GENERIC_DEBUG) && defined(KEY_DEBUG) */
}

void dump_secassoc DEFARGS((seca),
struct key_secassoc *seca)
{
#if defined(_GENERIC_DEBUG) && defined(KEY_DEBUG)
  printf("key_secassoc at %08x:\n", (unsigned int)seca);
  if (!seca)
    return;

  printf("len=%x type=%x state=%x label=%x spi=%08x algorithm=%x", (unsigned int)seca->len, (unsigned int)seca->type, (unsigned int)seca->state, (unsigned int)seca->label, (unsigned int)seca->spi, (unsigned int)seca->algorithm);
  printf(" lifetype=%x lifetime1=%x lifetime2=%x", (unsigned int)seca->lifetype, (unsigned int)seca->lifetime1, (unsigned int)seca->lifetime2);
  printf("lifetype=%u\n", seca->lifetype);
  printf("iv: ");
  dump_buf((caddr_t)seca->iv, seca->ivlen);
  printf("key: ");
  dump_buf((caddr_t)seca->key, seca->keylen);
  printf("src: ");
  dump_smart_sockaddr(seca->src);
  printf("dst: ");
  dump_smart_sockaddr(seca->dst);
  printf("from: ");
  dump_smart_sockaddr(seca->from);
#endif /* defined(_GENERIC_DEBUG) && defined(KEY_DEBUG) */
}
#endif /* KERNEL */

/*----------------------------------------------------------------------
 * Dump a key_msghdr structure
 ----------------------------------------------------------------------*/
void dump_keymsghdr DEFARGS((km),
     struct key_msghdr *km)
{
#if defined(_GENERIC_DEBUG) && defined(KEY_DEBUG)
  if (km) {
    printf("key_msglen=%d\n", km->key_msglen);
    printf("key_msgvers=%d\n", km->key_msgvers);
    printf("key_msgtype=%d\n", km->key_msgtype);    
    printf("key_pid=%d\n", km->key_pid);
    printf("key_seq=%d\n", km->key_seq);
    printf("key_errno=%d\n", km->key_errno);
    printf("type=0x%x\n", (unsigned int)km->type);
    printf("state=0x%x\n", (unsigned int)km->state);
    printf("label=0x%x\n", (unsigned int)km->label);
    printf("spi=0x%x\n", (unsigned int)km->spi);
    printf("keylen=%d\n", km->keylen);
    printf("ivlen=%d\n", km->ivlen);
    printf("algorithm=%d\n", km->algorithm);
    printf("lifetype=0x%x\n", (unsigned int)km->lifetype);
    printf("lifetime1=%u\n", (unsigned int)km->lifetime1);
    printf("lifetime2=%u\n", (unsigned int)km->lifetime2);
  } else
    printf("key_msghdr pointer is NULL!\n");
#endif /* defined(_GENERIC_DEBUG) && defined(KEY_DEBUG) */
}


/*----------------------------------------------------------------------
 * Dump a key_msgdata structure
 ----------------------------------------------------------------------*/
void dump_keymsginfo DEFARGS((kp),
     struct key_msgdata *kp)
{
#if defined(_GENERIC_DEBUG) && defined(KEY_DEBUG)
  if (kp) {
    printf("src addr:\n");
    dump_smart_sockaddr(kp->src);
    printf("dest addr:\n");
    dump_smart_sockaddr(kp->dst);
    printf("from addr:\n");
    dump_smart_sockaddr(kp->from);
    printf("iv is:\n");
    dump_buf((caddr_t)kp->iv, kp->ivlen);
    printf("key is:\n");
    dump_buf((caddr_t)kp->key, kp->keylen);
#undef dumpbuf    
  } else
    printf("key_msgdata point is NULL!\n");
#endif /* defined(_GENERIC_DEBUG) && defined(KEY_DEBUG) */
}

#ifdef KERNEL
struct malloc_datum {
  void *p;
  struct malloc_datum *next;
  unsigned int len;
  char type[100];
};

struct malloc_datum *malloc_data = (struct malloc_datum *)0;

void *key_debug_malloc(int n, char *t)
{
  void *p = NULL;
  struct malloc_datum **m;
  CRITICAL_DCL

  CRITICAL_START;

  if (key_debug_level >= IDL_MAJOR_EVENT)
    printf(">key_debug_malloc(int n = %x, char *t = %s)\n", n, t);

  for (m = &malloc_data; *m; m = &((*m)->next));
  REAL_KMALLOC(*m, struct malloc_datum *, sizeof(struct malloc_datum));
  if (!*m) {
    if (key_debug_level >= IDL_ERROR)
      printf("key_debug_malloc: alloc of struct malloc_datum failed\n");
    goto ret;
  }
  REAL_KMALLOC(p, void *, n);
  if (!p) {
    REAL_KFREE(*m);
    printf("key_debug_malloc: alloc of n=%x failed\n", n);
    goto ret;
  }
  bzero((*m), sizeof(struct malloc_datum));
  (*m)->p = p;
  (*m)->len = n;
  strcpy((*m)->type, t);

  if (key_debug_level >= IDL_MAJOR_EVENT)
    printf("<key_debug_malloc = %08x\n", (unsigned int)p);

ret:
  CRITICAL_END;
  return p;
}

void key_debug_free(void *p)
{
  struct malloc_datum **m, *m2;
  CRITICAL_DCL

  CRITICAL_START;

  if (key_debug_level >= IDL_MAJOR_EVENT)
    printf(">key_debug_free(void *p = %08x)\n", (unsigned int)p);

  for (m = &malloc_data; *m && ((*m)->p != p); m = &((*m)->next));

  if (*m) {
    m2 = *m;
    *m = m2->next;
    if (key_debug_level >= IDL_EVENT)
      printf("key_debug_free: freeing %08x, len=%d type=%s\n", (unsigned int)m2, m2->len, m2->type);
    REAL_KFREE(p);
    REAL_KFREE(m2);
  } else {
    if (key_debug_level >= IDL_ERROR)
      printf("key_debug_free: p=%08x not on allocated list!\n", (unsigned int)p);
  }

  if (key_debug_level >= IDL_MAJOR_EVENT)
    printf("<key_debug_free\n");

  CRITICAL_END;
}

void key_debug_free_len(void *p, int n)
{
  struct malloc_datum **m, *m2;
  CRITICAL_DCL

  CRITICAL_START;

  if (key_debug_level >= IDL_MAJOR_EVENT)
    printf(">key_debug_free_len(void *p = %08x, int n = %x)\n", (unsigned int)p, (unsigned int)n);

  for (m = &malloc_data; *m && ((*m)->p != p); m = &((*m)->next));

  if (*m) {
    m2 = *m;
    *m = m2->next;
    if (key_debug_level >= IDL_EVENT)
      printf("key_debug_free_len: freeing %08x, type=%s\n", (unsigned int)m2, m2->type);
    if (m2->len != n)
      if (key_debug_level >= IDL_ERROR)
        printf("key_debug_free_len: p=%08x n=%x type=%s real len is %x!\n", (unsigned int)p, (unsigned int)n, m2->type, m2->len);
    REAL_KFREE(p);
    REAL_KFREE(m2);
  } else {
    if (key_debug_level >= IDL_ERROR)
      printf("key_debug_free: p=%08x n=%x not on allocated list!\n", (unsigned int)p, (unsigned int)n);
  }

  if (key_debug_level >= IDL_MAJOR_EVENT)
    printf("<key_debug_free_len\n");

  CRITICAL_END;
}

void key_debug_allocdump __P((void))
{
  struct malloc_datum *m;
  CRITICAL_DCL

  CRITICAL_START;

  if (key_debug_level >= IDL_MAJOR_EVENT)
    printf(">key_debug_allocdump()\n");

  for (m = malloc_data; m; m = m->next)
    printf("%08x: p=%08x len=%x type=%s next=%08x\n", (unsigned int)m, (unsigned int)m->p, m->len, m->type, (unsigned int)m->next);

  if (key_debug_level >= IDL_MAJOR_EVENT)
    printf("<key_debug_allocdump\n");

  CRITICAL_END;
}

void key_debug_free_all __P((void))
{
  struct malloc_datum *m, *m2;
  CRITICAL_DCL

  CRITICAL_START;

  if (key_debug_level >= IDL_MAJOR_EVENT)
    printf(">key_debug_free_all()\n");

  if ((m = malloc_data)) {
    if (key_debug_level >= IDL_ERROR)
      printf("key_debug_free_all: memory objects that would be leaked:\n");

    while(m) {
      if (key_debug_level >= IDL_ERROR)
        printf("%08x: p=%08x len=%x type=%s next=%08x\n", (unsigned int)m, (unsigned int)m->p, m->len, m->type, (unsigned int)m->next);
      REAL_KFREE(m->p);
      m2 = m;
      m = m->next;
      REAL_KFREE(m2);
    }
  }

  if (key_debug_level >= IDL_MAJOR_EVENT)
    printf("<key_debug_free_all()\n");

  CRITICAL_END;
}
#endif /* KERNEL */
