#!/bin/sh
#
#  resync-gnupg-ring-from-sql.sh
#
#  grab the GPG keys from the key-cert objects in the sql database and feed them to
#  GPG to re-create the local key ring
#
#  DA 20001214
#  EG 20010415
#
# This momentarily only with GPG 1.0.4b
# (still in devel), the first version that has --ignore-crc-error
# implemented. The option is needed because some keys couldn't be imported
# for CRC errors, but actually they aren't wrong, it's only the fault
# of bad mailers.

# Copyright (c) 2002                                        RIPE NCC
#
# All Rights Reserved
#
# Permission to use, copy, modify, and distribute this software and its
# documentation for any purpose and without fee is hereby granted,
# provided that the above copyright notice appear in all copies and that
# both that copyright notice and this permission notice appear in
# supporting documentation, and that the name of the author not be
# used in advertising or publicity pertaining to distribution of the
# software without specific, written prior permission.
#
# THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
# ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS; IN NO EVENT SHALL
# AUTHOR BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY
# DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
# AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
# OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.


PREFIX="/export/db/utils"
GNUPGHOME="/tmp/.gnupg"; export GNUPGHOME

# gpg binary. Must be a versin that supports --ignore-crc-error option.
GPG=/opt/gnupg-1.0.4d/bin/gpg
TMPFILE="/tmp/gpgtmp.$$"

# DB variables. Change according to your system. 
SQLHOST=localhost
SQLPORT=3306
SQLUSER=dbuser
SQLPASS=dbpassword
SQLDB=DBNAME


mkdir -p $GNUPGHOME

rm -f $GNUPGHOME/pubring.gpg

$PREFIX/extract-keycerts-sql.pl $SQLHOST $SQLPORT $SQLUSER $SQLPASS $SQLDB > $TMPFILE
$GPG --import --batch --ignore-crc-error $TMPFILE

#rm -f $TMPFILE

# eof

