/***************************************
  $Revision: 1.2 $

  Error reporting (er) er_formats.{m4,h} - definition of error formats
                              error reporting module.

  Status: NOT REVUED, TESTED, 

  Design and implementation by: Marek Bukowy

  ******************/ /******************
  Copyright (c) 1999                              RIPE NCC
 
  All Rights Reserved
  
  Permission to use, copy, modify, and distribute this software and its
  documentation for any purpose and without fee is hereby granted,
  provided that the above copyright notice appear in all copies and that
  both that copyright notice and this permission notice appear in
  supporting documentation, and that the name of the author not be
  used in advertising or publicity pertaining to distribution of the
  software without specific, written prior permission.
  
  THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS; IN NO EVENT SHALL
  AUTHOR BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY
  DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
  OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
  ***************************************/

/* 
NOTE:  modify the m4 file only, do not change the resulting .h !!!
*/

#ifndef ER_FORMATS_H
#define ER_FORMATS_H


typedef struct {
  char *n;
  int v;
} er_form_el;

#ifdef ER_IMPL
#define EXTDEF
#define EXTINI(a,b) a = b;
#else
#define EXTDEF extern 
#define EXTINI(a,b) extern a;
#endif

/* m4 macro: #define a symbol and put its string version into the array
   at the same time. The string version will have "ASP_" cut off if
   the string begins with it. The #defines are diverted to stream 9, so
   they appear later in the output (outside the ifdef/endif block)
*/
define( `BITSHIFT', `0' )
define( `BLUP', `dnl
divert(9)    { "$1", ER_M_$1 },
divert ER_M_$1 = (1<<BITSHIFT),
define(`BITSHIFT', eval(BITSHIFT+1))dnl' )

typedef enum {
   
BLUP(SEVCHAR)    /* one-letter severity indication */
BLUP(SEVLONG)    /* long severity indication */
BLUP(MNEMONIC)   /* error mnemonic */	
BLUP(TEXTLONG)   /* error text */
BLUP(UIDUID)     /* real user id */
BLUP(UIDEUID)    /* effective user id */
BLUP(PIDFULL)    /* process id's */
BLUP(FACSYMB)    /* facility symbol */
BLUP(PROGNAME)   /* program name (argv[0]) */
BLUP(DATETIME)   /* current date and time */
BLUP(THR_ID)     /* thread id */
 __ER_fmt_slack  /* to close the list after the last comma */

} er_format_mt; 


EXTDEF
er_form_el er_formarr[]
#ifdef ER_IMPL
= {
/* m4 - paste the definitions here */
undivert(9) 
  {NULL, 0} 
}
#endif /* ER_IMPL */
;


#endif /* ER_FORMATS_H */
