/***************************************
  $Revision: 1.16 $

  Error reporting (er) er_aspects.{m4,h} - definition of error aspects 
				for the error reporting module 

  Status: NOT REVUED, TESTED, 

  Design and implementation by: Marek Bukowy

  ******************/ /******************
  Copyright (c) 1999,2000,2001,2002               RIPE NCC
 
  All Rights Reserved
  
  Permission to use, copy, modify, and distribute this software and its
  documentation for any purpose and without fee is hereby granted,
  provided that the above copyright notice appear in all copies and that
  both that copyright notice and this permission notice appear in
  supporting documentation, and that the name of the author not be
  used in advertising or publicity pertaining to distribution of the
  software without specific, written prior permission.
  
  THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS; IN NO EVENT SHALL
  AUTHOR BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY
  DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
  OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
  ***************************************/

/* 
NOTE:  modify the m4 file only, do not change the resulting .h !!!
*/

#ifndef ER_ASPECTS_H
#define ER_ASPECTS_H

#include "erroutines.h"

typedef struct {
  er_fac_code_t f;  
  char *n;
  int v;
} er_aspstr_t;

#ifdef ER_IMPL
#define EXTDEF
#define EXTINI(a,b) a = b;
#else
#define EXTDEF extern 
#define EXTINI(a,b) extern a;
#endif

/* m4 macro: #define a symbol and put its string version into the array
   at the same time. The string version will have "ASP_" cut off if
   the string begins with it. The #defines are diverted to stream 9, so
   they appear later in the output (outside the ifdef/endif block)
*/
define( `BLUP', `divert(9) { FAC_$1, "$1_$2", ASP_$1_$2  },
divert ASP_$1_$2 = $3 ')


typedef enum {
   
  /* 0x20000000 - 0x01000000  are reserved for global tags */
  
  /* RADIX: */
BLUP(RX, NODCRE_GEN, 0x000080),     /* general node creation tag */
BLUP(RX, NODCRE_DET, 0x000040),     /* also details on node creation */
     
BLUP(RX, STKBLD_GEN, 0x000020),     /* general stack building */
BLUP(RX, STKBLD_DET, 0x000010),     /* also detailed stack building */
     
BLUP(RX, SRCH_GEN,   0x000800),     /* search */
BLUP(RX, SRCH_DET,   0x000400),
     
BLUP(RX, TREE_GEN,   0x002000),     /* general tree/forest administration */
BLUP(RX, TREE_DET,   0x001000),     /* detailed */
     
BLUP(RX, TREE_WALK,  0x000001),


  /* Radix payload */
BLUP(RP, PACK_DET,   0x000100),    /* pack conversion */
BLUP(RP, TREE_DET,   0x001000),    /* finding tree in forest */
BLUP(RP, LOAD_GEN,   0x010000),    /* loading of trees */
BLUP(RP, LOAD_DET,   0x000010),    /* loading of trees - detailed */
BLUP(RP, SRCH_DATA,  0x000040),    /* search - display 'immediate data' */
BLUP(RP, SRCH_DET,   0x004000),    /* search - detailed */
BLUP(RP, SRCH_GEN,   0x040000),    /* search - general */

  
  /* Query instructions */ 
BLUP(QI, LAST_DET,   0x000010),    /* ids of the objects from the LAST table */
BLUP(QI, SKIP,       0x004000),    /* query skipped */ 

BLUP(QI, REF_DET,    0x010000),    /* referral, detailed */
BLUP(QI, REF_GEN,    0x020000),    /* referral */

BLUP(QI, COLL_DET,   0x100000),    /* id collection (exec. of subqueries) */
BLUP(QI, COLL_GEN,   0x200000),    /* query list */
BLUP(QI, WATCH,      0x080000),    /* watchdog */

  /* Query command */
BLUP(QC, BUILD,      0x800000),    /* query preparation */

  /* Threads */
BLUP(TH, NEW,        0x800000),    /* new thread */
  
  /* Sockets */
BLUP(SK, GEN,        0x000100),    /* general aspect */
BLUP(SK, WRIT,       0x000001),    /* writing functions; buffer printed too */
BLUP(SK, WATCH,      0x000800),    /* watchdog */

  /* Protocol whois */
BLUP(PW, CONN,       0x001000),    /* connection opened */
  
  /* Protocol whois - aspects for INFO (log) messages */
BLUP(PW, I_PASSUN,    0x010000),    /* unauthorised address passing */
BLUP(PW, I_QRYLOG,    0x100000),    /* log query after it's been processed */
BLUP(PW, I_DENTRY,    0x200000),    /* log connection from a denied host */
		
BLUP(SQ, QRYTIME,    0x000100),     /* log the query,result and time it took */
BLUP(SQ, ABORT,      0x001000),    /* aborting a sql connection */  

BLUP(PM, INPUT,    	0x000010),    /* log the query */
BLUP(PM, ERESP,  	0x000001),    /* print server error responses */

  /* MIME Parser module */
BLUP(MM, GEN,        0x000100),     /* General aspect */
BLUP(MM, SEC,        0x001000),     /* Security-related aspect */

  /* Main server (sv) */
BLUP(SV, PORT,       0x000100),    /* listing ports */

  /* UD - core update process */
BLUP(UD, SQL,        0x000010),     /* print SQL queries */
BLUP(UD, OBJ,        0x000100),     /* trace object update process */
BLUP(UD, UPDLOG,     0x001000),     /* print summary information */

  /* Access control */
BLUP(AC, DECAY,      0x000100),    /* decaying process */
BLUP(AC, PRUNE_DET,  0x000010),    /* pruning the access tree, detailed */
BLUP(AC, I_PERMBAN,  0x002000),    /* a permanent ban was set */

  /* Protocol Config */
BLUP(PC, I_SESSION,  0x000100),    /* session event: log on, log off, auth fail */
BLUP(PC, I_COMMAND,  0x000200),    /* command executed */

  /* UP - dbupdate module */
BLUP(UP, FILE, 0x000001),      /* File related */
BLUP(UP, GEN,  0x000010),      /* General */

  /* Public Authentication (GPG) module */
BLUP(PA, GEN,        0x000100),     /* General aspect */

  /* utility module */
BLUP(UT, MEM,  0x00000001 ),   /* Memory related */
BLUP(UT, FD,   0x00000010 ),   /* File descriptor related */

ASP_NONE = 0

} er_aspect_en;

EXTDEF
er_aspstr_t er_asparr[]
#ifdef ER_IMPL
 = {

undivert(9) /* m4 - paste the definitions here */

   {FAC_NONE, NULL, 0} 
}
#endif /* ER_IMPL */
; 


unsigned int ER_aspval(char *key);

#endif /* ER_ASPECTS_H */

