#include <stdio.h>
#include <stdlib.h>
#include "ca_defs.h"
#include "ca_configFns.h"
#include "ca_dictionary.h"


int ca_sanityCheck(values_t confVars[])
/*
	- does a simple sanity check
 - Parameters
		- confVars - the array of configuration variables
 - Returns 
		- an integer: -1 or 0
 */
{
int symbol;	/* A counting variable */
int status = 0;	/* Assume that the Configuration File is complete. */
int undefVars = 0; /* Number of undefined variables. */
const char *configWarningStr = "Warning: undefined configuration variable:";
const char *configError_1Str = "Error: Incomplete configuration file.  Please check if this was intended.\n";
const char *configError_2Str = " configuration variables undefined.\n";

/*
	* We use CA_NUMBEROFSYMBOLS instead of VARS .....
 */

for(symbol = 0; symbol < CA_NUMBEROFSYMBOLS; symbol++)
	{
	if (!confVars[symbol].strPtr)
		{
		++undefVars;
		fprintf(stderr, "%s %s\n", configWarningStr, dictionary[symbol]);
		}
	}

if (undefVars)
	{
	status = INCOMPLETE;
	}

	fprintf(stderr, "\n%s\n", configError_1Str);
 fprintf(stderr, "%d%s\n", undefVars, configError_2Str);
 return(status);
}

int ca_conifigCheck(void)
/*
	* A wrapper for the ca_sanityCheck() function.A
 *
 * Parameters
	*	- none
 *
 * Returns
	* -nothing
 */
{
return(ca_sanityCheck(confVars));
}
