/***************************************
  $Revision: 1.16 $

  Semi-internal header file for UD module

  Status: NOT REVUED, NOT TESTED

 Author(s):       Andrei Robachevsky

  ******************/ /******************
  Modification History:
        andrei (17/01/2000) Created.
  ******************/ /******************
  Copyright (c) 2000                              RIPE NCC
 
  All Rights Reserved
  
  Permission to use, copy, modify, and distribute this software and its
  documentation for any purpose and without fee is hereby granted,
  provided that the above copyright notice appear in all copies and that
  both that copyright notice and this permission notice appear in
  supporting documentation, and that the name of the author not be
  used in advertising or publicity pertaining to distribution of the
  software without specific, written prior permission.
  
  THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS; IN NO EVENT SHALL
  AUTHOR BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY
  DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
  OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 ***************************************/
#ifndef _UD_INT_H
#define _UD_INT_H

#include <stdio.h>
#include <strings.h>
#include <glib.h>
#include <stdlib.h>
#include <ctype.h>
#include <unistd.h>

#include "defs.h"
#include "mysql_driver.h"
#include "iproutines.h"
#include "erroutines.h"
#include "rp.h"
#include "nh.h"
#include "sk.h"

#include "ca_configFns.h"
#include "ca_dictSyms.h"
#include "ca_macros.h"
#include "ca_srcAttribs.h"




#include "globaldefs.h"
/* #include "isnic.h" */
#include "bitmask.h"
#include "which_keytypes.h"


/*+ String sizes +*/
#define STR_S   63
#define STR_M   255
#define STR_L   1023
#define STR_XL  4095
#define STR_XXL 16383
#define STR_XXXL 65535


#define MAX_NIC_HDL  30


/* class type for dummy objects */
#define DUMMY_TYPE	100


typedef struct _Attribute_t { 
  A_Type_t type;
  char *value;
} Attribute_t;

typedef struct _Object_t {
  C_Type_t type;
  long id;
  GSList *attributes;
  GString *object;
} Object_t;


typedef struct _obj_parse_t {
	Object_t *obj;
	char *object_name;
	GSList *class_attr_list;
	nic_handle_t *nh_ptr;
	int a_type;
	int start_object;
} Obj_parse_t;

#define MAX_DUMMIES 256

typedef struct _Transaction {
  int thread_ins;      /* Thread number to mark(backup) creates */
  int thread_upd;      /* Thread number to mark(backup) updates */
  SQ_connection_t *sql_connection;
  Object_t *object;    /* ptr to the object */
  C_Type_t class_type;
  long object_id;      /* Object id which the transaction is carried out for */
  long sequence_id;    /* for last and history tables */
  long serial_id;      /* serial ID, kept for crash recovery */
  long transaction_id; /* ID of DBuopdate transaction */
  /* int dummy; */     /* Permission to create dummies for PE, RO objects (initial population) */
  int ndummy; /* number of attempts to create dummy */
  long dummy_id[MAX_DUMMIES]; /* to store object_id's of dummies */
  int load_pass; /* No. of the pass for initial loading , 0 otherwise */
  /* XXX later we should merge 'standalone' & 'dummy' into single 'mode' bitmask */
  /* int standalone; *//* 0 if server */ 
  /* XXX later we should merge 'succeeded' & 'error' into single 'succeeded' bitmask */
  int action; /* indicates wether we are updating/deleting creating a new object */
  int mode;
  int succeeded;
  int error;
  GString *error_script;
  GString *query;
  GString *K;
  char *save; /* for saving attribute (U2 & pn:) values */ 
  rp_upd_pack_t *packptr; /* To store radix tree data */
  nic_handle_t *nh; /* To store NIC handle data */
  ca_dbSource_t *source_hdl;
  int socket; /* socket to report to DBupdate */
} Transaction_t;

/*++++++++++++++++++++++++++++++++++++++++++++*/

/* Definitions for "refer" (domain referral mechanism) */
#define S_RIPE "RIPE"
#define S_INTERNIC "InterNIC"
#define S_SIMPLE "SIMPLE"
#define S_CLIENTADDERSS "CLIENTADDRESS"


typedef enum {
 RF_RIPE=1,
 RF_INTERNIC,
 RF_SIMPLE,
 RF_CLIENTADDRESS
} refer_t;

#define RF_DEF_PORT	43


struct _nrtm {
 char *server; /* the hostname of the server */
 int port;
 int version;
 long current_serial;
 Transaction_t *tr;
 char object_name[STR_XXL];
 int op;
};
       
typedef struct _Log_t {
 int num_ok;
 int num_failed;
/* FILE *logfile; */
} Log_t;

typedef struct UD_stream_t_ {
 FILE * stream;
 sk_conn_st condat;
 int num_skip;
 int load_pass;
 int ud_mode;
 struct _nrtm *nrtm;
 SQ_connection_t *db_connection;
 ca_dbSource_t *source_hdl; /* source we are mirroring */
 Log_t log; 
 char *error_script;
} UD_stream_t;
         



/*++++++++++++++++++ Function Prototypes +++++++++++++++++++++*/

int get_NRTM_fd(struct _nrtm *nrtm, int upto_last, char *source);

int UD_process_stream(UD_stream_t *ud_stream);

int object_process(Transaction_t *tr);

int UD_commit(Transaction_t *tr);
int UD_commit_I(Transaction_t *tr);
int UD_commit_II(Transaction_t *tr);


int UD_rollback(Transaction_t *tr);

int UD_delete(Transaction_t *tr);

int UD_update_rx(Transaction_t *tr, rx_oper_mt mode);

int UD_ack(Transaction_t* tr);
int UD_check_ref(Transaction_t *tr);

int isdummy(Transaction_t *tr);
long get_object_id(Transaction_t *tr);
long get_sequence_id(Transaction_t *tr);
char *get_field_str(SQ_connection_t *sql_connection, char *field,
                 char *ref_tbl_name, char *ref_name,
                 char * attr_value, char *condition);
char *get_qresult_str(SQ_connection_t *sql_connection, char *query);                 


void attribute_free(void *data, void *ptr);

Attribute_t *attribute_upd(Attribute_t *attr, int newtype, char *newvalue);

Attribute_t *attribute_new1(int type, const char *value);

Attribute_t *attribute_new(const char *line);

void object_free(Object_t *obj);

Object_t *object_new(const char *line);

void transaction_free(Transaction_t *tr);

Transaction_t *transaction_new(SQ_connection_t *sql_connection, C_Type_t class_type);

void get_rx_data(void *element_data, void *tr_ptr);

void ud_parse_init(Obj_parse_t *parse);
void ud_parse_free(Obj_parse_t *parse);
Object_t *UD_parse_object(SQ_connection_t *sql_connection, Obj_parse_t *parse, char *line_buff);



#if 0
void set_rx_orig(rx_bin_data_t *rx_data, char *origin);
void set_rx_pref4(char *avalue, rx_bin_data_t *rx_data, 
		  unsigned *prefix, unsigned *prefix_length);
void set_rx_pref6(char *avalue, rx_bin_data_t *rx_data, 
		  ip_v6word_t *high, ip_v6word_t *low, unsigned *prefix_length);
void set_rx_rang(char *avalue, rx_inum_data_t *rx_data, 
		 unsigned *begin_in, unsigned *end_in);
int update_rx_inum(rx_oper_mt mode, rx_regid_t reg_id, rx_inum_data_t *rx_data, long in_id);
int update_rx_bin(rx_oper_mt mode, rx_regid_t reg_id, rx_bin_data_t *rx_data, long rt_id);
int update_rx_dom(rx_oper_mt mode, rx_regid_t reg_id, rx_dom_data_t *rx_data, long dn_id);
#endif

char *convert_rf(char *avalue, int *type, int *port);
int convert_as_range(const char *as_range, int *begin, int *end);
time_t convert_time(char *asc_time);

int UD_lock_serial(Transaction_t *tr);
int UD_unlock_serial(Transaction_t *tr);
long UD_create_serial(Transaction_t *tr);
int UD_comrol_serial(Transaction_t *tr, int commit);

#define UD_commit_serial(tr) UD_comrol_serial(tr, 1)
#define UD_rollback_serial(tr) UD_comrol_serial(tr, 0)
#endif /* _UD_INT_H */




