/***************************************
  $Revision: 1.17 $

  Error reporting (er) er_aspects.{m4,h} - definition of error aspects 
				for the error reporting module 

  Status: NOT REVUED, TESTED, 

  Design and implementation by: Marek Bukowy

  ******************/ /******************
  Copyright (c) 1999                              RIPE NCC
 
  All Rights Reserved
  
  Permission to use, copy, modify, and distribute this software and its
  documentation for any purpose and without fee is hereby granted,
  provided that the above copyright notice appear in all copies and that
  both that copyright notice and this permission notice appear in
  supporting documentation, and that the name of the author not be
  used in advertising or publicity pertaining to distribution of the
  software without specific, written prior permission.
  
  THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS; IN NO EVENT SHALL
  AUTHOR BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY
  DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
  OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
  ***************************************/

/* 
NOTE:  modify the m4 file only, do not change the resulting .h !!!
*/

#include "erroutines.h"

typedef struct {
  er_fac_code_t f;  
  char *n;
  int v;
} er_aspstr_t;

#ifdef ER_IMPL
#define EXTDEF
#define EXTINI(a,b) a = b;
#else
#define EXTDEF extern 
#define EXTINI(a,b) extern a;
#endif

/* m4 macro: #define a symbol and put its string version into the array
   at the same time. The string version will have "ASP_" cut off if
   the string begins with it. The #defines are diverted to stream 9, so
   they appear later in the output (outside the /endif block)
*/



typedef enum {
   
  /* 0x20000000 - 0x01000000  are reserved for global tags */
  
  /* RADIX: */
 ASP_RX_NODCRE_GEN = 0x000080 ,     /* general node creation tag */
 ASP_RX_NODCRE_DET = 0x000040 ,     /* also details on node creation */
     
 ASP_RX_STKBLD_GEN = 0x000020 ,     /* general stack building */
 ASP_RX_STKBLD_DET = 0x000010 ,     /* also detailed stack building */
     
 ASP_RX_SRCH_GEN = 0x000800 ,     /* search */
 ASP_RX_SRCH_DET = 0x000400 ,
     
 ASP_RX_TREE_GEN = 0x002000 ,     /* general tree/forest administration */
 ASP_RX_TREE_DET = 0x001000 ,     /* detailed */
     
 ASP_RX_TREE_WALK = 0x000001 ,


  /* Radix payload */
 ASP_RP_PACK_DET = 0x000100 ,    /* pack conversion */
 ASP_RP_TREE_DET = 0x001000 ,    /* finding tree in forest */
 ASP_RP_LOAD_GEN = 0x010000 ,    /* loading of trees */
 ASP_RP_LOAD_DET = 0x000010 ,    /* loading of trees - detailed */
 ASP_RP_SRCH_DATA = 0x000040 ,    /* search - display 'immediate data' */
 ASP_RP_SRCH_DET = 0x004000 ,    /* search - detailed */
 ASP_RP_SRCH_GEN = 0x040000 ,    /* search - general */

  
  /* Query instructions */ 
 ASP_QI_LAST_DET = 0x000010 ,    /* ids of the objects from the LAST table */
 ASP_QI_SKIP = 0x004000 ,    /* query skipped */ 

 ASP_QI_REF_DET = 0x010000 ,    /* referral, detailed */
 ASP_QI_REF_GEN = 0x020000 ,    /* referral */

 ASP_QI_COLL_DET = 0x100000 ,    /* id collection (exec. of subqueries) */
 ASP_QI_COLL_GEN = 0x200000 ,    /* query list */

  /* Query command */
 ASP_QC_BUILD = 0x800000 ,    /* query preparation */

  /* Threads */
 ASP_TH_NEW = 0x800000 ,    /* new thread */
  
  /* Sockets */
 ASP_SK_GEN = 0x000100 ,    /* general aspect */
 ASP_SK_WRIT = 0x000001 ,    /* writing functions; buffer printed too */

  /* Protocol whois */
 ASP_PW_CONN = 0x001000 ,    /* connection opened */
  
  /* Protocol whois - aspects for INFO (log) messages */
 ASP_PW_I_PASSUN = 0x010000 ,    /* unauthorised address passing */
 ASP_PW_I_QRYLOG = 0x100000 ,    /* log query after it's been processed */
 ASP_PW_I_DENTRY = 0x200000 ,    /* log connection from a denied host */
		
 ASP_SQ_QRYTIME = 0x000100 ,     /* log the query,result and time it took */
 ASP_SQ_ABORT = 0x001000 ,    /* aborting a sql connection */  

 ASP_PM_INPUT = 0x000010 ,    /* log the query */
 ASP_PM_ERESP = 0x000001 ,    /* print server error responses */

  /* MIME Parser module */
 ASP_MM_GEN = 0x000100 ,     /* General aspect */

  /* Main server (sv) */
 ASP_SV_PORT = 0x000100 ,    /* listing ports */

  /* UD - core update process */
 ASP_UD_SQL = 0x000010 ,     /* print SQL queries */
 ASP_UD_OBJ = 0x000100 ,     /* trace object update process */
 ASP_UD_UPDLOG = 0x001000 ,     /* print summary information */

  /* Access control */
 ASP_AC_DECAY = 0x000100 ,    /* decaying process */
 ASP_AC_I_PERMBAN = 0x002000 ,    /* a permanent ban was set */

  /* Protocol Config */
 ASP_PC_I_SESSION = 0x000100 ,    /* session event: log on, log off, auth fail */
 ASP_PC_I_COMMAND = 0x000200 ,    /* command executed */

  /* UP - dbupdate module */
 ASP_UP_FILE = 0x000001 ,      /* File related */
 ASP_UP_GEN = 0x000010 ,      /* General */

ASP_NONE = 0

} er_aspect_en;

EXTDEF
er_aspstr_t er_asparr[]
#ifdef ER_IMPL
 = {

 { FAC_RX, "RX_NODCRE_GEN", ASP_RX_NODCRE_GEN  },
 { FAC_RX, "RX_NODCRE_DET", ASP_RX_NODCRE_DET  },
 { FAC_RX, "RX_STKBLD_GEN", ASP_RX_STKBLD_GEN  },
 { FAC_RX, "RX_STKBLD_DET", ASP_RX_STKBLD_DET  },
 { FAC_RX, "RX_SRCH_GEN", ASP_RX_SRCH_GEN  },
 { FAC_RX, "RX_SRCH_DET", ASP_RX_SRCH_DET  },
 { FAC_RX, "RX_TREE_GEN", ASP_RX_TREE_GEN  },
 { FAC_RX, "RX_TREE_DET", ASP_RX_TREE_DET  },
 { FAC_RX, "RX_TREE_WALK", ASP_RX_TREE_WALK  },
 { FAC_RP, "RP_PACK_DET", ASP_RP_PACK_DET  },
 { FAC_RP, "RP_TREE_DET", ASP_RP_TREE_DET  },
 { FAC_RP, "RP_LOAD_GEN", ASP_RP_LOAD_GEN  },
 { FAC_RP, "RP_LOAD_DET", ASP_RP_LOAD_DET  },
 { FAC_RP, "RP_SRCH_DATA", ASP_RP_SRCH_DATA  },
 { FAC_RP, "RP_SRCH_DET", ASP_RP_SRCH_DET  },
 { FAC_RP, "RP_SRCH_GEN", ASP_RP_SRCH_GEN  },
 { FAC_QI, "QI_LAST_DET", ASP_QI_LAST_DET  },
 { FAC_QI, "QI_SKIP", ASP_QI_SKIP  },
 { FAC_QI, "QI_REF_DET", ASP_QI_REF_DET  },
 { FAC_QI, "QI_REF_GEN", ASP_QI_REF_GEN  },
 { FAC_QI, "QI_COLL_DET", ASP_QI_COLL_DET  },
 { FAC_QI, "QI_COLL_GEN", ASP_QI_COLL_GEN  },
 { FAC_QC, "QC_BUILD", ASP_QC_BUILD  },
 { FAC_TH, "TH_NEW", ASP_TH_NEW  },
 { FAC_SK, "SK_GEN", ASP_SK_GEN  },
 { FAC_SK, "SK_WRIT", ASP_SK_WRIT  },
 { FAC_PW, "PW_CONN", ASP_PW_CONN  },
 { FAC_PW, "PW_I_PASSUN", ASP_PW_I_PASSUN  },
 { FAC_PW, "PW_I_QRYLOG", ASP_PW_I_QRYLOG  },
 { FAC_PW, "PW_I_DENTRY", ASP_PW_I_DENTRY  },
 { FAC_SQ, "SQ_QRYTIME", ASP_SQ_QRYTIME  },
 { FAC_SQ, "SQ_ABORT", ASP_SQ_ABORT  },
 { FAC_PM, "PM_INPUT", ASP_PM_INPUT  },
 { FAC_PM, "PM_ERESP", ASP_PM_ERESP  },
 { FAC_MM, "MM_GEN", ASP_MM_GEN  },
 { FAC_SV, "SV_PORT", ASP_SV_PORT  },
 { FAC_UD, "UD_SQL", ASP_UD_SQL  },
 { FAC_UD, "UD_OBJ", ASP_UD_OBJ  },
 { FAC_UD, "UD_UPDLOG", ASP_UD_UPDLOG  },
 { FAC_AC, "AC_DECAY", ASP_AC_DECAY  },
 { FAC_AC, "AC_I_PERMBAN", ASP_AC_I_PERMBAN  },
 { FAC_PC, "PC_I_SESSION", ASP_PC_I_SESSION  },
 { FAC_PC, "PC_I_COMMAND", ASP_PC_I_COMMAND  },
 { FAC_UP, "UP_FILE", ASP_UP_FILE  },
 { FAC_UP, "UP_GEN", ASP_UP_GEN  },
 /* m4 - paste the definitions here */

   {FAC_NONE, NULL, 0} 
}
#endif /* ER_IMPL */
; 


unsigned int ER_aspval(char *key);
