/***************************************
  $Revision: 1.2 $

  Error reporting (er) er_arrays.c - auxiliary routines for parameter arrays
 	
  Status: NOT REVUED, PARTLY TESTED

  Design and implementation by: Marek Bukowy

  ******************/ /******************
  Copyright (c) 1999,2000                              RIPE NCC
 
  All Rights Reserved
  
  Permission to use, copy, modify, and distribute this software and its
  documentation for any purpose and without fee is hereby granted,
  provided that the above copyright notice appear in all copies and that
  both that copyright notice and this permission notice appear in
  supporting documentation, and that the name of the author not be
  used in advertising or publicity pertaining to distribution of the
  software without specific, written prior permission.
  
  THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS; IN NO EVENT SHALL
  AUTHOR BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY
  DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
  OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
  ***************************************/

#include "erroutines.h"

er_ret_t er_getsevval(char *sev)
{
  int i;

  for(i=0; er_level_a[i].sev != 0; i++) {
    if( strcasecmp(er_level_a[i].chr, sev) == 0 ) {
      return er_level_a[i].sev;
    }
  }
  
  return 0;
}

char *er_getsevsym( int sev, int mode )
{
int i;

  for(i=0; er_level_a[i].sev != 0; i++) {
	if (er_level_a[i].sev == sev)  {
	    break;
	}
  }

  switch( mode & 0x03 ) {
  case ER_M_SEVCHAR:	/* one-letter severity indication */
    return er_level_a[i].chr;
  case ER_M_SEVLONG: 	/* long severity indication */
    return er_level_a[i].txt;
  }
  
  /* no severity indication */
  return "";	/* "" goes to program text, so returning a
		   pointer to it is OK */
}

char *er_getfacsym(er_fac_code_t faccode)
{
int facidx;

  if( faccode != FAC_NONE  )  {
    for (facidx=0; facidx<FAC_LAST; facidx++) {
      if( er_fac_err[facidx].code == faccode ) {
        break;
      }
    }
    return  er_fac_err[facidx].name;
  } 
  else	return "";
}

er_mask_t er_getfacval(char *key) 
{
  int i;

  for(i=0; er_fac_err[i].code != -1; i++) {
    if(strcasecmp(key,er_fac_err[i].name) == 0) {
      return er_fac_err[i].code;
    }
  }

  return 0; 
}

mask_t er_getfacallmask(void)
{
  int i = FAC_NONE;
  mask_t all = MA_new(MA_END);

  while( ++i != FAC_LAST ) {
    MA_set(&all, i, 1);
  }
  return all;
}

unsigned int er_getaspval(char *key)
{
  int i;

  for(i=0; er_asparr[i].n != NULL; i++) {
    if(strcasecmp(key,er_asparr[i].n) == 0) {
      return er_asparr[i].v;
    }
  }

  return 0; 
}




void er_getaspsym(mask_t facmask, int asp, GString *g_reply)
{
  int i, found=0;

  for(i=0; er_asparr[i].n != NULL; i++) {
    if(  MA_isset(facmask, er_asparr[i].f) && asp == er_asparr[i].v) {
      g_string_sprintfa(g_reply, "%s|", er_asparr[i].n);
      found = 1;
    }
  }
  
  if( !found ) {
    g_string_sprintfa(g_reply, "0x%x|", asp);
  }

  g_string_truncate(g_reply, strlen(g_reply->str)-1);
  
}

er_path_mt er_getpathval(char *key)
{
  int i;

  for(i=0;  er_pathtypes[i] != NULL; i++) {
    if(strcasecmp(key,er_pathtypes[i]) == 0) {
      return i;
    }
  }

  return -1; 
}

int er_getformatval(char *key)
{
 int i;

  for(i=0;  er_formarr[i].n != NULL; i++) {
    if(strcasecmp(key,er_formarr[i].n) == 0) {
      return er_formarr[i].v;
    }
  }

  return -1;  
}
