/* FP: interface file for RIPE gnuPG */

#define INPUT_FD 0
#define OUTPUT_FD 1
#define ERROR_FD 2

#define LINE_LENGTH 1024
#define STRING_LENGTH 255
#define FILENAME_LENGTH 1024

#define ERRSTRING strerror (errno)

/* FP : global objects used as and interface with gnuPG */

typedef unsigned int u32;

struct VerifySignObject {
  char iDocSigFilename[FILENAME_LENGTH],  /* IN  */
    iSigFilename[FILENAME_LENGTH],        /* IN  */
    outputPath[FILENAME_LENGTH],          /* IN  */
    oStream[FILENAME_LENGTH];             /* OUT */

  char keyRing[FILENAME_LENGTH];
  int isValid;
  u32 keyID;
  struct VerifySignObject *next;
};

struct ReadCryptedObject {
  char iFilename[FILENAME_LENGTH], 
       oStream[FILENAME_LENGTH];
  char keyRing[FILENAME_LENGTH];
  int isValid;
  u32 keyID;
};

struct ImportKeyObject {
  char iFilename[FILENAME_LENGTH];
  char keyRing[FILENAME_LENGTH];
  int rc;
  u32 keyID; /* check if it works */
};

enum {
   iKO_OK  = 0,
   iKO_UNCHANGED,
   iKO_NOUSERID,
   iKO_GENERAL,
   iKO_NOTVALIDUSERID,
   iKO_NOPUBLICKEY,
   iKO_NODEFAULTPUBLICKEYRING,
   iKO_CRC_ERROR,
   iKO_NO_OPENPGP_DATA,
   iKO_NO_IN_FILES,
   iKO_GENERALFAILURE
};

enum {
   vSO_KO  = 0,
   vSO_IS_VALID,
   vSO_CRC_ERROR,
   vSO_NO_PUBLIC_KEY,
   vSO_NO_OPENPGP_DATA,
   vSO_NO_IN_FILES,
   vSO_NO_OUT_FILES
};

#ifdef __cplusplus
extern "C" {
#endif

void PA_VerifySignature(struct VerifySignObject *vSO);
void PA_ImportKey(struct ImportKeyObject *iKO);
void PA_Decrypt(struct ReadCryptedObject *rDO);

#ifdef __cplusplus
 }
#endif
