/***************************************
  $Revision: 1.2 $

  Error reporting (er) er.c - er_RX_errors.h - definition of errors for the 
                              error reporting module (used in test only).

  Status: NOT REVUED, TESTED, 

  Design and implementation by: Marek Bukowy

  ******************/ /******************
  Copyright (c) 1999                              RIPE NCC
 
  All Rights Reserved
  
  Permission to use, copy, modify, and distribute this software and its
  documentation for any purpose and without fee is hereby granted,
  provided that the above copyright notice appear in all copies and that
  both that copyright notice and this permission notice appear in
  supporting documentation, and that the name of the author not be
  used in advertising or publicity pertaining to distribution of the
  software without specific, written prior permission.
  
  THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS; IN NO EVENT SHALL
  AUTHOR BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY
  DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
  OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
  ***************************************/

/* I see no way of automating things here... Maybe with a perl script.

   There are three things to do:
   1. Get a new integer number from the enum 
	(using a ??_LOW_<mnem> symbol)
   2. define a new error code (??_<mnem>) by adding the facility and
	severity codes.
   3. put the symbol (using macro ERDUP) and text of the message into the
	array. Should fit in one line with the macro.

   The order of codes in enum does NOT have to match the order of texts.
   The last in the texts array must be the ER_LASTTXT constant.

   Sounds familiar ? That's because facilities and errors are parts
   of the error reporting fractal :-)
*/


/* step 1 */

typedef enum {
	 ER_LOW_TOOSTU=0,
	 ER_LOW_TOOLAT
} ER_err_code_t;

/* step 2 */

#define ER_TOOSTU	ER_SEV_F + (FAC_ER<<16) + ER_LOW_TOOSTU
#define ER_TOOLAT	ER_SEV_E + (FAC_ER<<16) + ER_LOW_TOOLAT


/* step 3 */

#ifdef ER_IMPL
er_list_t ER_mod_err[]={
 { ERDUP(ER_TOOSTU),  "You're too stupid to use this. Program aborted" },
 { ERDUP(ER_TOOLAT),  "Now it's %u, it is too late for this to work!" },
 ER_LASTTXT
};

#endif /* ER_IMPL */
