ISO10163-SR-1  DEFINITIONS ::=

%{
#include "SR.h"
%}


BEGIN   -- ISO10163-SR-1 refers to the ISO standard 10163 version 1

SECTIONS encode decode print

--

SR-APDU [[P struct _SR_APDU *]] ::= CHOICE
    {
      initialiseRequest               [20]  ANY [[a pe]],
      initialiseResponse              [21]  ANY [[a pe]],
      searchRequest                   [22]  ANY [[a pe]],
      searchResponse                  [23]  ANY [[a pe]],
      presentRequest                  [24]  ANY [[a pe]],
      presentResponse                 [25]  ANY [[a pe]],
      deleteResultSetRequest          [26]  ANY [[a pe]],
      deleteResultSetResponse         [27]  ANY [[a pe]]
            -- new APDUs can be added in the future at the end of this list.
    }

XSR-APDU ::= CHOICE
    {
      initialiseRequest               [20]  IMPLICIT InitialiseRequest,
      initialiseResponse              [21]  IMPLICIT InitialiseResponse,
      searchRequest                   [22]  IMPLICIT SearchRequest,
      searchResponse                  [23]  IMPLICIT SearchResponse,
      presentRequest                  [24]  IMPLICIT PresentRequest,
      presentResponse                 [25]  IMPLICIT PresentResponse,
      deleteResultSetRequest          [26]  IMPLICIT DeleteResultSetRequest,
      deleteResultSetResponse         [27]  IMPLICIT DeleteResultSetResponse
            -- new APDUs can be added in the future at the end of this list.
    }

--

ObjectDescriptor ::= [UNIVERSAL 7] OCTET STRING

THISEXTERNAL [[P struct Extern *]] ::= [UNIVERSAL 8] IMPLICIT SEQUENCE {
		direct-reference 	OBJECT IDENTIFIER 	[[O directReference]] OPTIONAL,
		indirect-reference	INTEGER			[[i indirectReference]] OPTIONAL,
		data-value-descriptor	ObjectDescriptor	[[o dataValueDescriptor.value $ dataValueDescriptor.len]]
                                                                OPTIONAL,
		CHOICE [[T struct Extern * $ * ]] {
			single-ASN1-type	[0] ANY [[a singleASN1Type]],
			octet-aligned		[1] IMPLICIT OCTET STRING [[o octetAligned.value $ octetAligned.len]],
			arbitrary		[2] IMPLICIT BIT STRING [[x arbitrary.value $ arbitrary.len]]
		}
 	}


--
InitialiseRequest [[P struct _InitialiseRequest *]] ::= SEQUENCE
    {
      referenceId                     ReferenceId [[p referenceId]] OPTIONAL,
      protocolVersion                 ProtocolVersion [[t protocolVersion]],
            -- proposed version of the protocol to be used (see below).
      options                         Options [[t options]],
            -- proposed set of services to be used (see below).
      preferredMessageSize            PreferredMessageSize [[i preferredMessageSize]],
            -- origin proposal for the size of large messages, where message
            -- size is the sum of sizes (number of bytes) of the records in an
            -- APDU, that the target should normally use when presenting groups
            -- of records; however, the first record in a response is permitted
            -- to cause the  message to exceed this size (see also
            -- maximumMessageSize below).
      maximumMessageSize              MaximumMessageSize [[i maximumMessageSize]],
            -- origin proposal for absolute maximum size (number of bytes) for
            -- messages (see also preferredMessageSize above).  Value must be
            -- greater than or equal to preferredMessageSize.
      authentication                  [7]   ANY [[a authentication]] OPTIONAL,
            -- information as required by the target to access the responding
            -- SRPM; syntax of this parameter to be defined by the target prior
            -- to communication.
      implementationId                ImplementationId [[s implementationId]] OPTIONAL,
      implementationName              ImplementationName [[s implementationName]] OPTIONAL,
      implementationVersion           ImplementationVersion [[s implementationVersion]] OPTIONAL,
      userInformationField            UserInformationField [[p userInformationField]] OPTIONAL
    }


InitialiseResponse [[P struct _InitialiseResponse *]] ::= SEQUENCE
    {
      referenceId                     ReferenceId [[p referenceId]] OPTIONAL,
      protocolVersion                 ProtocolVersion [[t protocolVersion]],
            -- agreed protocol version to be used (see below).
      options                         Options [[t options]],
            -- agreed set of services to be used (see below).
      preferredMessageSize            PreferredMessageSize [[i preferredMessageSize]],
            -- target decision on the "normal" maximum  message size (see
            -- description under InitializationRequest definition).  Value is
            -- allowed to be different from what origin propo<sed in the
            -- InitializationRequest; if origin does not agree on target
            -- values, it may abort the connection.
      maximumMessageSize              MaximumMessageSize [[i maximumMessageSize]],
            -- target decision on the absolute maximum  message size (see
            -- description under InitializationRequest definition).  Value must
            -- be greater than or equal to preferredMessageSize. Value is
            -- allowed to be different from what origin proposed in the
            -- InitializationRequest; if origin does not agree on target
            -- values, it may abort the connection.
      initializationStatus            [12]  IMPLICIT BOOLEAN [[b initializationStatus]],
            -- result of the processing of the request at the target SRPM.
            -- Accept = TRUE; reject = FALSE.
      implementationId                ImplementationId [[s implementationId]] OPTIONAL,
      implementationName              ImplementationName [[s implementationName]] OPTIONAL,
      implementationVersion           ImplementationVersion [[s implementationVersion]] OPTIONAL,
      userInformationField            UserInformationField [[p userInformationField]] OPTIONAL
    }
 
--
-- Auxiliary definitions for Initialization APDUs

      ProtocolVersion  ::=  [3]   IMPLICIT BIT STRING
            -- represents a string of Boolean values, each value representing a
            -- version.  The first value set to 1 indicates version 1 is
            -- available, the second value set to 1 indicates version 2 is
            -- available, and so on.  Values higher than the highest known
            -- version should be ignored.  Both the Initialise and Initialise
            -- Response APDUs include a value string corresponding to the
            -- supported versions.  The highest common version is selected for
            -- use. If there are no versions in common, the Initialise Response
            -- APDU should indicate a value of "reject" for the parameter
            -- InitializationStatus.

      Options  ::=  [4] IMPLICIT BIT STRING
          {
		search (0),
                present (1),
                delSet (2)
          }
            -- In InitialiseRequest, bit OFF indicates initiator does not, bit
            -- ON indicates initiator does request use of service. In
            -- InitialiseResponse, bit OFF indicates target will not, bit ON
            -- indicates target will support service.  For extensibility of the
            -- protocol, additional bits set should not be considered to be an
            -- error on received InitialiseRequest.

      PreferredMessageSize            ::=  [5]           IMPLICIT INTEGER

      MaximumMessageSize              ::=  [6]           IMPLICIT INTEGER

           -- these three implementation parameters are provided solely for the
           -- convenience of implementors needing to distinguish implementa-
           -- tions. They shall not be the subject of conformance tests.

      ImplementationId                ::=  [110]         IMPLICIT VisibleString

      ImplementationName              ::=  [111]         IMPLICIT VisibleString

      ImplementationVersion           ::=  [112]         IMPLICIT VisibleString

           -- additional information, not defined in this standard.
     UserInformationField             ::=  [11]   	 THISEXTERNAL

	   -- Authentication according to Nordic SR-NETT
     Authentication	[[P struct _Authentication *]] ::= SEQUENCE {
			user		VisibleString [[o user.value $ user.len]],
			password      	VisibleString [[o password.value $ password.len]],
			account		VisibleString [[o account.value $ password.len]]
	} 

--
SearchRequest [[P struct _SearchRequest *]] ::= SEQUENCE
    {
      referenceId                     ReferenceId [[p referenceId]] OPTIONAL,
      smallSetUpperBound              [13]  IMPLICIT INTEGER [[i smallSetUpperBound]],
           -- if the number of hits is less than or equal to this number, all
           -- records are to be returned in the records parameter in the
           -- SearchResponse (within the limits given by the negotiated
           -- preferred- and maximumMessageSize), composed in the way specified
           -- by the smallSetRecordComposition parameter below.
      largeSetLowerBound              [14]  IMPLICIT INTEGER [[i largeSetLowerBound]],
           -- if the number of hits is equal to or greater than this number, no
           -- records are to be returned. Note: largeSetLowerBound must be
           -- greater than smallSetUpperBound."
      mediumSetPresentNumber          [15]  IMPLICIT INTEGER [[i mediumSetPresentNumber]],
           -- maximum number of records to be returned in the SearchResponse
           -- if the number of hits is between the largeSetLowerBound and the
           -- smallSetUpperBound (again within the limits given by the
           -- MessageSize parameters), composed in the way specified by the
           -- mediumSetRecordComposition parameter below.
      replaceIndicator                [16] IMPLICIT BOOLEAN [[b replaceIndicator]],
           -- origin indicates whether or not to replace a previously created
           -- result set with the same name by the one that is constructed in
           -- this search.
      proposedResultSetId             [17] IMPLICIT VisibleString [[s proposedResultSetId]],
           -- origin proposal for naming of the result set that is constructed
           -- if hits are found.  If the target allows the origin to assign
           -- names to result sets, it uses this proposed name; if the target
           -- assigns names to result sets without respect to origin proposal,
           -- or does not support named result sets it returns an error
           -- diagnostic.
      databaseId                      [18] IMPLICIT SEQUENCE OF [[T struct _SeqOf_DatabaseName * $ databaseId ]]
                                                        DatabaseName [[s name]], -- [[p &name]],
           -- database(s) in which the search will be performed.
      smallSetRecordComposition [100] IMPLICIT RecordComposition [[p smallSetRecordComposition]] OPTIONAL,
           -- origin proposal for the composition of the records in the small
           -- set (see above under smallSetUpperBound).
      mediumSetRecordComposition [101] IMPLICIT RecordComposition [[p mediumSetRecordComposition]] OPTIONAL,
           -- origin proposal for the composition of the records in the medium
           -- set (see above under mediumSetPresentNumber).
      preferredRecordSyntax PreferredRecordSyntax [[O preferredRecordSyntax]] OPTIONAL,
           -- origin proposal for the abstract syntax of the database records to
           -- be returned in the records parameter in the SearchResponse.
           -- Values are subject to registration.
      query                           [21]  Query [[p query]]
           -- the search argument (see description below).
    }


--
Query  [[P struct _Query *]] ::=  CHOICE
    {
       privateQuery                   [0]   ANY			[[a privateQuery]],
       rpnQuery                       [1]   IMPLICIT RPNQuery   [[p rpnQuery]],
       iso8777query                   [2]   OCTET STRING 	[[o iso8777Query.value $ iso8777Query.len]]

           -- the search argument contained in the SearchRequest.  Three types
           -- are defined:
           --  a)   the private type query is not specified by this standard and
           --       should be agreed upon between any two communicating parties.
           --  b)   the Reverse Polish Notation (RPN) type query (see below).
           --  c)   the ISO8777 type query, specified in ISO standard 8777.
    }


RPNQuery  [[P struct _RPNQuery *]] ::=  SEQUENCE
    {
       attributeSetId            OBJECT IDENTIFIER [[O attributeSetId]],  -- identifies attribute set
       RPNStructure				   [[p rpnStructure]]
    }


RPNStructure  [[P struct _RPNStructure *]] ::=  CHOICE
    {
         [0]        Operand	       		[[p operand]],
         [1]        IMPLICIT SEQUENCE 		[[T struct _RPNStructure * $ *]]
                           {
                               RPNStructure	[[p compound.rpnStructure1]],
                               RPNStructure	[[p compound.rpnStructure2]],
                               Operator		[[p compound.operator]]
                           }
    }


Operand  [[P struct _Operand *]] ::= CHOICE
    {
        AttributesPlusTerm	[[p attributesPlusTerm]],
	ResultSetId		[[s resultSetId]] --[[p &resultSetId]]
    }


AttributesPlusTerm  [[P struct _AttributesPlusTerm *]] ::=  [102] IMPLICIT SEQUENCE [[T struct _AttributesPlusTerm * $ * ]]
                                          {
                                               AttributeList [[p attributeList]],
                                               Term 	     [[p term]]
                                          }

AttributeList  [[P struct _AttributeList *]] ::=
                      [44] IMPLICIT SEQUENCE OF [[T struct _AttributeList * $ *]] AttributeElement [[p *]]

Term  [[P struct octetString *]] ::=  [45]   IMPLICIT OCTET STRING [[o value $ len]]
            -- the type OCTET STRING is used to enable the inclusion of multi-
            -- byte character representations which the types CharacterString
            -- and VisibleString might impose on graphic character repertoire.

Operator  [[P struct _Operator *]] ::=  [46]   CHOICE
                              {
                                      and                [0] IMPLICIT NULL,
                                      or                 [1] IMPLICIT NULL,
                                      and-not            [2] IMPLICIT NULL
                              }

AttributeElement [[P struct _AttributeElement *]] ::= SEQUENCE
                         {
                            AttributeType	[[i attributeType]],
                            AttributeValue	[[i attributeValue]]
                         }

AttributeType                        ::=               [120] IMPLICIT INTEGER 

AttributeValue                       ::=               [121] IMPLICIT INTEGER 
       -- AttributeType and AttributeValue interpretation is governed by the
       -- values contained in the definition identified by AttributeSetId

--
SearchResponse [[P struct _SearchResponse *]] ::= SEQUENCE
          -- the records (diagnostic and/or bibliographic) resulting from the
          -- search (see description below).
   {
      referenceId                              ReferenceId [[p referenceId]] OPTIONAL,
      numberOfRecordsFound                     [23]  IMPLICIT INTEGER [[i numberOfRecordsFound]],
           -- number of hits resulting from the search
      numberOfRecordsReturned                  NumberOfRecordsReturned [[i numberOfRecordsReturned]],
           -- number of records in the  records below.
      nextResultSetPosition                    NextResultSetPosition [[i nextResultSetPosition]],
           -- the ordinal number in the result set of the record appearing
           -- directly after the last record in the records parameter below.
      searchStatus                             [22]  IMPLICIT BOOLEAN [[b searchStatus]],
           -- success = TRUE; failure = FALSE.
           -- result of the processing of the request at the target SRPM.
      resultSetStatus                          [26]  IMPLICIT INTEGER [[i resultSetStatus]] 
                                                {
                                                         subset     (1),
                                                         interim    (2),
                                                         none       (3)
                                                } OPTIONAL,
           -- occurs if and only if search-status is FALSE indicates the
           -- presence and validity of the result set produced.
      presentStatus                            PresentStatus [[i presentStatus]] OPTIONAL,
           -- occurs if and only if search-status is TRUE; indicates the
           -- presence and validity of the records appearing in the records
           -- parameter (see description below).
      records                                  Records [[p records]] OPTIONAL
   }

--
PresentRequest [[P struct _PresentRequest *]] ::= SEQUENCE
   {
           -- origin proposal for the abstract syntax of the database records
           -- to be returned in the records in the PresentResponse.  Values are
           -- subject to registration, at present by means of specification
           -- in annex C.

      referenceId                              ReferenceId [[p referenceId]] OPTIONAL,
      resultSetId                              ResultSetId [[s resultSetId]], -- [[p &resultSetId]],
           -- identification of the result set from which to retrieve records
      resultSetStartPoint                      [30]  IMPLICIT INTEGER [[i resultSetStartPoint]],
           -- ordinal number in the result set of the first record to appear in
           -- the records in the PresentResponse.
      numberOfRecordsRequested                 [29]  IMPLICIT INTEGER [[i numberOfRecordsRequested]],
           -- specifies the maximum number of records to be returned in the
           -- records in the PresentResponse (within the limits given by the
           -- negotiated preferred- and
           -- maximumMessageSize parameters), composed in the way specified by
           -- the recordComposition parameter below.
      RecordComposition                       [[p recordComposition]] OPTIONAL,
           -- origin proposal for the composition of the records to be returned
           -- in the records parameter in the PresentResponse (see description
           -- under 8.1.1.2)
      preferredRecordSyntax                    PreferredRecordSyntax [[O preferredRecordSyntax]] OPTIONAL
   }
--
PresentResponse ::= SEQUENCE
   {
            -- the presented records

       referenceId                             ReferenceId [[p referenceId]] OPTIONAL,
       numberOfRecordsReturned                 NumberOfRecordsReturned [[i numberOfRecordsReturned]],
           -- number of records returned in the records parameter below.
       nextResultSetPosition                   NextResultSetPosition [[i nextResultSetPosition]],
           -- the ordinal number in the result set of the record appearing
           -- directly after the last record in the records parameter.
       presentStatus                           PresentStatus [[i presentStatus]],
           -- indicates the presence and validity of the records appearing in
           -- the records parameter.
       records                                 Records [[p records]] OPTIONAL
   }

--
--
-- begin auxiliary definitions for search and present APDUs
-- begin definition of record structure
--
Records [[P struct _Records *]] ::= CHOICE [[T struct _Records * $ *]]
   {
      dataBaseOrSurDiagnostics                 [28]  IMPLICIT SEQUENCE OF
                     [[T struct _NamePlusRecord * $ databaseOrSurDiagnostics]] NamePlusRecord [[p *]],
      nonSurrogateDiagnostic                   [130] IMPLICIT DiagRec [[p nonSurrogateDiagnostic]]
   }


NamePlusRecord [[P struct _NamePlusRecord *]] ::=   SEQUENCE
   {
      [0]   IMPLICIT DatabaseName [[s databaseName]] OPTIONAL,
            -- presence of this parameter is conditional. See 7.2.7
      [1]   CHOICE [[T struct _NamePlusRecord * $ *]] {
               databaseRecord         [1] DatabaseRecord [[p databaseRecord]],
               surrogateDiagnostic    [2] DiagRec	 [[p surrogateDiagnostic]]
            }
   }


DatabaseRecord  ::=  THISEXTERNAL
      -- the database record syntax is defined outside of this standard.  For
      -- bibliographic data, the MARC formats (based on ISO 2709) are a prime
      -- example.


DiagRec [[P struct _DiagRec *]] ::=   SEQUENCE
                 {
                       -- indicates whether this diagnostic record is a surrogate for a
                       -- database record.

                    diagnosticSetId            OBJECT IDENTIFIER [[O diagnosticSetId]],
                    condition                  INTEGER		 [[i condition]],
                       -- interpretation of condition is governed by values contained in
                       -- definition dentified by DiagnosticSetId.
                    addinfo                       VisibleString  [[s addinfo]]
                       -- add'l information.
                 }

--
-- begin definition of record composition
RecordComposition  [[P struct _RecordComposition *]] ::=  [19]   CHOICE
            {
               generic                         [0] IMPLICIT RecordCompositionId [[s generic]],

               databaseSpecific                [1] IMPLICIT SEQUENCE OF
                       [[T struct _RCDatabaseSpecific * $ databaseSpecific]]
	               SEQUENCE [[T struct _RCDatabaseSpecific * $ *]] 
	                   {
        	               DatabaseName		[[s databaseName]], -- [[p &databaseName]],
        	               RecordCompositionId	[[s recordCompositionId]]
        	           }
            }

RecordCompositionId                           ::=  [103]   IMPLICIT VisibleString
      -- A target must always recognize the value "F" to mean "full record".
--
-- begin miscellaneous definitions for search and present APDUs

NumberOfRecordsReturned                       ::=        [24]   IMPLICIT INTEGER

NextResultSetPosition                         ::=        [25]   IMPLICIT INTEGER 


PresentStatus 		     ::=  [27]   IMPLICIT INTEGER
                               {
                                      success (0),
                                      partial-1 (1),
                                      partial-2 (2),
                                      -- partial-3 reserved
                                      partial-4 (4),
                                      failure   (5)
                               }

-- PreferredRecordSyntax [[P OID *]] ::=  [104]   IMPLICIT OBJECT IDENTIFIER [[O *]]
PreferredRecordSyntax ::=  [104]   IMPLICIT OBJECT IDENTIFIER 

--
DeleteResultSetRequest [[P struct _DeleteResultSetRequest *]] ::= SEQUENCE
   {
           -- identification of the result sets to be deleted if operation is
           -- "list".

      referenceId                     ReferenceId [[p referenceId]] OPTIONAL,
      deleteSetFunction               [32]  IMPLICIT INTEGER [[i deleteSetFunction]]
                                              {
                                                  list     (0),
                                                  all      (1)
                                              },
      resultSetList                   SEQUENCE OF [[T struct _ResultSetList * $ resultSetList]]
                                                  ResultSetId [[s resultSetId]]  OPTIONAL
    }


DeleteResultSetResponse [[P struct _DeleteResultSetResponse *]] ::= SEQUENCE
   {
      referenceId                     ReferenceId [[p referenceId]] OPTIONAL,
      deleteOperationStatus           [0] IMPLICIT DeleteSetStatus [[i deleteOperationStatus]],
           -- Reports the status for the entire delete operation. Values
           -- limited to "success" or  "failure-3" through "failure-9". Values
           -- of "failure-7" and "failure-8" may be used only if operation
           -- is "all".
      deleteListStatuses              [1]   IMPLICIT ListStatuses [[p deleteListStatuses]] OPTIONAL,
           -- Must occur if operation is "list".  Individual values limited to
           --success through failure-6.
      numberNotDeleted                [34]  IMPLICIT INTEGER [[i numberNotDeleted]] OPTIONAL,
           -- number of result sets the target failed to delete. Occurs only
           -- if operation is "all".
      bulkStatuses                    [35]  IMPLICIT ListStatuses [[p bulkStatuses]] OPTIONAL,
           -- occurs if and only if DeleteOperationStatus equals 8. Individual
           -- statuses limited to "success" through "failure-6"
      deleteMessage                   [36]  IMPLICIT VisibleString [[s deleteMessage]] OPTIONAL
           -- textual message concerning the delete operation.
   }
--
-- begin auxiliary definitions for delete

ListStatuses [[P struct _ListStatuses *]] ::= SEQUENCE OF [[T struct _ListStatuses * $ *]]
                                                          SEQUENCE [[T struct _ListStatuses * $ * ]]
   {
      ResultSetId 	[[s resultSetId]],
      DeleteSetStatus   [[i deleteSetStatus]]
   }

DeleteSetStatus ::= [33] IMPLICIT INTEGER
   {
      success                                            (0),
      resultSetDidNotExist                               (1),
      previouslyDeletedByTarget                          (2),
      systemProblemAtTarget                              (3),
      accessNotAllowed                                   (4),
      -- status of 5 is reserved
      resourceControl                                    (6),
      bulkDeleteNotSupported                             (7),
      notAllResultSetsDeletedOnBulkDelete                (8),
      notAllRequestedResultSetsDeleted                   (9)
            -- 7 and 8 used only if deleteSetFunction was 1.
   }

--
-- begin global auxiliary definitions

ReferenceId                  [[P struct octetString *]] ::=  [2]
				IMPLICIT OCTET STRING [[o value $ len]]
           -- value provided by the service originator in the Request APDU,
           -- target required to send it back unaltered in the corresponding
           -- Response APDU.

DatabaseName ::=  [105]   IMPLICIT VisibleString

ResultSetId ::=  [31]   IMPLICIT VisibleString
--
END -- ISO10163-SR-1
