/*
 * common-structdesc.h,v 1.1 1994/01/28 17:21:51 franktor Exp
 *
 * structdesc.h
 *
 * Description of datastructures usable for code
 *
*/

#include <sr-general.h>
#ifndef VMS
#include <high/structcodec.h>
#include <high/eapi.h>
#else
#include <structcodec.h>
#include <eapi.h>
#endif
/* #include "structdesc.h" */

extern elemDesc desc_DatabaseName[];
extern elemDesc desc_SearchRequest[];
extern elemDesc desc_SearchResponse[];
extern elemDesc desc_PresentRequest[];
extern elemDesc desc_PresentResponse[];
extern elemDesc desc_EapiRecords[];
extern elemDesc desc_EapiNamePlusRecord[];
extern elemDesc desc_EapiDiagRec[];
extern elemDesc desc_DeleteResultSetRequest[];
extern elemDesc desc_DeleteResultSetResponse[];
extern elemDesc desc_InterruptRequest[];
extern elemDesc desc_InterruptResponse[];
extern elemDesc desc_OpenRequest[];
extern elemDesc desc_OpenResponse[];
extern elemDesc desc_CloseRequest[];
extern elemDesc desc_CloseResponse[];
extern elemDesc desc_EapiPacket[];



/* structures from eapi.h */

elemDesc desc_HS_SearchRequest [] = {
  { elemStructPtr, 	desc_DatabaseName, 	sizeof(struct DatabaseName *) },
  { elemStructPtr, 	desc_Query, 		sizeof(struct Query *) },
  { elemDone, 		0, 			0 } 
};

elemDesc desc_HS_SearchResponse[] = {
  { elemInt,		0,			sizeof(int) }, 
  { elemBoolean,	0,			sizeof(Boolean) }, 
  { elemEnum,		0,			sizeof(ResultSetStatus) }, 
  { elemInt,		0,			sizeof(int) }, 
  { elemDone, 		0, 			0 } 
};

elemDesc desc_HS_PresentRequest[] = {
  { elemInt,		0,			sizeof(int) }, 
  { elemInt,		0,			sizeof(int) }, 
  { elemInt,		0,			sizeof(int) }, 
  { elemStructPtr,	desc_RecordComposition,	sizeof(RecordComposition *) }, 
  { elemCharPtr,	0,			sizeof(char *) }, 
  { elemDone, 		0, 			0 } 
};

elemDesc desc_HS_PresentResponse[] = {
  { elemInt,		0,			sizeof(int) }, 
  { elemEnum,		0,			sizeof(PresentStatus) }, 
  { elemStructPtr,	desc_HlvlRecords,	sizeof(struct HlvlRecords *) }, 
  { elemDone, 		0, 			0 } 
};

elemDesc desc_HlvlRecords_u_u[] = {
  { elemStructPtr,	desc_HlvlNamePlusRecord, sizeof(HlvlEapiNamePlusRecord *) }, 
  { elemStructPtr,	desc_HlvlDiagRec,	sizeof(HlvlDiagRec *) }, 
  { elemDone,		0,			0}
};

elemDesc desc_HlvlRecords[] = {
  { elemEnum,		0,			sizeof(HlvlRecordKind) },
  { elemUnion,		desc_HlvlRecords_u_u,	0,			0 },
  { elemDone, 		0, 			0 } 
};

elemDesc desc_HlvlRecord[] = {
  { elemStruct,		desc_octetString,	sizeof(octetString) },
  { elemCharPtr,	0,			sizeof(char *) },
  { elemCharPtr,	0,			sizeof(char *) },
  { elemDone, 		0, 			0 } 
};

elemDesc desc_HlvlNamePlusRecord_u_u[] = {
  { elemStruct,		desc_HlvlRecord,	sizeof(struct HlvlRecord) },
  { elemStructPtr,	desc_HlvlDiagRec,	sizeof(HlvlDiagRec *) },
  { elemDone, 		0, 			0 } 
};

elemDesc desc_HlvlNamePlusRecord[] = {
  { elemEnum,		0,		sizeof(HlvlNamePlusRecordKind) },
  { elemUnion,		desc_HlvlNamePlusRecord_u_u, sizeof(struct HlvlNamePlusRecord_u_u *), 0},
  { elemStructPtr,	desc_HlvlNamePlusRecord, sizeof(HlvlNamePlusRecord *) },
  { elemDone, 		0, 			0 } 
};

elemDesc desc_HlvlDiagRec[] = {
  { elemCharPtr,	0,			sizeof(char *) },
  { elemInt,		0,			sizeof(int) },
  { elemCharPtr,	0,			sizeof(char *) },
  { elemDone, 		0, 			0 } 
};

elemDesc desc_HS_DeleteResultSetRequest[] = { 
  { elemBoolean,	0,			sizeof(Boolean) }, 
  { elemInt,		0,			sizeof(int) }, 
  { elemDone, 		0, 			0 } 
};

elemDesc desc_HS_DeleteResultSetResponse[] = {
  { elemBoolean,	0,			sizeof(Boolean) }, 
  { elemDone, 		0, 			0 } 
};

elemDesc desc_HS_InterruptRequest[] = {
  { elemInt,		0,			sizeof(int) }, 
  { elemDone, 		0, 			0 } 
};

elemDesc desc_HS_InterruptResponse[] = {
  { elemBoolean,	0,			sizeof(Boolean) }, 
  { elemDone, 		0, 			0 } 
};

elemDesc desc_HS_Packet_u_u[] = {
  { elemStructPtr,   	desc_HS_SearchRequest,  	sizeof(HS_SearchRequest) },  
  { elemStructPtr,   	desc_HS_SearchResponse,  	sizeof(HS_SearchResponse) },  
  { elemStructPtr,   	desc_HS_PresentRequest,	sizeof(HS_PresentRequest) },  
  { elemStructPtr,   	desc_HS_PresentResponse,	sizeof(HS_PresentResponse) },  
  { elemStructPtr,   	desc_HS_DeleteResultSetRequest, sizeof(HS_DeleteResultSetRequest) },  
  { elemStructPtr,   	desc_HS_DeleteResultSetResponse, sizeof(HS_DeleteResultSetResponse) },  
  { elemStructPtr,   	desc_HS_InterruptRequest,	sizeof(HS_InterruptRequest) },  
  { elemStructPtr,   	desc_HS_InterruptResponse,	sizeof(HS_InterruptResponse) },  
  { elemStructPtr,   	desc_HS_OpenRequest,	sizeof(HS_OpenRequest) },  
  { elemStructPtr,   	desc_HS_OpenResponse,	sizeof(HS_OpenResponse) },  
  { elemStructPtr,   	desc_HS_CloseRequest,	sizeof(HS_CloseRequest) },  
  { elemStructPtr,   	desc_HS_CloseResponse,	sizeof(HS_CloseResponse) },  
  { elemDone, 		0, 			0 } 
};

elemDesc desc_HS_Packet[] = {
  { elemEnum,   	0,		  	sizeof(HS_PacketTypes) },  
  { elemInt,	   	0,		  	sizeof(int) },  
  { elemUnion,   	desc_HS_Packet_u_u,	0,			0 },  
  { elemDone, 		0, 			0 } 
};

elemDesc desc_HS_OpenRequest[] = {
  { elemInt,	       	0,			sizeof(int) },
  { elemDone,	       	0,			0 },
};

elemDesc desc_HS_OpenResponse[] = {
  { elemBoolean,       	0,			sizeof(Boolean) },
  { elemCharPtr,       	0,			sizeof(char *) },
  { elemDone,	       	0,			0 },
};

elemDesc desc_HS_CloseRequest[] = {
  { elemInt,	       	0,			sizeof(int) },
  { elemDone,	       	0,			0 },
};

elemDesc desc_HS_CloseResponse[] = {
  { elemBoolean,	0,			sizeof(Boolean) },
  { elemCharPtr,	0,			sizeof(char *) },
  { elemDone,	       	0,			0 },
};
