/*
 * diagset.c,v 1.1 1994/01/28 17:21:38 franktor Exp
 *
 * diagset.c  -  Utility routines to help applications handle diagnostics
 *
 * 
*/

#include <errno.h>
#include <sr-general.h>
#include <sr-api.h>
#include <sr-util.h>
#include <sr-parser.h>
#include <sr-logger.h>

extern struct AttributeSet *attributeSets;
extern struct DiagSet	*diagnosticSets;


Boolean loadDiagnosticSet ( char *fromFile )
{
   FILE			*f;

   if ( !(f = fopen ( fromFile, "r" ) ) )
   {
      LOG ( facApp, llevExceptions, "Failed to open %s for reading: %d", fromFile, errno );
      return False;
   }

   if ( !parseDiagSet ( f ) )
   {
      LOG ( facApp, llevExceptions, "Failed to parse diagnostic set from file %s", fromFile );
      fclose ( f );
      return False;
   }
   
   fclose ( f );

   return True;
}

 
struct DiagRec *newDiagRec ( Oid diagSet, int condition, char *addinfo )
{
   struct DiagRec	*d;

   d = (struct DiagRec *) smalloc ( sizeof ( struct DiagRec) );

   d->diagnosticSetId = diagSet;
   d->condition = condition;
   if ( addinfo )
      d->addinfo = safe_strdup ( addinfo );
   else
      d->addinfo = safe_strdup ( "" );

   return d;
}

char *diagRec2Str ( struct DiagRec *d, Boolean includeSetName )
{
   static char		buf[1024];
   struct DiagSet	*set;
   struct DiagMsg	*msg;

   for ( set = diagnosticSets; set; set = set->next )
      if ( !OID_cmp ( set->oid, d->diagnosticSetId ) )
      {
	 for ( msg = set->messages; msg; msg = msg->next )
	    if ( msg->condition == d->condition )
	    {
	       if ( includeSetName )
		  sprintf ( buf, "%s (%s)", msg->msg, set->name );
	       else
		  strcpy ( buf, msg->msg );

	       return buf;
	    }

	 sprintf ( buf, "Unknwon diagnostic message %d in set %s", d->condition, set->name );
	 return buf;
      }

   sprintf ( buf, "Unknown diagnostic message, msg %d, diagnostic set %s",
	     d->condition, OID_Oid2name ( d->diagnosticSetId ) );
   return buf;
}
