/*
 * Initialise
 *
 * Note: When changing this file, execute the following:
 * "rm sr_macroes_cpp.h; make sr_macroes_cpp.h"
*/

#define ISODE_Send(operation, kind) \
Boolean _ISODE_Send##operation ##kind##( int ref, SR##operation ##kind##*ir ) \
{ \
     struct _##operation ##kind	## *irq		= (struct _##operation ##kind##*) NULL; \
  PE					pe		= NULLPE; \
  struct _SR_APDU			sr_apdu; \
 \
  irq = encode_##operation ##kind##( ir ); \
 \
  if ( encode_ISO10163__SR__1_##operation ##kind##( &sr_apdu.pe, 1, 0, NULLCP, irq ) == NOTOK ) \
  { \
     LOG ( facLow, llevExceptions, "encode_ISO10163__SR__1_%s%s%s" , \
	   #operation , #kind , " () failed" ); \
     return False; \
  } \
 \
    switch ( opr##operation ##kind##) \
    { \
     case oprInitialiseRequest: \
       sr_apdu.offset = 1; \
       break; \
 \
     case oprInitialiseResponse: \
       sr_apdu.offset = 2; \
       break; \
 \
     case oprSearchRequest: \
       sr_apdu.offset = 3; \
       break; \
 \
     case oprSearchResponse: \
       sr_apdu.offset = 4; \
       break; \
 \
     case oprPresentRequest: \
       sr_apdu.offset = 5; \
       break; \
 \
     case oprPresentResponse: \
       sr_apdu.offset = 6; \
       break; \
 \
     case oprDeleteResultSetRequest: \
       sr_apdu.offset = 7; \
       break; \
 \
     case oprDeleteResultSetResponse: \
       sr_apdu.offset = 8; \
       break; \
 \
     case oprCloseRequest: \
       sr_apdu.offset = 9; \
       break; \
\
     case oprCloseResponse: \
       sr_apdu.offset = 10; \
       break; \
    } \
    \
   if ( encode_ISO10163__SR__1_SR__APDU ( &pe, 1, 0, NULLCP, &sr_apdu ) == NOTOK ) \
   { \
      LOG ( facLow, llevExceptions, "encode_ISO10163__SR__1_SR__APDU() failed" ); \
      return False; \
   } \
 \
   pe->pe_context = 1; \
 \
   return SendPE ( ref, pe, #operation , #kind ); \
} 

#define ISODE_Read(operation, kind) \
SR##operation##kind## *_ISODE_Read##operation##kind## ( int ref ) \
{ \
   struct _##operation##kind##	*_irs	= (struct _##operation ##kind##*) NULL; \
   SR##operation##kind##		*irs = (SR##operation##kind##*) NULL; \
   qElem					*qe = (qElem *) NULL; \
    \
   for ( qe = incomming; qe && qe->ref != ref; qe = qe->next ); \
   if ( !qe ) \
   {  \
      LOG ( facLow, llevExceptions, "_ISODE_Read%s%s%s%d" , #operation , #kind , \
	    " failed - no APDU waiting for association ", ref );  \
      return (SR##operation##kind## *) NULL;  \
   }  \
 \
   if ( qe->opr != opr##operation ##kind##) \
   {  \
      LOG ( facLow, llevExceptions, \
	    "_ISODE_Read%s%s%s%s%s%s%s%s%d", #operation , #kind , \
	    " failed - found ", sro2str ( qe->opr) , "when expected " , \
	    #operation , #kind , " for association ", ref );  \
      return (SR##operation##kind## *) NULL;  \
   }  \
 \
   if ( decode_ISO10163__SR__1_##operation##kind## ( incomming->oprPE, 1, 0, NULLCP, &_irs ) == NOTOK ) \
   { \
      LOG ( facLow, llevExceptions, "_ISODE_Read%s%s%s" , #operation , #kind , \
	    " () ASN.1 decode failed" ); \
      return (SR##operation##kind## *) NULL; \
   } \
 \
   irs = decode_##operation##kind## ( _irs ); \
 \
   /* free _irs */ \
   incomming = incomming->next; \
 \
   return irs; \
} 

ISODE_Send ( Initialise, Request )

ISODE_Send ( Initialise, Response )

ISODE_Read ( Initialise, Request )
 
ISODE_Read ( Initialise, Response )

ISODE_Send ( Search, Request )

ISODE_Send ( Search, Response )

ISODE_Read ( Search, Request )

ISODE_Read ( Search, Response )

ISODE_Send ( Present, Request )

ISODE_Send ( Present, Response )

ISODE_Read ( Present, Request )

ISODE_Read ( Present, Response )

ISODE_Send ( DeleteResultSet, Request )

ISODE_Send ( DeleteResultSet, Response )

ISODE_Read ( DeleteResultSet, Request )

ISODE_Read ( DeleteResultSet, Response )
