/* 
 * SR.h,v 1.1 1994/01/28 17:06:57 franktor Exp
 *
 * SR.h
 *
*/

#include <sr-general.h>
#include <isode/pepsy/UNIV-types.h>


#define Options_search	   	0
#define	Options_present		1
#define	Options_delSet		2

#define SRBITTEST(p, bit) (p & (0x01 << bit))
#define SRBITSET(p, bit)  (p |= (0x01 << bit))
#define SRBITCLR(p, bit)  (p &= ~(0x01 << bit))
/*
#define SRBITTEST(p, bit) (p & (0x80 >> bit))
#define SRBITSET(p, bit)  (p |= (0x80 >> bit))
#define SRBITCLR(p, bit)  (p &= ~(0x80 >> bit))
*/

struct qbufPtr {
   struct qbuf			*qb;
};

struct oidPtr {
   OID				oid;
}; 


#define OPT_EXTERN_INDIRECTREFERENCE	0

struct Extern {
   unsigned int			optionals;
   OID				directReference; /* OPTIONAL */
   int				indirectReference; /* OPTIONAL */
   octetString			dataValueDescriptor; /* OPTIONAL */
   int				offset;
   PE		      		singleASN1Type;
   octetString			octetAligned;
   octetString			arbitrary;
};

struct _Authentication { 
   octetString			user;
   octetString			password;
   octetString			account;
} _Authentication;



struct _SR_APDU {
   int				offset;
   PE				pe;
} _SR_APDU;


struct _InitialiseRequest {
   struct octetString		*referenceId;
   PE				protocolVersion;          /* bitvector */
   PE				options;                  /* bitvector */     
   int				preferredMessageSize; 
   int				maximumMessageSize;
   PE				authentication;
   char				*implementationId;
   char				*implementationName;
   char				*implementationVersion;
   struct Extern		*userInformationField;
};

      
struct _InitialiseResponse {
   struct octetString		*referenceId;
   PE				protocolVersion;         /* bitvector */
   PE				options;                 /* bitvector */
   int				preferredMessageSize;
   int				maximumMessageSize;
   char				initializationStatus;
   char				*implementationId;
   char				*implementationName;
   char				*implementationVersion;
   struct Extern		*userInformationField;
};


struct _SeqOf_DatabaseName {
   char				*name;
   struct _SeqOf_DatabaseName	*next;
};

struct _RCDatabaseSpecific {
   char				*databaseName;
   char				*recordCompositionId;
   struct _RCDatabaseSpecific	*next;
};

struct _RecordComposition {
   int				offset;
   char				*generic;
   struct _RCDatabaseSpecific	*databaseSpecific;
};

struct _Operator {
   int				offset;
};

struct _RPNStructure {
   int				offset;
   struct _Operand		*operand;
   struct {
      struct _RPNStructure	*rpnStructure1;
      struct _RPNStructure	*rpnStructure2;
      struct _Operator		*operator;
   } compound;
};

struct _RPNQuery {
   OID				attributeSetId;
   struct _RPNStructure		*rpnStructure;
};

struct _AttributeElement {
   int				attributeType;
   int				attributeValue;
};

struct _AttributeList {
   struct _AttributeElement	*attributeElement;
   struct _AttributeList	*next;
};

struct _AttributesPlusTerm { 
   struct _AttributeList	*attributeList;
   struct octetString	       	*term;
   struct _AttributesPlusTerm	*next;
};

struct _Operand {
   int				offset;
   struct _AttributesPlusTerm	*attributesPlusTerm;
   char				*resultSetId;
};

   
struct _Query {
   int				offset;
   PE				privateQuery;
   struct _RPNQuery		*rpnQuery;
   octetString			iso8777Query;
};

   
struct _SearchRequest {
   struct octetString		*referenceId;
   u_int			smallSetUpperBound;
   u_int			largeSetLowerBound;
   u_int			mediumSetPresentNumber;
   char				replaceIndicator;
   char				*proposedResultSetId;
   struct _SeqOf_DatabaseName	*databaseId;
   struct _RecordComposition	*smallSetRecordComposition;
   struct _RecordComposition	*mediumSetRecordComposition;
   OID				preferredRecordSyntax;
   struct _Query	      	*query;
};

struct _DiagRec {
   OID				diagnosticSetId;
   u_int			condition;
   char				*addinfo;
};

struct _NamePlusRecord {
   char				*databaseName; /* VisibleString */
   int				offset;
   struct Extern		*databaseRecord;
   struct _DiagRec		*surrogateDiagnostic;
   struct _NamePlusRecord      	*next;
};

struct _Records {
   int				offset;
   struct _NamePlusRecord	*databaseOrSurDiagnostics;
   struct _DiagRec		*nonSurrogateDiagnostic;
};

#define OPT_SEARCHRESP_RESULTSETSTATUS	0
#define OPT_SEARCHRESP_PRESENTSTATUS	1
struct _SearchResponse {
   unsigned int			optionals;
   struct octetString		*referenceId;
   u_int			numberOfRecordsFound;
   u_int			numberOfRecordsReturned;
   u_int			nextResultSetPosition;
   char				searchStatus;
   u_int			resultSetStatus;
   int				presentStatus;
   struct _Records		*records;
};


/* PRESENT */

struct _PresentRequest {
/* unsigned int			optionals; */
   struct octetString		*referenceId;
   char				*resultSetId;
   u_int			resultSetStartPoint;
   u_int			numberOfRecordsRequested;
   struct _RecordComposition	*recordComposition;
   OID				preferredRecordSyntax;
};

struct _PresentResponse {
   struct octetString		*referenceId;
   u_int			numberOfRecordsReturned;
   u_int			nextResultSetPosition;
   int				presentStatus;
   struct _Records		*records;
};


/* DELETE RESULT SET */

struct _ResultSetList {
   char				*resultSetId;
   struct _ResultSetList	*next;
};

struct _DeleteResultSetRequest {
   struct octetString		*referenceId;
   u_int			deleteSetFunction;
   struct _ResultSetList	*resultSetList;
};

struct _ListStatuses {
   char				*resultSetId;
   int				deleteSetStatus;
   struct _ListStatuses		*next;
};

#define OPT_DELRESULTSETRESP_NUMBERNOTDELETED	0
struct _DeleteResultSetResponse {
   unsigned int			optionals;
   struct octetString		*referenceId;
   u_int			deleteOperationStatus;
   struct _ListStatuses		*deleteListStatuses;
   u_int			numberNotDeleted;
   struct _ListStatuses		*bulkStatuses;
   char				*deleteMessage;
};



struct SR_APDU {
   enum { APDU_InitialiseRequest = 1, APDU_InitialiseResponse = 2, 
          APDU_searchRequest = 3, APDU_searchResponse = 4, 
	  APDU_presentRequest = 5, APDU_presentResponse = 6,
          APDU_deleteResultSetRequest = 7, APDU_deleteResultSetResponse = 8 
	  } offset;
   union {
      struct _InitialiseRequest		*InitialiseRequest;
      struct _InitialiseResponse	*InitialiseResponse;
      struct _SearchRequest		*searchRequest;
      struct _SearchResponse		*searchResponse;
      struct _PresentRequest		*presentRequest;
      struct _PresentResponse		*presentResponse;
      struct _DeleteResultSetRequest	*deleteResultSetRequest;
      struct _DeleteResultSetResponse	*deleteResultSetResponse;
   } un;
};


