/*
 * marc.h,v 1.1 1994/01/28 17:06:36 franktor Exp
 */

#include <config.h>
#include <sr-general.h>
#include <sr-logger.h>

#define MAX_BUF 256
#define CHARS_IN_NORMARC_LINE 4096
#define NORMARC_END_OF_RECORD '^'

#define SUBFIELD_SEPARATOR '$'

#define IS_CONTROL_FIELD(x) ((x)>=0 && (x)<10)

#define LF '\012'
#define CR '\015'

#define IS2 0x1e	/* 1/14 of ISO 646 */
#define IS3 0x1d	/* 1/13 of ISO 646 */

#define Len_label	24	/* length of the label */
#define Pos_directory	24	/* Has to be the same as Len_label */

#define Pos_record_length 0
#define Pos_record_status 5
#define Pos_implementation_codes 6
#define Pos_indicator_length 10
#define Pos_identifier_length 11
#define Pos_base_address_of_data 12
#define Pos_reserved_user_systems 17
#define Pos_directory_map_length 20
#define Pos_directory_map_start 21
#define Pos_reserved_future 22

#define Len_record_length 5
#define Len_record_status 1
#define Len_implementation_codes 4
#define Len_indicator_length 1
#define Len_identifier_length 1
#define Len_base_address_of_data 5
#define Len_reserved_user_systems 3
#define Len_directory_map_length 1
#define Len_directory_map_start 1
#define Len_reserved_future 2

typedef struct Record_label {
  unsigned long record_length;
  char record_status;
  char implementation_codes[Len_implementation_codes + 1];
  unsigned long indicator_length;
  unsigned long identifier_length;
  unsigned long base_address_of_data;
  char reserved_user_systems[Len_reserved_user_systems + 1];
  unsigned long directory_map_length;
  unsigned long directory_map_start;
  char reserved_future[Len_reserved_future + 1];
} Record_label;

#define TAG_LENGTH 3
#define DATAFIELD_LENGTH 9

typedef struct Marcdata {
  struct Marcdata *next;
  unsigned long tag;
  unsigned long length_of_datafield;
  unsigned long starting_character_position;

  char indicator1; /* Don't know if these are standard though. */
  char indicator2;
  Boolean indicators; /* True if the indicators have a meaningful value */
  char *data;		/* The data itself */
} Marcdata;

#define FIELD_SEPARATOR IS2
#define RECORD_SEPARATOR IS3

typedef struct Marcrecord {
  Record_label label;
  Marcdata *entries;		/* Linked list of all directories & data */
} Marcrecord;
