

/*
 *
 * address.c  -  Addressing and directory related stuff
 *
 * Copyright (c) 1993 Nordic SR-NET 
 * All Rights Reserved 
 *
 *
*/


#include <sr-address.h>
#include <isode/acsap.h>
#include <isode/tsap.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netdb.h>


Boolean str2sr_address ( char *str, SR_Address **addr, char **msg )
{
   SR_Address			*res;
   AEI				aei;
   struct PSAPaddr		*presentationAddress;
   char 			*qualifier		= "SR";
   char				*applicationContext	= "SR BASIC";
   /* char			*presentationContext	= "SR PCI"; */
   static char			buf[500];
   
   if ( !str )
   {
      LOG ( facAddr, llevExceptions, "address translation failed: no address specified" );
      *msg = "No address specifed (NULLCP)";
      return False;
   }
   
   if ( index ( str, '.' ) )
   {
      /* presume this is an IP address for now */
      char		*skt		= NULLCP;

      if ( (skt = index ( str, '+' )) )
	 *skt++ = '\0';
      
      if ( inet_addr ( str ) == -1 )
      {
	 struct hostent	*hent 		= gethostbyname ( str );

	 if ( !hent )
	    /* this does not seem to be an IP address after all */
	    goto checkOSI;
      }

      res = (SR_Address *) malloc ( sizeof ( SR_Address ) );
      res->protocolVersion = proto_SR_V2;
      res->addressType = addrTCPIP;
      res->addr.tcpip_address = strdup ( str );
      res->next = (SR_Address *) NULL;

      *addr = res;
      *msg = NULLCP;

      return True;
   }
   
 checkOSI:;
   if ( (aei = str2aeinfo ( str, applicationContext, isatty(fileno(stdin)),
			    NULLCP, NULLCP )) == NULLAEI )
   {
      LOG ( facAddr, llevExceptions, "address translation failed (%s)", str );
      sprintf ( buf, "Unable to resolve service: \"%s\" with qualifier: \"%s\"\n",
	        str, qualifier );
      *msg = buf;
      return False;
   }

   if ( (presentationAddress = aei2addr ( aei )) == NULLPA )
   {
      LOG ( facAddr, llevExceptions, "address translation failed (%s)", sprintaei(aei) );
      sprintf ( buf, "address translation failed: %s", sprintaei(aei) );
      *msg = buf;
      return False;
   }

   strcpy ( buf, paddr2str ( presentationAddress, NULLNA ) );

   res = (SR_Address *) malloc ( sizeof ( SR_Address ) );
   res->protocolVersion = proto_SR_V2;
   res->addressType = addrOSI;
   res->addr.osi_address = strdup ( buf );
   res->next = (SR_Address *) NULL;

   *addr = res;

   return True;
}

void free_sr_address ( SR_Address *addr )
{
   while ( addr )
   {
      SR_Address			*tmp;
      
      switch ( addr->addressType )
      {
       case addrOSI:
	 free ( addr->addr.osi_address );
	 break;

       case addrTCPIP:
	 free ( addr->addr.tcpip_address );
	 break;
      }
      
      tmp = addr;
      free ( addr );
      addr = tmp;
   }
}

char *sr_address2str ( SR_Address *addr )
{
   static char		buf[1000];

   strcpy ( buf, "(Unknown address)" );

   switch ( addr->addressType )
   {
    case addrTCPIP:
      strncpy ( buf, addr->addr.tcpip_address, 500 );
      break;

    case addrOSI:
      strncpy ( buf, addr->addr.osi_address, 500 );
      break;

   }
   
   return buf;
}
