/*
 * trip.h,v 1.1 1994/01/28 17:05:52 franktor Exp
 *
 * trip.h
 *
*/

#ifndef TRIP_H
#define TRIP_H

/*
 * Data structures:
 */

typedef struct selection {
   int				setNo;
   int				noRecords;
   int				noMatches;
   char				*name;
   char				*db;	/* Only used by old server */
   struct selection		*next;
} selection;

typedef struct TripRecord {
   Boolean status;
   char *database;
   char *record;
} TripRecord;

/*
 * Prototype:
 */

int trip_openServer ( char *hostname, int port );
Boolean trip_openDb ( int tripServer, char *dbName );
void trip_selectFields ( int tripServer, char *fieldNames ); /* fieldnames separated by "," */
selection *trip_search ( int tripServer, char *selector );
char *trip_showRecord ( int server, int sel, int idx );
void trip_closeServer ( int tripServer );
selection *trip_freeSelection ( selection *sel );
void trip_newaskRecord ( int tripServer, int sel, int idx );
TripRecord *trip_newgetRecord ( int tripServer );

#endif /* TRIP_H */
