
/* Oid registery/search routines
 * Oids can be registered with a symbolic name and as 2 string representations;
 * at lookup you must specify protocol number to choose which string to return.
 *
 * OID_register(name,str1,str2)	register a new Oid.  Fail if name, str1 or str2
 *				is already registered.
 * OID_Oid2str (Oid,protocol)	Return str1 or str2 of Oid. protocol is 1 or 2.
 * OID_Oid2name(Oid)		Return the name of Oid.
 * OID_str2Oid (str)		Return the Oid with name, str1 or str2 == str.
 *				If no Oid was found, register and return a new
 *				Oid with name, str1 and str2 == str.
 */

#ifndef inc_sr_oid_h_
#define inc_sr_oid_h_
#include <ansidef.h>

#define OID_DEBUG

/* type Oid: oid->str[0: Symbolic name, 1-2: OID versions]. */

typedef struct Oid_element { /*CONST*/ char *str[3]; } Oid_element;

#ifndef OID_DEBUG

typedef struct Oid_element CONST *Oid;
#define	OID_contents(o)		(o)
#define OID_initializer(value)	((value))
#define OID_NULLPTR		((Oid)0)

#else /* OID_DEBUG */

/* Make it a struct, so gcc warns using it unprototyped. */
typedef struct Oid { struct Oid_element CONST *p; } Oid;
#define OID_contents(o)		((o).p)
#define OID_initializer(value)	{ ((value)) }
#if defined(__GNUC__) && !defined(__STRICT_ANSI__)
#define OID_NULLPTR		((struct Oid){0})
#else
extern CONST Oid		OID_NULLPTR;
#endif
#endif

Oid  OID_register  ARGDCL((const char *name, const char *o1, const char *o2));
/*CONST*/ char*	OID_Oid2name	ARGDCL((Oid));
/*CONST*/ char*	OID_Oid2str	ARGDCL((Oid, int /* 1 or 2 */));
Oid		OID_str2Oid	ARGDCL((const char *));
int		OID_str2proto	ARGDCL((const char *));
int		OID_cmp		ARGDCL((Oid, Oid));
int		OID_isNull	ARGDCL((Oid));
#define		OID_EQ(o1,o2)	(OID_contents((o1)) == OID_contents((o2)))
#define		OID_strdup(str)	strdup((str)) /* used for OID strings */
#define		OID_dup(o)	(o)
#define		OID_free(o)	((void)(o))

/* #define	OID_Oid2name(o)  ((o)->str[0])   */
/* #define	OID_Oid2str(o,i) ((o)->str[(i)]) */

/* Obsolete names */
#define		OID_get(o,i)	OID_Oid2str((o),(i))
#define		OID_name(o)	OID_Oid2name((o))

#endif
