/*
 * sr-general.h,v 1.2 1994/01/28 17:21:13 franktor Exp
 *
 * general.h
 *
 * Copyright (c) 1992  Nordic SR-NETT
 * Geir Pedersen, Geir.Pedersen@usit.uio.no
 *
*/

#ifndef SR_GENERAL_H
#define SR_GENERAL_H

#ifndef COMMA_PM_LLK_ARG	/* Remove usage of this? */
#define COMMA_PM_LLK_ARG(arg)
/*#define COMMA_PM_LLK_ARG(arg)		,arg */
#endif

/* Tried to add this here because it causes problems in several files. */
#ifdef VMS
#include <sys/types.h>
#ifdef __STDDEF /* Incompatibility with Wollongong */
#define __STDDEF_LOADED 1
#endif
#ifdef __TYPES
#define __TYPES_LOADED 1
#define __SOCKET_TYPEDEFS 1
#endif

/* errno.h in twg$tcp doesnt declare errno, and 'extern int errno' fails too */
#include <sys$library:errno.h>
#endif /* VMS */

#include <ansidef.h>
#ifndef ARGDCL
#if (__STDC__) || defined (__cplusplus) || defined(c_plusplus)
#  define ARGDCL(args)		args	/* Arguments in function declaration */
#  define CONST			const
#else
#  define ARGDCL(args)		()
#  define CONST
#endif
#endif

#ifndef VMS
typedef enum Boolean { True=1, False=0 } Boolean;

#ifndef EX_OK
#define	EX_OK	0			/* "success" exit code for programs */
#endif

#else /* VMS */
typedef int Boolean; enum { True=1, False=0 }; /* Because enums cant be used
						* as && and || operands      */
#define EX_OK	1

#if !(defined(FD_ZERO) || defined(FD_SET))
/* These are simplified for now, only handle 32 bits */
typedef int fd_set[1];		/* Was "int *" */
#define FD_CHECK(fd)		((unsigned)(fd) < (unsigned)(8*sizeof(fd_set)) || (printf("(FD %d\n", (fd)),abort(),0))
#define FD_SET(fd, fds)         (FD_CHECK((fd)), *((int *)(fds)) |=   1 << (fd))
#define FD_CLR(fd, fds)		(FD_CHECK((fd)), *((int *)(fds)) &= ~(1 << (fd)))
#define FD_ISSET(fd, fds)       (FD_CHECK((fd)), *((int *)(fds)) &    1 << (fd))
#define FD_ZERO(fds)            (*((int *)(fds)) =  0)
#endif
#endif /* VMS */

#include <sr-logger.h>
#include <sr-oid.h>

#ifndef NULLCP
#define NULLCP ((char *) 0)
#endif

/* Default address and port of the highlevel client-server */
#define	DEFAULT_HCLIENT_ADDRESS		"gandalf.uio.no"
#define	DEFAULT_HCLIENT_PORT		2402

/* Default location of SR server in the X.500 Directory */
#define DEFAULT_SERVER_DN_FMT "@c=NO@o=Universitetet i Oslo@cn=%s@cn=SR BASIC"

/* Various OIDs */
#define SR_BER_OID			"2.1.1"
#define SR_ASN1_OID			"2.2.1.0.1"

#define SR_BASIC       			"1.0.10163.1.1"
#define SR_PCI				"1.0.10163.2.1"

#define SR_RECORDSYNTAX 		"1.0.10163.5"
#define SR_RECORDSYNTAX_UNIMARC 	"1.0.10163.5.1"
#define SR_RECORDSYNTAX_INTERMARC 	"1.0.10163.5.2"
#define SR_RECORDSYNTAX_CCF		"1.0.10163.5.3"
#define SR_RECORDSYNTAX_US_MARC		"1.0.10163.5.10"
#define SR_RECORDSYNTAX_UK_MARC		"1.0.10163.5.11"
#define SR_RECORDSYNTAX_NORMARC		"1.0.10163.5.12"
#define SR_RECORDSYNTAX_LIBRISMARC	"1.0.10163.5.13"
#define SR_RECORDSYNTAX_DANMARC		"1.0.10163.5.14"
#define SR_RECORDSYNTAX_FINMARC		"1.0.10163.5.15"
#define SR_RECORDSYNTAX_MAB1 		"1.0.10163.5.16"
#define SR_RECORDSYNTAX_CANMARC		"1.0.10163.5.17"
#define SR_RECORDSYNTAX_SBN 		"1.0.10163.5.18"
#define SR_RECORDSYNTAX_PICAMARC 	"1.0.10163.5.19"

/* SR/UiO local recordsyntax		 1.0.10163.5.99 */

#define Z3950_BASIC       		"1.2.840.10003.1.1" /* basic-Z39.50-ac; application-context */
#define Z3950_PCI			"1.2.840.10003.2.1" /* Z39.50-apdus, abstract-syntax */

#define Z3950_RECORDSYNTAX 		"1.2.840.10003.5"
#define Z3950_RECORDSYNTAX_UNIMARC 	"1.2.840.10003.5.1"
#define Z3950_RECORDSYNTAX_INTERMARC 	"1.2.840.10003.5.2"
#define Z3950_RECORDSYNTAX_CCF		"1.2.840.10003.5.3"
#define Z3950_RECORDSYNTAX_US_MARC	"1.2.840.10003.5.10"
#define Z3950_RECORDSYNTAX_UK_MARC	"1.2.840.10003.5.11"
#define Z3950_RECORDSYNTAX_NORMARC	"1.2.840.10003.5.12"
#define Z3950_RECORDSYNTAX_LIBRISMARC	"1.2.840.10003.5.13"
#define Z3950_RECORDSYNTAX_DANMARC	"1.2.840.10003.5.14"
#define Z3950_RECORDSYNTAX_FINMARC	"1.2.840.10003.5.15"
#define Z3950_RECORDSYNTAX_MAB1 	"1.2.840.10003.5.16"
#define Z3950_RECORDSYNTAX_CANMARC	"1.2.840.10003.5.17"
#define Z3950_RECORDSYNTAX_SBN 		"1.2.840.10003.5.18"
#define Z3950_RECORDSYNTAX_PICAMARC 	"1.2.840.10003.5.19"

/* Z3950 locally defined recordsyntaxes  1.2.840.10003.5.1000.* */
/* Z3950 nonbibliographic transfersyntax 1.2.840.10003.7.*      */

#define ISO2709_TRANSFERSYNTAX_CHARENC	"1.0.2709.1.1"

extern Oid	Oid_SR_BER,	Oid_SR_ASN1;

extern Oid	Oid_SR_BASIC,	Oid_Z3950_BASIC; /* ???? Er disse like ???? */
extern Oid	Oid_SR_PCI,	Oid_Z3950_PCI;	 /* ???? Er disse like ???? */

extern Oid	Oid_RECORDSYNTAX,		Oid_RECORDSYNTAX_UNIMARC;
extern Oid	Oid_RECORDSYNTAX_INTERMARC,	Oid_RECORDSYNTAX_CCF;
extern Oid	Oid_RECORDSYNTAX_US_MARC,	Oid_RECORDSYNTAX_UK_MARC;
extern Oid	Oid_RECORDSYNTAX_NORMARC,	Oid_RECORDSYNTAX_LIBRISMARC;
extern Oid	Oid_RECORDSYNTAX_DANMARC,	Oid_RECORDSYNTAX_FINMARC;
extern Oid	Oid_RECORDSYNTAX_MAB1,		Oid_RECORDSYNTAX_CANMARC;
extern Oid	Oid_RECORDSYNTAX_SBN,		Oid_RECORDSYNTAX_PICAMARC;

extern Oid	Oid_DIAGSET_BIB1,		Oid_ATTRSET_BIB1;

extern Oid	Oid_ISO2709_TRANSSYNTAX_CHARENC; /* Max 31 chars in VMS */

extern Oid	Oid_NULL;

typedef struct octetString {
   int			len;
   char			*value;
} octetString;

#define NULLOS		(octetString *) NULL

octetString	*osalloc ARGDCL(( void ));
void		 osfree	ARGDCL (( octetString *oc ));
octetString	*str2os	ARGDCL (( const char *str ));
char		*os2str	ARGDCL (( octetString *oc ));
octetString	*osdup	ARGDCL (( octetString *oc ));
octetString	*oscpy	ARGDCL (( octetString *dest, octetString *src ));

extern char	*strdup			ARGDCL((const char *s1 ));
extern int	Warn_UNIMPLEMENTED	ARGDCL((Facility fac, const char *fn));

#endif /* SR_GENERAL_H */
