/*
 * server-structs.h,v 1.1 1994/01/28 17:06:03 franktor Exp
 *
 * Hivhlevel Server definitions:
 */

#ifndef VMS
#include <high/common-structs.h>
#else
#include <common-structs.h>
#endif

#ifndef SERVER_STRUCTS_H
#define SERVER_STRUCTS_H

typedef struct HS_SearchRequest {
  DatabaseName *databaseNames;
  Query *query;
} HS_SearchRequest;

typedef struct HS_SearchResponse {
  int numberOfRecordsFound;
  Boolean searchStatus;
  ResultSetStatus resultSetStatus;
  int resultSetId;
} HS_SearchResponse;

typedef struct HS_PresentRequest {
  int resultSetId;
  int resultSetStartPoint;
  int numberOfRecordsRequested;
  RecordComposition *recordComposition;
  char *preferredRecordSyntax;
} HS_PresentRequest;

typedef struct HS_PresentResponse {
  int numberOfRecordsReturned;
  PresentStatus presentStatus;
  struct HlvlRecords *records;
} HS_PresentResponse;

typedef struct HS_DeleteResultSetRequest {
  Boolean all;
  int resultSetId;
} HS_DeleteResultSetRequest;

typedef struct HS_DeleteResultSetResponse {
  Boolean status;
} HS_DeleteResultSetResponse;

typedef struct HS_InterruptRequest {
  int filler;
} HS_InterruptRequest;

typedef struct HS_InterruptResponse {
  Boolean canceled;
} HS_InterruptResponse;

typedef struct HS_OpenRequest {
  int filler;
} HS_OpenRequest;

typedef struct HS_OpenResponse {
  Boolean openAccepted;
  char *message;		/* Optional diagnostic message */
} HSOpenResponse;

typedef struct HSCloseRequest {
  int filler;
} HSCloseRequest;

typedef struct HSCloseResponse {
  Boolean closeAccepted;
  char *message;		/* Optional diagnostic message */
} HSCloseResponse;

/*
 * The HS_Packet structure holds the data which is to be sent to the
 * database via the API-2 protocol.
 * I've collected them in a single struct so that the interface will
 * only need one function to send data and one to receive data.
 */

/*
 * enums describing the type (of union) for an hivhlevel server packet.
 */

typedef enum HS_PacketTypes {
  hsSearchRequest = 0, hsSearchResponse = 1,
  hsPresentRequest = 2, hsPresentResponse = 3,
  hsDeleteResultSetRequest = 4, hsDeleteResultSetResponse = 5,
  hsInterruptRequest = 6, hsInterruptResponse = 7,
  hsOpenRequest = 8, hsOpenResponse = 9,
  hsCloseRequest = 10, hsCloseResponse = 11,
  hsNone = 12
} HS_PacketTypes;

typedef struct HS_Packet
{
  HS_PacketTypes type;	/* Tells which of the below is used */
  int ref;		/* Identifies which connection for send/receive */
  union
  {				/* the ordering and numbering here must correspond with EapiType */
    HS_SearchRequest		*search_request;
    HS_SearchResponse		*search_response;
    HS_PresentRequest		*present_request;
    HS_PresentResponse		*present_response;
    HS_DeleteResultSetRequest	*delete_result_set_request;
    HS_DeleteResultSetResponse	*delete_result_set_response;
    HS_InterruptRequest		*interrupt_request;
    HS_InterruptResponse		*interrupt_response;
    HS_OpenRequest		*open_request;
    HS_OpenResponse		*open_response;
    HS_CloseRequest		*close_request;
    HS_CloseResponse		*close_response;
  } u;
} HS_Packet;
#endif
