/*
 * util.c,v 1.3 1994/01/31 02:04:12 franktor Exp
 */

#include "client.h"
#include <malloc.h>
#include <sr-util.h>		/* safe-strdup() */

#if 0 /* Hmm, maybe this should be used instead. */
RecordComposition *
copyRecordCompositon (RecordComposition *src)
{
   RecordComposition *ret = (RecordComposition *) malloc (sizeof (*ret));
   if ( (ret->genericRecordComposition = src->genericRecordComposition) )
      ret->u.generic = safe_strdup ( src->u.generic );
   else
   {
      RCNameAndId *src_rd, *dest_rd, **dest_rdP = &ret->u.databaseSpecific;
      for ( src_rd = src->u.databaseSpecific;  src_rd;  src_rd = src_rd->next )
      {
	 *dest_rdP = dest_rd = (RCNameAndId *) malloc (sizeof (RCNameAndId));
	 dest_rd->databaseName = safe_strdup ( src_rd->databaseName );
	 dest_rd->recordCompositionId = safe_strdup ( src_rd->recordCompositionId );
	 dest_rdP = &dest_rd->next;
      }
      *dest_rdP = NULL;
   }
   return ret;
}
#endif

RCNameAndId *
copyRCNameAndId (RCNameAndId *in)
{
  RCNameAndId *out;

  LOG(facHigh, llevTrace, "Entering copyRCNameAndId()");

  out = (RCNameAndId *) malloc(sizeof(RCNameAndId));
  if (in->databaseName)
    out->databaseName = strdup(in->databaseName);
  else
    out->databaseName = (char *) NULL;
  if (in->recordCompositionId)
    out->recordCompositionId = strdup(in->recordCompositionId);
  else
    out->recordCompositionId = (char *) NULL;
  if (in->next)
    out->next = copyRCNameAndId(in->next);
  else
    out->next = (RCNameAndId *) NULL;
  return out;
}

RecordComposition *
copyRecordComposition (RecordComposition *comp)
{
  RecordComposition *ret;

  LOG(facHigh, llevTrace, "Entering copyRecordComposition()");

  if (comp == (RecordComposition *) NULL)
    return (RecordComposition *) NULL;

  ret = (RecordComposition *) malloc(sizeof(RecordComposition));
  if ((ret->genericRecordComposition = comp->genericRecordComposition) == True)
    if (comp->u.generic)
      ret->u.generic = strdup(comp->u.generic);
    else
      ret->u.generic = (char *) NULL;
  else
    if (comp->u.databaseSpecific)
      ret->u.databaseSpecific = copyRCNameAndId(comp->u.databaseSpecific);
    else
      ret->u.databaseSpecific = (RCNameAndId *) NULL;
  return ret;
}

Query *
copyQuery(Query *q)
{
  octetString *os;
  Query *out;
  int not_nullterminated = 0;

  LOG(facHigh, llevTrace, "Entering copyQuery()");
  if (q == (Query *) NULL)
    return (Query *) NULL;

  out = (Query *) malloc(sizeof(Query));
  out->kind = q->kind;
  switch(q->kind)
  {
  case queryRpnQuery:
    out->q.rpnQuery = NULL;
    LOG(facHigh, llevExceptions, "RpnQuery not supported yet.");
    break;
  case queryPrivate:
    LOG(facHigh, llevExceptions, "Private query not supported yet.");
    break;
  case queryIso8777Query:
    if (*(q->q.iso8777Query->value + q->q.iso8777Query->len - 1))
      not_nullterminated = 1;
    os = (octetString *) malloc(sizeof(octetString));
    os->len = q->q.iso8777Query->len;
    os->value = (char *) malloc(os->len + not_nullterminated);
    (void) memcpy(os->value, q->q.iso8777Query->value, os->len);
    if (not_nullterminated) /* Add a trailing null-byte to help structcodec */
      * (os->value + os->len++) = '\0';
    out->q.iso8777Query = os;
  }
  return out;
}
