/*
 * hlvlrecords.c,v 1.2 1994/01/30 17:10:38 franktor Exp
 */

#include "client.h"
#include <sr-util.h>
#include <malloc.h>
octetString *oscpy(octetString *dest, octetString *src); /* from records.c */


HlvlDiagRec *
ConvertToHlvlDiagRec (DiagRec *diag)
{
   HlvlDiagRec	*e_diag = (HlvlDiagRec *) malloc (sizeof(HlvlDiagRec));
   e_diag->diagnosticSetId = OID_Oid2name (diag->diagnosticSetId);
   if ( !OID_EQ (diag->diagnosticSetId, Oid_DIAGSET_BIB1) )
      LOG(facHigh, llevExceptions, "DiagRec with unsupported diagnostic set %s", e_diag->diagnosticSetId);
   e_diag->condition	   = diag->condition;
   e_diag->addinfo	   = safe_strdup (diag->addinfo);
   return e_diag;
}


HlvlNamePlusRecord *
ConvertToHlvlNamePlusRecord (NamePlusRecord *rec)
{
   HlvlNamePlusRecord *e_rec = (HlvlNamePlusRecord *) malloc (sizeof(HlvlNamePlusRecord));
   switch (rec->nprKind)
   {
    case nprRecord:
      e_rec->recKind = recHlvlRecord;
      oscpy (&e_rec->u.record.databaseRecord, rec->u.databaseRecord->octStr);
      e_rec->u.record.databaseName   = safe_strdup (rec->databaseName);
      e_rec->u.record.recordSyntax   = NULL; /* ???? Where do I get this? */
      break;

    case nprDiag:
      e_rec->recKind = recHlvlSurrogateDiagRec;
      e_rec->u.surrogateDiagnostic =
	 ConvertToHlvlDiagRec (rec->u.surrogateDiagnostic);
      break;
   }
   e_rec->next = NULL;
   return e_rec;
}


HlvlRecords *
ConvertToHlvlRecords (Records *rec)
{
   HlvlRecords		*e_rec = (HlvlRecords *) malloc (sizeof(HlvlRecords));
   HlvlNamePlusRecord	**prevP;
   NamePlusRecord	*tmp;

   if (rec == (Records *) NULL)
      return (HlvlRecords *) NULL;

   switch (rec->recKind)
   {
    case recNamePlusRecord:
      e_rec->recKind = recHlvlNamePlusRecord;
      prevP = &e_rec->u.databaseOrSurDiagnostics;
      for (tmp = rec->u.databaseOrSurDiagnostics; tmp; tmp = tmp->next)
      {
	 *prevP	= ConvertToHlvlNamePlusRecord (tmp);
	 prevP	= &(*prevP)->next;
      }
      *prevP = NULL;		/* Trengs her og i records.c ?  --hbf */
      break;

    case recDiagRec:
      e_rec->recKind = recHlvlNonSurrogateDiagRec;
      e_rec->u.nonSurrogateDiagnosticRecord =
	 ConvertToHlvlDiagRec (rec->u.nonSurrogateDiagnostic);
      break;
   }
   return e_rec;
}
