######################################################################
## MSC 7.0
## C++ makefile for example programs
## Windows Tech Journal, OOP Alley, July 1993
## Demonstrates DiskTutor collection class library
## Greg Voss
######################################################################
## Usage Notes:
## To build example programs:
##     nmake /fmsc70.mak
##          or
##     nmake /fmsc70.mak all
##
## To run test suite
##     nmake /fmsc70.mak verify
##
## To clean intermediate *.obj files:
##     nmake /fmsc70.mak clean
######################################################################



######################################################################
CCDEBUG = /Od /Zi
LNKDEBUG = /CO
MODEL = S       # C small memory model
USR_INCLUDE_DIR =   ..\include
USR_LIB_DIR     =   ..\lib
##I = c:\c700\include   ## Environment variables used instead
USRLIB=dt.lib

CC = cl
LNK = link
CFLAGS = $(CCDEBUG) /A$(MODEL) /Gs /I$(USR_INCLUDE_DIR)
LFLAGS = $(LNKDEBUG)
######################################################################
## Meaning of CFLAGS for MSC 7.0 Compiler
## /AS      small memory model
## /Gs      turn off run-time stack checking
## /Od      turn off all optimizations (use with /Zi for debugging)
## /Zi      include symbolic debug information in obj files
## /Ipath   dir indicates additional path to search for #include
######################################################################

######################################################################
## Meaning of LFLAGS for MSC 7.0 Linker
## /CO      include symbolic debug information in exe files
######################################################################


######################################################################
## Rules
######################################################################
.obj.exe:
    $(LNK) $(LFLAGS) $*, , NUL, $(USR_LIB_DIR)\ $(USRLIB), NUL

.cpp.obj:
    $(CC) /c $(CFLAGS) $<


######################################################################
## Default targets
######################################################################
all:    \
        bag.exe     \
        set.exe     \
        array.exe   \
        oc.exe      \
        sc.exe      \
        dict1.exe   \
        dict2.exe   \
        dict3.exe


######################################################################
## Target dependencies and explicit rules
######################################################################
bag.exe: bag.obj
    $(LNK) $(LFLAGS) $*, , NUL, $(USR_LIB_DIR)\ $(USRLIB), NUL

set.exe: set.obj
    $(LNK) $(LFLAGS) $*, , NUL, $(USR_LIB_DIR)\ $(USRLIB), NUL
            
## Indexed Collection
array.exe: array.obj
    $(LNK) $(LFLAGS) $*, , NUL, $(USR_LIB_DIR)\ $(USRLIB), NUL

## Ordered Collection
oc.exe: oc.obj
    $(LNK) $(LFLAGS) $*, , NUL, $(USR_LIB_DIR)\ $(USRLIB), NUL

## Sorted Collection
sc.exe: sc.obj
    $(LNK) $(LFLAGS) $*, , NUL, $(USR_LIB_DIR)\ $(USRLIB), NUL

## Dictionary (simple phone book)
dict1.exe: dict1.obj
    $(LNK) $(LFLAGS) $*, , NUL, $(USR_LIB_DIR)\ $(USRLIB), NUL

## Dictionary (of Address objects)
dict2.exe: dict2.obj
    $(LNK) $(LFLAGS) $*, , NUL, $(USR_LIB_DIR)\ $(USRLIB), NUL
  
## Dictionary (simple symbol table)
dict3.exe: dict3.obj
    $(LNK) $(LFLAGS) $*, , NUL, $(USR_LIB_DIR)\ $(USRLIB), NUL


######################################################################
## Verification Test Suite
## Requires diff.exe (installed in ..\dtlibv)
######################################################################
DIFF_DIR=..\dtlibv              ## source directory for diff.exe
verify:
        -bag.exe     >out.v
            -$(DIFF_DIR)\diff out.v  bag.v
        -set.exe     >out.v
            -$(DIFF_DIR)\diff out.v  set.v
        -array.exe   >out.v
            -$(DIFF_DIR)\diff out.v  array.v
        -oc.exe      >out.v
            -$(DIFF_DIR)\diff out.v  oc.v
        -sc.exe      >out.v
            -$(DIFF_DIR)\diff out.v  sc.v
        -dict1.exe   >out.v
            -$(DIFF_DIR)\diff out.v  dict1.v
        -dict2.exe   >out.v
            -$(DIFF_DIR)\diff out.v  dict2.v
        -dict3.exe   >out.v
            -$(DIFF_DIR)\diff out.v  dict3.v
        -del out.v

clean:
    del *.obj

