#include "point.h"
#include "ordcltn.h"
#include "set.h"

main()
{
    cout << "\nTest class OrderedCltn\n";
    Point A(1,1);
    Point B(1,2);
    Point C(1,3);
    Point D(1,3);
    OrderedCltn b(16);
    OrderedCltn c;
    b.add(A);
    b.add(B);
    b.add(C);
    b.add(D);
    cout << "b = " << b << "\n";
    cout << "b.first(): " << *(b.first()) << "\n";
    cout << "b.last(): " << *(b.last()) << "\n";
    b.addAfter(Point(1,2),   *new Point(1,21));
    b.addBefore(Point(1,2),  *new Point(1,19));
    cout << "b = " << b << "\n";
    cout << "b.after(Point(1,2)): " << *(b.after(Point(1,2))) << "\n";
    cout << "b.before(Point(1,2)): " << *(b.before(Point(1,2))) << "\n";
    c = b;
    b.reSize(30);
    cout << "b.includes(C): " << b.includes(C) << "\n";
    cout << "c == b: " << (c==b) << "\n";
    b.addAllLast(c);
    cout << "b = " << b << "\n";
    b.remove(C);
    cout << "b.includes(C): " << b.includes(C) << "\n";
    cout << "b = " << b << "\n";
    cout << "c == b: " << (c==b) << "\n";
    cout << "c&b:" << (c&b) << "\n";
    cout << "b.indexOfSubCollection(c): " << b.indexOfSubCollection(c,1) << "\n";
    cout << "c = " << c << "\n";
    b.replaceFrom(1,3,c);
    cout << "b.replaceFrom(1,3,c): " << b << "\n";
    b.sort();
    cout << "b.sort(): " << b << "\n";
    cout << "b.asSet(): " << (b.asSet()) << "\n";
    return 0;
}
