//----------------------------------------------------------------------
// File: CGWINDOW.H
//----------------------------------------------------------------------
#ifndef __CGWINDOW_H
     #define __CGWINDOW_H

//----------------------------------------------------------------------
// DEFINES
// Purpose: Microsoft magin numbers for standard controls
class names
//----------------------------------------------------------------------
#define BUTTONCLASS (0x80)
#define EDITCLASS        (0x81)
#define STATICCLASS (0x82)
#define LISTBOXCLASS     (0x83)
#define SCROLLBARCLASS   (0x84)
#define COMBOBOXCLASS    (0x85)

#define MAXEDIT          (0)

#ifndef RC_INVOKED

//----------------------------------------------------------------------
// STRUCTURE: DLGTEMPLATE
// Purpose: Defines the contents of a dialog box resource
//----------------------------------------------------------------------
typedef struct {
     LONG Style;
     BYTE ItemCount;
     int  X,
          Y,
          CX,
          CY;
} DLGTEMPLATE, *PDLGTEMPLATE, FAR *LPDLGTEMPLATE, NEAR
*NPDLGTEMPLATE;

//----------------------------------------------------------------------
// STRUCTURE: DLGHDR
// Purpose: Contains a general description of the dialog box
resource
//----------------------------------------------------------------------
typedef struct {
     LONG Style;
     BYTE ItemCount;
     int  X,
          Y,
          CX,
          CY;
     char MenuName[256],
          ClassName[256],
          CaptionText[256];
} DLGHDR, *PDLGHDR, FAR *LPDLGHDR, NEAR *NPDLGHDR;

//----------------------------------------------------------------------
// STRUCTURE: DLGFONTHDR
// Purpose: Contains information about the dialog's font
//----------------------------------------------------------------------
typedef struct {
     short     PointSize;
     char szTypeFace[LF_FACESIZE];
} DLGFONTHDR, *PDLGFONTHDR, FAR *LPDLGFONTHDR, NEAR
*NPDLGFONTHDR;

//----------------------------------------------------------------------
// STRUCTURE: DLGITEMTEMPLATE
// Purpose: Defines each control in a dialog resource
//----------------------------------------------------------------------
typedef struct {
     int  X,
          Y,
          CX,
          CY,
          ID;
     LONG Style;
     char Class,
          Text;
     BYTE Info;
} DLGITEMTEMPLATE, *PDLGITEMTEMPLATE, FAR *LPDLGITEMTEMPLATE,
NEAR      *NPDLGITEMTEMPLATE;

//----------------------------------------------------------------------
// STRUCTURE: DLGITEM
// Purpose: Defines each control in a dialog resource
//----------------------------------------------------------------------
typedef struct {
     int  X,
          Y,
          CX,
          CY,
          ID;
     LONG Style;
     char Class[256],
          Text[256];
     BYTE Info;
     DWORD     Data;
} DLGITEM, *PDLGITEM, FAR *LPDLGITEM, NEAR *NPDLGITEM;

//----------------------------------------------------------------------
// TYPEDEF: PROCESSCONTROL
// Purpose: Prototypes control build function
//----------------------------------------------------------------------
typedef PTWindowsObject (*PROCESSCONTROL)(PTWindowsObject,
DLGITEM&);

//----------------------------------------------------------------------
// Class: CGWindow
//----------------------------------------------------------------------
_CLASSDEF(CGWindow)
class _EXPORT CGWindow : public TWindow {
     private:
          HFONT          hFont;
          LPSTR          AResourceName;
          int       nScaleX;
          int       nScaleY;
          RECT      Place;

     public:
                    CGWindow(PTWindowsObject, LPSTR);
     virtual        ~CGWindow();
     virtual HFONT  CreateFont(LPSTR, int);
     virtual LPSTR  GetClassName() { return "CGWindow"; }
     virtual void   PreProcessControl(DLGITEM &);
     virtual PTWindowsObject ProcessControl(DLGITEM &);
     virtual void   PostProcessControl(PTWindowsObject,
DLGITEM &);
     virtual void   SetupWindow();
     virtual void   WMSize(RTMessage) = [WM_FIRST +
WM_SIZE];
}; // C: CGWindow

//----------------------------------------------------------------------
// Class: CGWindowRegister
//----------------------------------------------------------------------
_CLASSDEF(CGWindowRegister)
class _EXPORT CGWindowRegister : public Sortable {
     private:
          Pchar               szClass;
          PROCESSCONTROL BuildIt;

     public:
                    CGWindowRegister(char *, PROCESSCONTROL
= NULL);
     virtual        ~CGWindowRegister();
     PTWindowsObject     Build(PTWindowsObject that,
DLGITEM& DlgItem)
                         { return (*BuildIt)(that, DlgItem);
}
     virtual classType isA() const { return 0; }
     virtual char _FAR *nameOf() const { return 0; }
     virtual hashValueType hashValue() const { return 0; }
     virtual int isEqual( const Object _FAR & _o) const
          { return !strcmp(RCGWindowRegister(_o).szClass,
szClass); }
     virtual int isLessThan(const Object _FAR & _o) const
     {return strcmp(szClass, RCGWindowRegister(_o).szClass)
< 0; }
     virtual void printOn( ostream _FAR & ) const { ; }
}; // C: CGWindowRegister

//----------------------------------------------------------------------
// Functions
//----------------------------------------------------------------------
LPSTR GetDlgInfo(LPDLGTEMPLATE, PDLGHDR);
LPSTR GetFontInfo(LPSTR, PDLGFONTHDR);
LPSTR GetDlgItem(LPDLGITEMTEMPLATE, PDLGITEM);
LPSTR MoveString(LPSTR, LPSTR, int);
void SetControlFont(Pvoid, Pvoid);

PTWindowsObject BuildButton(PTWindowsObject, DLGITEM&);
PTWindowsObject BuildEdit(PTWindowsObject, DLGITEM&);
PTWindowsObject BuildStatic(PTWindowsObject, DLGITEM&);
PTWindowsObject BuildListBox(PTWindowsObject, DLGITEM&);
PTWindowsObject BuildScrollBar(PTWindowsObject, DLGITEM&);
PTWindowsObject BuildComboBox(PTWindowsObject, DLGITEM&);

#endif // #ifndef RC_INVOKED
#endif // #ifndef __CGWINDOW_H


