(defun dde-test1 ()
 ; test emacs sending dde commands sychronously
 ; should return '(t nil)
 (let ((d (dde-connect "progman" "progman")))
   (prog1
    (list
     (dde-execute d "[ShowGroup(Main,1)]" 10000)  ; should be okay
     (condition-case nil  ; trap anticipated error
       (dde-execute d "[Elephant()]" 10000) ; should give error
       (dde-error nil)))  ; and thus return nil
    (dde-disconnect d)
)))

(defvar callback-alist nil)
(defvar ncallbacks 0)
(defvar dde-conv nil)

(defun test2-callback (handle topic item status)
 (save-excursion
  (set-buffer "*scratch*")
  (insert (format "command %s %s\n"
		  (cdr (assoc handle callback-alist))
		  (if status "succeeded" "failed")))
  (setq ncallbacks (+ 1 ncallbacks))
  (if (= ncallbacks 2)  ; both have called back
    (dde-disconnect dde-conv))
))

(defun dde-test2 ()
; test emacs sending dde commands asynchronously
; in *scratch* should appear:
; command elephant failed
; command showgroup succeeded
 (let ((d (dde-connect "progman" "progman")))
   (setq dde-acknowledge 'test2-callback)
   (setq dde-conv d)
   (setq ncallbacks 0)
   (setq callback-alist (cons
     (cons (dde-execute d "[ShowGroup(Main,1)]" 0) "showgroup")
     callback-alist))
   (setq callback-alist (cons
     (cons (dde-execute d "[Elephant()]" 0) "elephant")
     callback-alist))
   t
))

(defun dde-test3 ()
; test emacs sending dde requests synchronously
; should return list containing:
; * string with names of all program manager groups
; * nil
 (let ((d (dde-connect "progman" "progman")))
  (prog1
   (list
    (dde-request d "groups" 10000)
    (condition-case nil  ; trap anticipated error
      (dde-request d "kalamazoo" 10000)  ; should give error
      (dde-error nil)))  ; and thus return nil
   (dde-disconnect d)
)))

(defun test4-callback (handle topic item value)
 (save-excursion
  (set-buffer "*scratch*")
  (insert (format "request %s %s:\n%s\n" topic item value))
  (setq ncallbacks (+ 1 ncallbacks))
  (if (= ncallbacks 2)  ; both have called back
    (dde-disconnect dde-conv))
))

(defun dde-test4 ()
; test emacs sending dde requests asynchronously
; should show in *scratch* window:
; request progman groups:
; < names of all groups >
; request progman kalamazoo:
; nil
 (let ((d (dde-connect "progman" "progman")))
   (setq dde-acknowledge 'test4-callback)
   (setq dde-conv d)
   (setq ncallbacks 0)
   (dde-request d "groups" 0)
   (dde-request d "kalamazoo" 0)
   t
))

; To test Emacs as a server, use Visual Basic or any of the new Microsoft
; applications that have Visual Basic built in as a shell language, such as
; Excel 5.0 or Access 2.0.
; I tested:
; send emacs command that succeeds
; send emacs command that fails
; send emacs request that succeeds
; send emacs request that fails



