;; Parse switches controlling how Emacs interfaces with X window system.
;; Copyright (C) 1990 Free Software Foundation, Inc.

;; This file is part of GNU Emacs.

;; GNU Emacs is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY.  No author or distributor
;; accepts responsibility to anyone for the consequences of using it
;; or for whether it serves any particular purpose or works at all,
;; unless he says so in writing.  Refer to the GNU Emacs General Public
;; License for full details.

;; Everyone is granted permission to copy, modify and redistribute
;; GNU Emacs, but only under the conditions described in the
;; GNU Emacs General Public License.   A copy of this license is
;; supposed to have been given to you along with GNU Emacs so you
;; can know your rights and responsibilities.  It should be in a
;; file named COPYING.  Among other things, the copyright notice
;; and this notice must be preserved on all copies.


;; X-win.el: this file is loaded from ../lisp/startup.el when it
;; recognizes that X windows are to be used.  The X display is opened
;; and hooks are set for popping up the initial window.

;; startup.el will then examine startup files, and eventually call the hooks
;; which create the first window (s).


;;; If you want to change this variable, this is the place you must do it.
;;; Do not set it to a string containing periods.  X doesn't like that.
;(setq x-emacs-application-class "Emacs")


;; The daemon stuff isn't really useful at the moment.
(defvar x-daemon-mode nil
  "When set, means initially create just a minibuffer.")
	  
(defun x-establish-daemon-mode (switch)
  (setq x-daemon-mode t))

(if (eq window-system 'x)
    (progn
      (setq window-setup-hook (cons 'x-pop-initial-window window-setup-hook))
      (setq screen-creation-func 'x-create-screen)
      (require 'screen)
      (require 'x-faces)
      (require 'x-iso8859-1)
      (setq suspend-hook
	    '(lambda ()
	       (error "Suspending an emacs running under X makes no sense")))
      (setq command-line-args-left (cdr (x-open-connection command-line-args)))
      )
  (error "Loading x-win.el but not compiled for X"))


;;; selections and active regions

;;; When something is placed on the kill-ring, we assert it as the
;;; Clipboard selection.
;;;
;;; If and only if zmacs-regions is true:
;;;
;;; When a mark is pushed and the region goes into the "active" state, we
;;; assert it as the Primary selection.  This causes it to be hilighted.
;;; When the region goes into the "inactive" state, we disown the Primary
;;; selection, causing the region to be dehilighted.
;;;
;;; Note that it is possible for the region to be in the "active" state
;;; and not be hilighted, if it is in the active state and then some other
;;; application asserts the selection.  This is probably not a big deal.

(defun x-activate-region-as-selection ()
  (if (marker-buffer (mark-marker t))
      (x-own-selection (cons (point-marker t) (mark-marker t)))))

;(setq kill-hooks 'x-own-clipboard)
(setq kill-hooks '(x-own-clipboard x-store-cutbuffer))

;;; these are only ever called if zmacs-regions is true.
(setq zmacs-deactivate-region-hook 'x-disown-selection)
(setq zmacs-activate-region-hook 'x-activate-region-as-selection)
(setq zmacs-update-region-hook 'x-activate-region-as-selection)

;; This is the function which creates the first X window.  It is called
;; from startup.el after the user's init file is processed.

(defun x-pop-initial-window ()
  ;; xterm.c depends on using interrupt-driven input.
  (set-input-mode t nil t)
  (require 'x-mouse)
  (require 'xselect)
  (setq mouse-motion-handler 'x-track-pointer)
  (setq character-set-property 'x-iso8859/1) ; see x-iso8859-1.el
  ;; see screen.el for this function
  (pop-initial-screen ())
  (delete-screen terminal-screen)
  )


;; Keypad type things
;; this is so that where-is says beginning-of-buffer is M-< instead of f27.
(fset 'fkey-beginning-of-buffer 'beginning-of-buffer)
(fset 'fkey-end-of-buffer	'end-of-buffer)
(fset 'fkey-scroll-down		'scroll-down)
(fset 'fkey-scroll-up		'scroll-up)
(fset 'fkey-scroll-left		'scroll-left)
(fset 'fkey-scroll-right	'scroll-right)
(fset 'fkey-scroll-other-window 'scroll-other-window)
(fset 'fkey-backward-char	'backward-char)
(fset 'fkey-forward-char	'forward-char)
(fset 'fkey-backward-word	'backward-word)
(fset 'fkey-forward-word	'forward-word)
(fset 'fkey-backward-paragraph	'backward-paragraph)
(fset 'fkey-forward-paragraph	'forward-paragraph)
(fset 'fkey-other-window	'other-window)
(fset 'fkey-backward-other-window 'backward-other-window)
(fset 'fkey-beginning-of-line	'beginning-of-line)
(fset 'fkey-end-of-line		'end-of-line)
(fset 'fkey-repeat-complex-command 'repeat-complex-command)
(fset 'fkey-overwrite-mode	'overwrite-mode)

;; these two have to be defined in this more complicated way to make
;; current-column-tracking work, sigh...
(defun fkey-previous-line (p)
  (interactive "_p")
  (setq this-command 'previous-line)
  (previous-line p))
(defun fkey-next-line (p)
  (interactive "_p")
  (setq this-command 'next-line)
  (next-line p))

(defun fkey-popup-mode-menu ()
  (interactive)
  (call-interactively (key-binding [(button3)])))

;;; These aren't bound to kbd macros like "\C-b" so that they have the
;; expected behavior even in, for example, vi-mode.

;; We use here symbolic names, assuming that the corresponding keys will
;; generate these keysyms.  This is not true on Suns, but x-win-sun.el 
;; fixes that.  If it turns out that the semantics of these keys should
;; differ from server to server, this should be moved into server-specific
;; files, but these appear to be the standard Motif and PC bindings.

;; movement by units
(define-key global-map 'left		'fkey-backward-char)
(define-key global-map 'up		'fkey-previous-line)
(define-key global-map 'right		'fkey-forward-char)
(define-key global-map 'down		'fkey-next-line)

;; movement by larger blocks
(define-key global-map '(control left)	'fkey-backward-word)
(define-key global-map '(control up)	'fkey-backward-paragraph)
(define-key global-map '(control right)	'fkey-forward-word)
(define-key global-map '(control down)	'fkey-forward-paragraph)

;; movement by pages
(define-key global-map 'prior		'fkey-scroll-down)
(define-key global-map 'next		'fkey-scroll-up)
(define-key global-map '(control prior)	'fkey-scroll-right)
(define-key global-map '(control next)	'fkey-scroll-left)
;; potential Sunisms
(define-key global-map 'pgup		'fkey-scroll-down)
(define-key global-map 'pgdn		'fkey-scroll-up)
;Undefined in Win-Emacs because redisplay does not currently handle
;scroll-left and scroll-right properly.
;(define-key global-map '(control pgup)	'fkey-scroll-right)
;(define-key global-map '(control pgdn)	'fkey-scroll-left)

;; movement to the limits
(define-key global-map 'home		'fkey-beginning-of-line)
(define-key global-map '(control home)	'fkey-beginning-of-buffer)
(define-key global-map 'end		'fkey-end-of-line)
(define-key global-map '(control end)	'fkey-end-of-buffer)
(define-key global-map 'begin		'fkey-beginning-of-line)
(define-key global-map '(control begin)	'fkey-beginning-of-buffer)

;; movement between windows
(define-key global-map '(control tab)	'fkey-other-window)
(define-key global-map '(control shift tab) 'fkey-backward-other-window)

;; movement in other windows
(define-key global-map '(meta pgdn)	'fkey-scroll-other-window)
(define-key global-map '(meta pgup)	'scroll-other-window-down)
(define-key global-map '(meta home)	'beginning-of-buffer-other-window)
(define-key global-map '(meta end)	'end-of-buffer-other-window)

;;; Miscellaneous key bindings

(define-key global-map 'again		'fkey-repeat-complex-command)
(define-key global-map 'insert		'fkey-overwrite-mode)

(define-key global-map 'kp_enter	[return]) ; do whatever RET does now
(define-key global-map 'kp_tab		[tab])

(define-key global-map 'undo		'undo)
(define-key global-map 'help		'help-for-help)
(define-key help-map   'help		'help-for-help)

(cond ((system-pc-os-p)
       ;; On PC's, there is definitely not a `copy', `paste', etc.
       ;; but there are some standard bindings for these functions.
       (define-key global-map '(shift delete)	'x-kill-primary-selection)
       (define-key global-map '(shift insert)	'x-yank-clipboard-selection)
       (define-key global-map '(control insert)	'x-copy-primary-selection)
       (define-key global-map '(control delete) 'x-delete-primary-selection))
      (t
       ;; (Are these Sunisms?)
       (define-key global-map 'copy		'x-copy-primary-selection)
       (define-key global-map 'paste		'x-yank-clipboard-selection)
       (define-key global-map 'cut		'x-kill-primary-selection)))

(define-key global-map 'menu		'fkey-popup-mode-menu)
;(define-key global-map '(shift menu)	'x-goto-menubar) ;NYI

;; if we define these this way (instead of leaving them bound to self-
;; insert-command), then the show-bindings display is hidiously cluttered.
;(define-key global-map 'kp_space	" ")
;(define-key global-map 'kp_equal	"=")
;(define-key global-map 'kp_multiply	"*")
;(define-key global-map 'kp_add		"+")
;(define-key global-map 'kp_separator	",")
;(define-key global-map 'kp_subtract	"-")
;(define-key global-map 'kp_decimal	".")
;(define-key global-map 'kp_divide	"/")

;; fix backspace/delete problem. (Win-Emacs addition)

(defun fix-backspace-and-delete ()
       (define-key (current-local-map) 'backspace
	 (key-binding 'delete))
       (define-key (current-local-map) 'delete
	 (key-binding [(control d)]))
       (remove-hook (intern (concat (symbol-name major-mode) "-hook"))
		    'fix-backspace-and-delete))

(defun fkey-do-button2 ()
  (interactive)
  (call-interactively (key-binding [(button2)])))

(if (system-pc-os-p)
    (progn
      ;; this is what the pgup/pgdn keys used to be called.
      (define-key global-map 'page\ up		[pgup])
      (define-key global-map 'page\ down	[pgdn])
      ;; access middle button on a two-button mouse.
      ;the following ought to work but it doesn't.
      ;(define-key global-map '(meta button3)	[button2])
      ;so we do this garbage instead:
      (define-key global-map '(meta button3)	'fkey-do-button2)

      ;; now fix up backspace and delete ...

      (global-set-key 'delete 'delete-char)
      (global-set-key 'backspace 'delete-backward-char)
      
      (mapcar (function
	       (lambda (x)
		 (or (and (boundp x)
		 	  (memq 'fix-backspace-and-delete (symbol-value x)))
		     (add-hook x 'fix-backspace-and-delete))))
	      '(ada-mode-hook
		c-mode-hook
		c++-mode-hook
		edit-picture-hook
		emacs-lisp-mode-hook
		icon-mode-hook
		lisp-interaction-mode-hook
		lisp-mode-hook
		mim-mode-hook
		perl-mode-hook
		scheme-mode-hook
		simula-mode-hook))
      ))



;; Horizontal split window do not work in this emacs
(substitute-key-definition 'split-window-horizontally 'x-new-screen global-map)
(substitute-key-definition 'split-window-horizontally 'x-new-screen ctl-x-map)
