;; System-dependent Lisp stuff
;; Copyright (C) 1994 Pearl Software.

;; This file is part of GNU Emacs.

;; GNU Emacs is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; GNU Emacs is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with GNU Emacs; see the file COPYING.  If not, write to
;; the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

;; ******************************************************************
;; This file is meant to be loaded at the very beginning of loaddefs.el.
;; It defines abstractions of system-dependent stuff that can be used
;; in other Lisp files.

;; Because of the proliferation of operating systems, subsystems,
;; extenders, et al, we create abstractions onto the `system-type'
;; variable.  This way, if some new mode or API or whatever comes out,
;; we can just update the functions below.

(defun system-pc-os-p ()
  "Non-nil if Emacs is running on a `PC' operating system.
This is MS-DOS, Windows, Windows NT, or OS/2.  Among other things,
this means that backslashes are allowable file-name separators and
the text/binary file-type distinction applies."
  (memq system-type '(ms-dos ms-windows Windows-NT)))

(defun system-msdos-p ()
  "Non-nil if Emacs is running under MS-DOS (or Windows).
This does not include Windows NT."
  (memq system-type '(ms-dos ms-windows)))

(defun system-mswin-api-p ()
  "Non-nil if Emacs is running under Windows or Windows NT."
  (memq system-type '(ms-windows Windows-NT)))

(provide 'sysdep)
  
