/*
 * xt/stub.c
 *
 * copyright (c) 1993 Pearl Software, Berkeley, CA
 *
*/

#include "IntrinsicI.h"
#include "../callback.h"
/* #include "../prop-cb.h" */
#include "../debug.h"
#include <dos.h>
#include <errno.h>
#include <stdio.h>

/* shut up about unused parameters */
#pragma disable_message(202)

/* 
   This module implements the XLib calls used in the X Toolkit and
   provides stubbed-out versions of X Toolkit calls not ported.  Some
   of the XLib calls are stubbed-out, when the X Toolkit will work
   without any functionality from them.

   Note that the "display" argument, present in many of the XLib calls,
   is ignored.
*/

/*----------------------------------------------------------------------*/
/*		      Xt function replacements				*/
/*----------------------------------------------------------------------*/

void XtAddEventHandler(Widget widget, EventMask eventMask, _XtBoolean other,
    XtEventHandler proc, XtPointer closure)
{
    widget->core.event_table = (XtEventTable) proc;
}

/* a nice cheesy implementation of this function.  Doesn't need to do
   much.  The second and fourth parameters below are not used in the
   shell's EventHandler() so we just fudge them. */
Boolean XtDispatchEvent(XEvent *event)
{
    Widget widget = XtWindowToWidget(NULL, event->xany.window);
    XtEventHandler proc = (XtEventHandler) widget->core.event_table;

    if (proc) {
	(*proc)(widget, NULL, event, NULL);
	return True;
    } else
	return False;
}

/* punt on this for now */

EventMask XtBuildEventMask(Widget w)
{
    return 0;
}

void _XtRegisterWindow(Window window, Widget widget)
{
    SetWindowLong((HWND) window, 4, (long) widget);
}

void _XtUnregisterWindow(Window window, Widget widget)
{
}

Widget XtWindowToWidget(Display *display, Window window)
{
    return (Widget) GetWindowLong((HWND) window, 4);
}

