/*
 * x/stub.c
 *
 * copyright (c) 1993 Pearl Software, Berkeley, CA
 *
*/

#include "Xlibint.h"
#include "Xlcint.h"
#include <X11/Xutil.h>

#ifdef BOOL
#undef BOOL
#endif

#ifdef BYTE
#undef BYTE
#endif

#include "../callback.h"

#pragma disable_message(202)

XrmMethods _XrmInitParseInfo(XPointer *statep)
{
    return NULL;
}

XSizeHints *XAllocSizeHints(void)
{
    return (XSizeHints *) X_XALLOCSIZEHINTS();
}

void XSetWMNormalHints(Display *dpy, Window w, XSizeHints *xsh)
{
    X_XSETWMNORMALHINTS(dpy, w, xsh);
}

Status XGetWMNormalHints(Display *display, Window w, XSizeHints *hints_return,
    long *supplied_return)
{
    return X_XGETWMNORMALHINTS(display, w, hints_return, supplied_return);
}

XSetWMHints(Display *dpy, Window w, XWMHints *xwmh)
{
    X_XSETWMHINTS(dpy, w, xwmh);
}

void XSetWMName(Display *dpy, Window w, XTextProperty *prop)
{
    X_XSETWMNAME(dpy, w, prop);
}

void XSetWMIconName(Display *dpy, Window w, XTextProperty *prop)
{
    X_XSETWMICONNAME(dpy, w, prop);
}

void XSetWMProperties(Display *dpy, Window w, XTextProperty *window_name,
    XTextProperty *icon_name, char **argv, int argc, XSizeHints *normal_hints,
    XWMHints *wm_hints, XClassHint *class_hints)
{
    X_XSETWMPROPERTIES(dpy, w, window_name, icon_name, argv, argc, normal_hints, wm_hints, class_hints);
}

XChangeWindowAttributes(Display *dpy, Window w, unsigned long valuemask,
    XSetWindowAttributes *attributes)
{
    X_XCHANGEWINDOWATTRIBUTES(dpy, w, valuemask, attributes);
}

Window XCreateWindow(Display *dpy, Window parent, int x, int y, unsigned int
    width, unsigned int height, unsigned int border_width, int depth,
    unsigned int class, Visual *visual, unsigned long valuemask,
    XSetWindowAttributes *attributes)
{
    return X_XCREATEWINDOW(dpy, parent, x, y, width, height, border_width, depth, class, visual, valuemask, attributes);
}

XDestroyWindow(Display *display, Window w)
{
    X_XDESTROYWINDOW(display, w);
}

XMapWindow(Display *dpy, Window w)
{
    X_XMAPWINDOW(dpy, w);
}

XRaiseWindow(Display *dpy, Window w)
{
    X_XRAISEWINDOW(dpy, w);
}

XLowerWindow(Display *dpy, Window w)
{
    X_XLOWERWINDOW(dpy, w);
}

XMapRaised(Display *dpy, Window w)
{
    X_XMAPRAISED(dpy, w);
}

XMapSubwindows(Display *dpy, Window w)
{
    X_XMAPSUBWINDOWS(dpy, w);
}

XUnmapWindow(Display *dpy, Window w)
{
    X_XUNMAPWINDOW(dpy, w);
}

XConfigureWindow(Display *display, Window w, unsigned int value_mask,
    XWindowChanges *values)
{
    X_XCONFIGUREWINDOW(display, w, value_mask, values);
}

XMoveWindow(Display *display, Window w, int x, int y)
{
    X_XMOVEWINDOW(display, w, x, y);
}

Status XIconifyWindow(Display *display, Window w, int screen_number)
{
    return X_XICONIFYWINDOW(display, w, screen_number);
}

Status XWithdrawWindow(Display *display, Window w, int screen_number)
{
    return X_XWITHDRAWWINDOW(display, w, screen_number);
}

Bool XTranslateCoordinates(Display *display, Window src_w, Window dest_w,
    int src_x, int src_y, int *dest_x_return, int *dest_y_return, Window *
    child_return)
{
    return X_XTRANSLATECOORDINATES(display, src_w, dest_w, src_x, src_y, dest_x_return, dest_y_return, child_return);
}
    
Status XAllocColor(Display *display, Colormap colormap, XColor *screen_in_out)
{
    return X_XALLOCCOLOR(display, colormap, screen_in_out);
}

Status XParseColor(Display *display, Colormap colormap, char *spec, XColor *
    exact_def_return)
{
    return X_XPARSECOLOR(display, colormap, spec, exact_def_return);
}

Status XAllocNamedColor(Display *display, Colormap colormap, char *color_name,
    XColor *screen_def_return, XColor *exact_def_return)
{
    return X_XALLOCNAMEDCOLOR(display, colormap, color_name, screen_def_return, exact_def_return);
}

XFreeColors(Display *display, Colormap colormap, unsigned long pixels[],
    int npixels, unsigned long planes)
{
    X_XFREECOLORS(display, colormap, pixels, npixels, planes);
}

XQueryColor(Display *display, Colormap colormap, XColor *def_in_out)
{
    X_XQUERYCOLOR(display, colormap, def_in_out);
}

Status XLookupColor(Display *display, Colormap colormap, char *color_name,
    XColor *exact_def_return, XColor *screen_def_return)
{
    return X_XLOOKUPCOLOR(display, colormap, color_name, exact_def_return, screen_def_return);
}

GC XCreateGC(Display *display, Drawable d, unsigned long valuemask,
    XGCValues *values)
{
    return (GC) X_XCREATEGC(display, d, valuemask, values);
}

XChangeGC(Display *display, GC gc, unsigned long valuemask, XGCValues *
    values)
{
    X_XCHANGEGC(display, gc, valuemask, values);
}
	
Status XGetGCValues(Display *display, GC gc, unsigned long valuemask, 
    XGCValues *values_return)
{
    return X_XGETGCVALUES(display, gc, valuemask, values_return);
}

XFreeGC(Display *display, GC gc)
{
    X_XFREEGC(display, gc);
}

#define do_it(xxxcaps, xxxtype, xxxallcaps) \
XSet ## xxxcaps(Display *display, GC gc, xxxtype xxxallcaps) \
{ \
\
    X_XSET ## xxxallcaps(display, gc, xxxallcaps); \
}

do_it(Foreground, unsigned long, FOREGROUND)
do_it(Background, unsigned long, BACKGROUND)
do_it(FillStyle, int, FILLSTYLE)
do_it(Stipple, Pixmap, STIPPLE)
do_it(Font, Font, FONT)
do_it(Function, int, FUNCTION)
do_it(ClipMask, Pixmap, CLIPMASK)

#undef do_it

XSetClipOrigin(Display *display, GC gc, int clip_x_origin, int clip_y_origin)
{
    X_XSETCLIPORIGIN(display, gc, clip_x_origin, clip_y_origin);
}

XClearArea(Display *display, Window w, int x, int y, unsigned int width,
    unsigned int height, Bool exposures)
{
    X_XCLEARAREA(display, w, x, y, width, height, exposures);
}

XClearWindow(Display *display, Window w)
{
    X_XCLEARWINDOW(display, w);
}

XCopyArea(Display *display, Drawable src, Drawable dest, GC gc, int src_x,
    int src_y, unsigned int width, unsigned int height, int dest_x, int
    dest_y)
{
    X_XCOPYAREA(display, src, dest, gc, src_x, src_y, width, height, dest_x, dest_y);
}

XCopyPlane(Display *display, Drawable src, Drawable dest, GC gc, int src_x,
    int src_y, unsigned int width, unsigned int height, int dest_x, int
    dest_y, unsigned long plane)
{
    X_XCOPYPLANE(display, src, dest, gc, src_x, src_y, width, height, dest_x, dest_y, plane);
}

XDrawLine(Display *display, Drawable d, GC gc, int x1, int y1, int x2, int
    y2)
{
    X_XDRAWLINE(display, d, gc, x1, y1, x2, y2);
}

XDrawRectangle(Display *display, Drawable d, GC gc, int x, int y, unsigned
    int width, unsigned int height)
{
    X_XDRAWRECTANGLE(display, d, gc, x, y, width, height);
}

XFillRectangle(Display *display, Drawable d, GC gc, int x, int y, unsigned
    int width, unsigned int height)
{
    X_XFILLRECTANGLE(display, d, gc, x, y, width, height);
}

XDrawString(Display *display, Drawable d, GC gc, int x, int y, char *string,
    int length)
{
    X_XDRAWSTRING(display, d, gc, x, y, string, length);
}

XDrawImageString(Display *display, Drawable d, GC gc, int x, int y, char *
    string, int length)
{
    X_XDRAWIMAGESTRING(display, d, gc, x, y, string, length);
}

Font XLoadFont(Display *display, char *name)
{
    return X_XLOADFONT(display, name);
}

XFontStruct *XQueryFont(Display *display, XID font_id)
{
    return (XFontStruct *) X_XQUERYFONT(display, font_id);
}

XFontStruct *XLoadQueryFont(Display *display, char *name)
{
    return (XFontStruct *) X_XLOADQUERYFONT(display, name);
}

XFreeFont(Display *display, XFontStruct *font_struct)
{
    X_XFREEFONT(display, font_struct);
}

int XTextWidth(XFontStruct *font_struct, char *string, int count)
{
    return X_XTEXTWIDTH(font_struct, string, count);
}

Bool XGetFontProperty(XFontStruct *font_struct, Atom atom, unsigned long *
    value_return)
{
    return X_XGETFONTPROPERTY(font_struct, atom, value_return);
}

Pixmap XCreateBitmapFromData(Display *display, Drawable d, char *data,
    unsigned int width, unsigned int height)
{
    return X_XCREATEBITMAPFROMDATA(display, d, data, width, height);
}

Pixmap XCreatePixmapFromBitmapData(Display *display, Drawable d, char *data,
    unsigned int width, unsigned int height, unsigned long fg, unsigned
    long bg, unsigned int depth)
{
    return X_XCREATEPIXMAPFROMBITMAPDATA(display, d, data, width, height, fg, bg, depth);
}

XFreePixmap(Display *display, Pixmap pixmap)
{
    X_XFREEPIXMAP(display, pixmap);
}

int XmbTextListToTextProperty(Display *dpy, char **list, int count,
    XICCEncodingStyle style, XTextProperty *text_prop_return)
{
    return X_XMBTEXTLISTTOTEXTPROPERTY(dpy, list, count, style, text_prop_return);
}

char *XScreenResourceString(Screen *screen)
{
    return (char *) X_XSCREENRESOURCESTRING(screen);
}

char *XResourceManagerString(Display *dpy)
{
    return (char *) X_XRESOURCEMANAGERSTRING(dpy);
}

XFree(XPointer x)
{
    X_XFREE(x);
}

XFlush(Display *dpy)
{
    X_XFLUSH(dpy);
}

XFlushQueue()
{
    X_XFLUSHQUEUE();
}

XBell(Display *display, int percent)
{
    X_XBELL(display, percent);
}

Display *XOpenDisplay(char *display)
{
    return (Display *) X_XOPENDISPLAY(display);
}

XCloseDisplay(Display *dpy)
{
    X_XCLOSEDISPLAY(dpy);
}

int XScreenNumberOfScreen(Screen *screen)
{
    return X_XSCREENNUMBEROFSCREEN(screen);
}

int (*XSynchronize(Display *display, Bool onoff))()
{
    return (int (*)()) X_XSYNCHRONIZE(display, onoff);
}

Region XCreateRegion()
{
    return (Region) X_XCREATEREGION();
}

XDestroyRegion(Region r)
{
    X_XDESTROYREGION(r);
}

XWarpPointer(Display* display, Window src_w, Window dest_w, int src_x,
    int src_y, unsigned int src_width, unsigned int src_height, int dest_x,
    int dest_y)
{
    X_XWARPPOINTER(display, src_w, dest_w, src_x, src_y, src_width, src_height, dest_x, dest_y);
}

Bool XQueryPointer(Display *display, Window w, Window *root_return,
    Window *child_return, int *root_x_return, int *root_y_return, int *
    win_x_return, int *win_y_return, unsigned int *mask_return)
{
    return X_XQUERYPOINTER(display, w, root_return, child_return, root_x_return, root_y_return, win_x_return, win_y_return, mask_return);
}

XChangeProperty(Display *display, Window w, Atom property, Atom type,
    int format, int mode, unsigned char *data, int nelements)
{
    X_XCHANGEPROPERTY(display, w, property, type, format, mode, data, nelements);
}

Atom XInternAtom(Display *display, char *atom_name, Bool only_if_exists)
{
    return X_XINTERNATOM(display, atom_name, only_if_exists);
}

VisualID XVisualIDFromVisual(Visual *visual)
{
    return X_XVISUALIDFROMVISUAL(visual);
}

XVisualInfo *XGetVisualInfo(Display *display, long vinfo_mask,
    XVisualInfo *vinfo_template, int *nitems_return)
{
    return (XVisualInfo *) X_XGETVISUALINFO(display, vinfo_mask, vinfo_template, nitems_return);
}

int XmuReadBitmapDataFromFile(char *file, int *w, int *h, char *data, int *
    xhot, int *yhot)
{
    return X_XMUREADBITMAPDATAFROMFILE(file, w, h, data, xhot, yhot);
}

XGrabServer(Display *display)
{
    X_XGRABSERVER(display);
}

XUngrabServer(Display *display)
{
    X_XUNGRABSERVER(display);
}

XSetInputFocus(Display *display, Window focus, int revert_to, Time time)
{
    X_XSETINPUTFOCUS(display, focus, revert_to, time);
}

XGetInputFocus(Display *display, Window *focus_return, int *revert_to_return)
{
    X_XGETINPUTFOCUS(display, focus_return, revert_to_return);
}

Status XGetWindowAttributes(Display *display, Window w, XWindowAttributes *
    window_attributes_return)
{
    return X_XGETWINDOWATTRIBUTES(display, w, window_attributes_return);
}

/* I don't feel like dealing with this right now */
int XWMGeometry(Display *display, int screen, char *user_geom, char *def_geom,
    unsigned int bwidth, XSizeHints *hints, int *x_return, int *y_return,
    int *width_return, int *height_return, int *gravity_return)
{
    return XParseGeometry(def_geom, x_return, y_return,
	(unsigned int *) width_return, (unsigned int *) height_return);
}

