%{

/*
 * proto.l
 *
 * copyright (c) 1993 Pearl Software, Oakland, CA
 *
 * Description: LEX file for generating DLL-call include files.
 *
*/

#include <stdio.h>

char tempstr1[100], tempstr2[100];
FILE *outfile[4];
int first = 1;
char Enum[100] = "enum_";
char Func[100] = "func_";
char Macro[100] = "X_";
%}


Word		([^ \t\f\n]+)
A		[A-Za-z_]
AN		[A-Za-z0-9_]
Ident		({A}{AN}*)
D		[0-9]
Num		({D}+)
WS		([ \t\f\n]+)

%%

"macro-prefix"{WS}{Ident} {
		    sscanf(yytext, "%*s %s", Macro);
		}
"enum-prefix"{WS}{Ident} {
		    sscanf(yytext, "%*s %s", Enum);
		}
"func-prefix"{WS}{Ident} {
		    sscanf(yytext, "%*s %s", Func);
		}
{Ident}		{
		    strcpy(tempstr1, yytext);
		    strcpy(tempstr2, yytext);
		    strupr(tempstr2);
		}
{Num}		{
	    int i, j;

	    i = atoi(yytext);

	    if (first) {
		for (j=0; j<4; j++)
		    fprintf(outfile[j], "/* "
			    "This file is automatically generated.  "
			    "Don't touch! */\n\n");
	    }

	    /* outfile[0] */
	    fprintf(outfile[0], "#define %s%s(", Macro, tempstr2);
	    if (i)
		fprintf(outfile[0], "arg1");
	    for (j=2; j<=i; j++)
		fprintf(outfile[0], ", arg%d", j);
	    fprintf(outfile[0], ") InvokeIndirectFunction(win_hindir[%s%s]",
		Enum, tempstr1);
	    for (j=1; j<=i; j++)
		fprintf(outfile[0], ", arg%d", j);
	    fprintf(outfile[0], ", %s%s)\n", Enum, tempstr1);

	    /* outfile[1] */
	    fprintf(outfile[1], "    DefineDLLEntry(%s%s, (void *) %s%s",
		Enum, tempstr1, Func, tempstr1);
	    for (j=1; j<=i; j++)
		fprintf(outfile[1], ", DLL_DWORD");
	    fprintf(outfile[1], ", DLL_ENDLIST);\n");

	    /* outfile[2] */
	    fprintf(outfile[2], "    win_hindir[%s%s] = "
	            "GetIndirectFunctionHandle(fp", Enum, tempstr1);
	    for (j=1; j<=i; j++)
		fprintf(outfile[2], ", INDIR_DWORD");
	    fprintf(outfile[2], ", INDIR_WORD, INDIR_ENDLIST);\n");

	    /* outfile[3] */
	    if (first)
		fprintf(outfile[3], "enum %stag {\n", Enum);
	    else
		fprintf(outfile[3], ",\n");
	    fprintf(outfile[3], "    %s%s", Enum, tempstr1);

	    first = 0;
	}
{WS}		;

%%

main(int argc, char **argv)
{
    int i;

    if (argc != 5) {
	fprintf(stderr, "Usage: proto out1 out2 out3 out4, where\n\n"
	        "out1 contains lines of the form\n"
		"#define X_FOO(arg) InvokeIndirectFunction(...)\n"
		"out2 contains lines of the form\n"
		"    DefineDLLEntry(cb_foo, ...)\n"
		"out3 contains lines of the form\n"
		"    win_hindir[cb_foo] = GetIndirectFunctionHandle(...)\n"
		"out4 contains an enum definition:\n"
		"    enum callback_tag {\n"
		"        ...\n"
		"    };\n"
	);
	return 1;
    }
    for (i=0; i<4; i++) {
	outfile[i] = fopen(argv[i+1], "wt");
	if (!outfile[i]) {
	    fprintf(stderr, "Cannot create file %s\n", argv[i]);
	    return 2;
	}
    }

    yylex();
    fclose(outfile[0]);
    fclose(outfile[1]);
    fclose(outfile[2]);
    fprintf(outfile[3], "\n,    %senum_end\n};\n", Enum);
    fclose(outfile[3]);
    return 0;
}
