/*
 * main.c
 *
 * copyright (c) 1993 Pearl Software, Oakland, CA
 *
 * Description: main module for Windows DLL
 *
*/

#include <windows.h>
#include <string.h>
#include <dos.h>
#include <stdio.h>
#include <stdarg.h>
#include <malloc.h>
#include <setjmp.h>
#include <io.h>
#include <fcntl.h>
#include <assert.h>
#include "config.h"
#include "callback.h"
#include "lisp.h"
#include "xterm.h"
#include "dispextern.h"
#include "screen.h"
#include "l_enum.h"

HINDIR win_hindir[cb_enum_end];
static HANDLE win_hcur;

jmp_buf win_exit_buf;
int win_retval;
unsigned int prop_data_seg;

#define CB_ENTRY far pascal

int CB_ENTRY emacs_entry(unsigned int ds, LPSTR cmdline, HMODULE hdll_lem,
			 HMODULE hdll_prop)
{
    char **argv;
    char far *mycmd;
    char *dup, *temp;
    int argc, argv_max, retval;
    FARPROC fp;
    struct SREGS sregs;
    static char tmp_buff[500];

    BreakPoint();

    /* initialize callbacks */
    fp = GetProcAddress(hdll_prop, "Win386LibEntry");
    /* include automatically generated GetIndirectFunctionHandle() calls */
#include "p_gifh.h"

    /* call proprietary entry point */
    segread(&sregs);
    prop_data_seg = X_ENTRY(sregs.ds, hdll_lem);
    if (!prop_data_seg)
	return -1;

    /* set up command line */
    mycmd = MK_FP(ds, cmdline);
    dup = (char *) malloc(1 + _fstrlen(mycmd));
    _fstrcpy(dup, mycmd);
    argv = (char **) malloc(10*sizeof(char *));
    argv_max = 10;
    GetModuleFileName(win_hcur, tmp_buff, 500);
    argv[0] = strdup(tmp_buff);
    dostounix_filename(argv[0]);
    argc = 1;
    while (temp = strtok(dup, " \t")) {
	argc++;
	if (argc > argv_max) {
	    argv_max += 10;
	    argv = (char **) realloc(argv, argv_max*sizeof(char *));
	}
	argv[argc-1] = temp;
	dup = NULL;
    }

    /* enter Emacs: will return through a longjmp() */
    if (!setjmp(win_exit_buf))
	retval = main(argc, argv, GetDOSEnvironment());
    else
	retval = win_retval;
    
    return retval;
}

void * CB_ENTRY emacs_malloc(size_t size)
{
    return malloc(size);
}

void * CB_ENTRY emacs_calloc(int num, size_t size)
{
    return calloc(num, size);
}

void CB_ENTRY emacs_free(void *ptr)
{
    free(ptr);
}

typedef int (*fn_0)(void);
typedef int (*fn_1)(int);
typedef int (*fn_2)(int, int);
typedef int (*fn_3)(int, int, int);
typedef int (*fn_4)(int, int, int, int);
typedef int (*fn_5)(int, int, int, int, int);
typedef int (*fn_6)(int, int, int, int, int, int);
typedef int (*fn_7)(int, int, int, int, int, int, int);
typedef int (*fn_8)(int, int, int, int, int, int, int, int);
typedef int (*fn_9)(int, int, int, int, int, int, int, int, int);
typedef int (*fn_10)(int, int, int, int, int, int, int, int, int, int);

int CB_ENTRY emacs_call(void *fn, int nargs, int *ODargs)
{
    int far *args = EXTEND(ODargs);

    if (!fn)
	return 0;

    switch (nargs) {
	case 0:
	    return (*(fn_0)(fn))();
	case 1:
	    return (*(fn_1)(fn))(args[0]);
	case 2:
	    return (*(fn_2)(fn))(args[0], args[1]);
	case 3:
	    return (*(fn_3)(fn))(args[0], args[1], args[2]);
	case 4:
	    return (*(fn_4)(fn))(args[0], args[1], args[2], args[3]);
	case 5:
	    return (*(fn_5)(fn))(args[0], args[1], args[2], args[3], args[4]);
	case 6:
	    return (*(fn_6)(fn))(args[0], args[1], args[2], args[3], args[4],
		args[5]);
	case 7:
	    return (*(fn_7)(fn))(args[0], args[1], args[2], args[3], args[4],
		args[5], args[6]);
	case 8:
	    return (*(fn_8)(fn))(args[0], args[1], args[2], args[3], args[4],
		args[5], args[6], args[7]);
	case 9:
	    return (*(fn_9)(fn))(args[0], args[1], args[2], args[3], args[4],
		args[5], args[6], args[7], args[8]);
	case 10:
	    return (*(fn_10)(fn))(args[0], args[1], args[2], args[3], args[4],
		args[5], args[6], args[7], args[8], args[9]);
	default:
	    return -1;
    }
}

/* DLL entry function */
int PASCAL WinMain(HANDLE hcur, HANDLE hprev, LPSTR cmdline, int cmdshow)
{
    win_hcur = hcur;

#include "l_define.h"

    return 1;
}

void my_exit(int code)
{
    win_retval = code;
    X_EXIT();
    dos_cleanup();
    longjmp(win_exit_buf, 1);
}

sync()
{
}

reset_sys_modes()
{
}

init_sys_modes()
{
}

sigfree()
{
}

/* BPW DEAL */
sys_suspend()
{
}

wait_for_termination(int pid) {}

void lw_set_keyboard_focus(Widget parent, Widget w)
{
}

int dos_unexec(void)
{
    FILE *file = NULL;
    int temp_errno;
    extern char data_start, data_end, bss_start, bss_end;
    extern char *orig_sbrk;
    char *cur_sbrk = sbrk(0);

    file = fopen("emacs.dat", "wb");
    if (!file)
	goto wu_err;
    if (fwrite(&data_start, 1, &data_end - &data_start, file) != &data_end -
	    &data_start ||
	fwrite(&bss_start, 1, &bss_end - &bss_start, file) != &bss_end -
	    &bss_start ||
	fwrite(&orig_sbrk, 1, sizeof(char *), file) != sizeof(char *) ||
	fwrite(&cur_sbrk, 1, sizeof(char *), file) != sizeof(char *) ||
	fwrite(orig_sbrk, 1, cur_sbrk - orig_sbrk, file) != cur_sbrk -
	    orig_sbrk)
	goto wu_err;
    temp_errno = 0;
    goto wu_noerr;
wu_err:
    temp_errno = errno;
wu_noerr:
    if (file)
	fclose(file);
    return temp_errno;
}

void dos_cleanup(void)
{
    extern char *orig_sbrk;
    extern int cleanup_done;
    char *new_sbrk = sbrk(0);
    sbrk(orig_sbrk - new_sbrk);
    cleanup_done = 1;
}

void dos_read_data(void)
{
    int handle;
    extern char data_start, data_end, bss_start, bss_end;
    extern char *orig_sbrk;
    char *old_orig_sbrk, *new_sbrk;
    char filename[PATH_MAX];
    extern char *_LpPgmName;
    char *ptr;

    strcpy(filename, _LpPgmName);
    if (ptr = strrchr(filename, '\\'))
	ptr++;
    else
	ptr = filename;
    strcpy(ptr, "emacs.dat");
    if ((handle = open(filename, O_RDONLY | O_BINARY)) != -1) {
	read(handle, &data_start, &data_end - &data_start);
	read(handle, &bss_start, &bss_end - &bss_start);
	read(handle, &old_orig_sbrk, sizeof(char *));
	if (orig_sbrk != old_orig_sbrk)
	    BreakPoint();
	read(handle, &new_sbrk, sizeof(char *));
	sbrk(new_sbrk - orig_sbrk);
	read(handle, orig_sbrk, new_sbrk - orig_sbrk);
	close(handle);
    }
}
