/* A general interface to the widgets of different toolkits.
   Copyright (C) 1992 Lucid, Inc.

This file is part of the Lucid Widget Library.

The Lucid Widget Library is free software; you can redistribute it and/or 
modify it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 1, or (at your option)
any later version.

The Lucid Widget Library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of 
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Emacs; see the file COPYING.  If not, write to
the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */

/* BPW 3-12-93 just the routines we need */

#include "lwlib/lwlib.h"

static widget_value *widget_value_free_list = 0;

widget_value *
malloc_widget_value ()
{
  widget_value *wv;
  if (widget_value_free_list)
    {
      wv = widget_value_free_list;
      widget_value_free_list = wv->free_list;
      wv->free_list = 0;
    }
  else
    {
      wv = (widget_value *) malloc (sizeof (widget_value));
    }
  memset (wv, 0, sizeof (widget_value));
  return wv;
}

/* this is analagous to free().  It frees only what was allocated
   by malloc_widget_value(), and no substructures. 
 */
void
free_widget_value (wv)
     widget_value *wv;
{
  if (wv->free_list)
    abort ();
  wv->free_list = widget_value_free_list;
  widget_value_free_list = wv;
}


