/* Demacs 1.1.2 91/10/20 Manabu Higashida	*/
/* Demacs 1.1.7 91/11/28 Manabu Higashida : PC-9801 support.		*/
/* Demacs 1.1.8 91/11/29 Manabu Higashida : FEP Ctontrol support.	*/
/* Demacs 1.1.9 91/11/30 Manabu Higashida 	*/

/* MS-DOS specific Lisp utilities.  Coded by Manabu Higashida, 1991.

   This file is part of Demacs (MS-DOS version of GNU Emacs and Nemacs).

   Demacs is distributed in the forms of patches to GNU
   Emacs under the terms of the GNU EMACS GENERAL PUBLIC
   LICENSE which is distributed along with GNU Emacs by the
   Free Software Foundation.

   Demacs is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied
   warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
   PURPOSE.  See the GNU EMACS GENERAL PUBLIC LICENSE for
   more details.

   You should have received a copy of the GNU EMACS GENERAL
   PUBLIC LICENSE along with Demacs; see the file COPYING.
   If not, write to the Free Software Foundation, 675 Mass
   Ave, Cambridge, MA 02139, USA. */

#include "config.h"

#ifdef MSDOS
/* The entire file is within this conditional */

#include <stdio.h>
#include <dos.h>

#ifdef NULL
#undef NULL
#endif
#include "lisp.h"
#include "buffer.h"
#include "termchar.h"
#include "dosfns.h"

Lisp_Object Vdos_machine_type;

#ifdef IBMPC
Lisp_Object Qibmpc;
#endif
#ifdef J3100
Lisp_Object Qj3100;
#endif
#ifdef PC9801
Lisp_Object Qpc98;
#endif

int InhibitSetDisk;
#ifdef FEPCTRL /* Demacs 1.1.8 91/11/29 Manabu Higashida */
int InhibitFEPCtrl;
static int FEPstat = 0;
#endif

DEFUN ("int86", Fint86, Sint86, 2, 2, 0, "")
  (intno, regs)
  Lisp_Object intno, regs;
{
  register int i;
  int size;
  union REGS inregs, outregs;
  Lisp_Object val;

  CHECK_NUMBER (intno, 0);
  CHECK_VECTOR (regs, 0);
  if (XVECTOR (regs)-> size != 8) return Qnil;
  for (i = 0; i < 8; i++)
    {
      CHECK_NUMBER (XVECTOR (regs)->contents[i], 0);
    }

  inregs.x.ax    = (unsigned long) XFASTINT (XVECTOR (regs)->contents[0]);
  inregs.x.bx    = (unsigned long) XFASTINT (XVECTOR (regs)->contents[1]);
  inregs.x.cx    = (unsigned long) XFASTINT (XVECTOR (regs)->contents[2]);
  inregs.x.dx    = (unsigned long) XFASTINT (XVECTOR (regs)->contents[3]);
  inregs.x.si    = (unsigned long) XFASTINT (XVECTOR (regs)->contents[4]);
  inregs.x.di    = (unsigned long) XFASTINT (XVECTOR (regs)->contents[5]);
  inregs.x.cflag = (unsigned long) XFASTINT (XVECTOR (regs)->contents[6]);
#if 0 /* BPW 12-14-92 Uggh.  Watcom C doesn't have "flags" in its reg struct. */
  inregs.x.flags = (unsigned long) XFASTINT (XVECTOR (regs)->contents[7]);
#endif

  int86 ((unsigned long) XFASTINT (intno), &inregs, &outregs);

  XVECTOR (regs)->contents[0] = make_number (outregs.x.ax);
  XVECTOR (regs)->contents[1] = make_number (outregs.x.bx);
  XVECTOR (regs)->contents[2] = make_number (outregs.x.cx);
  XVECTOR (regs)->contents[3] = make_number (outregs.x.dx);
  XVECTOR (regs)->contents[4] = make_number (outregs.x.si);
  XVECTOR (regs)->contents[5] = make_number (outregs.x.di);
  XVECTOR (regs)->contents[6] = make_number (outregs.x.cflag);
#if 0
  XVECTOR (regs)->contents[7] = make_number (outregs.x.flags);
#endif

  return regs;
}

#ifdef FEPCTRL	/* Demacs 1.1.8 91/11/29 Manabu Higashida */
DEFUN ("fep-init", Ffep_init, Sfep_init, 0, 0, 0, "")
  ()
{
  extern int fep_init (void);
  if (!InhibitFEPCtrl)
    {
      FEPstat = 1;
      return make_number (fep_init ());
    }
  else
    return Qnil;
}

DEFUN ("fep-term", Ffep_term, Sfep_term, 0, 0, 0, "")
  ()
{
  extern void fep_term (void);
  if (!InhibitFEPCtrl)
    {
      FEPstat = 0;
      fep_term ();
    }
  return Qnil;
}

DEFUN ("fep-on", Ffep_on, Sfep_on, 0, 0, 0, "")
  ()
{
  extern void fep_on (void);
  if (!InhibitFEPCtrl && !NULL (bf_cur->fep_mode) && !FEPstat)
    {
      FEPstat = 1;
      fep_on ();
    }
  return Qnil;
}

DEFUN ("fep-off", Ffep_off, Sfep_off, 0, 0, 0, "")
  ()
{
  extern void fep_off (void);
  if (!InhibitFEPCtrl && !NULL (bf_cur->fep_mode) && FEPstat)
    {
      FEPstat = 0;
      fep_off ();
    }
  return Qnil;
}

DEFUN ("fep-force-on", Ffep_force_on, Sfep_force_on, 0, 0, "", "")
  ()
{
  extern void fep_force_on (void);
  if (!InhibitFEPCtrl)
    {
      fep_force_on ();
      bf_cur->fep_mode = Qt;
    }
  return Qnil;
}

DEFUN ("fep-force-off", Ffep_force_off, Sfep_force_off, 0, 0, "", "")
  ()
{
  extern void fep_force_off (void);
  if (!InhibitFEPCtrl)
    {
      fep_force_off ();
      bf_cur->fep_mode = Qnil;
    }
  return Qnil;
}
#endif /* FEPCTRL */

#ifdef PC9801
DEFUN ("pc98-assign-special-key", 
  Fpc98_assign_special_key, Spc98_assign_special_key, 0, 0, 0, "")
  ()
{
  extern int set98FunctionKey (void);
  if (EQ (Vdos_machine_type, Qpc98))
    set98FunctionKey ();
  return Qnil;
}

DEFUN ("pc98-cancel-special-key", 
  Fpc98_cancel_special_key, Spc98_cancel_special_key, 0, 0, 0, "")
  ()
{
  extern int restore98FunctionKey (void);
  if (EQ (Vdos_machine_type, Qpc98))
    restore98FunctionKey ();
  return Qnil;
}
#endif /* PC9801

/*
 *	Define everything
 */
syms_of_dosfns()
{
#ifdef IBMPC
  Qibmpc = intern ("ibmpc");
  staticpro (&Qibmpc);
#endif
#ifdef J3100
  Qj3100 = intern ("j3100");
  staticpro (&Qj3100);
#endif
#ifdef PC9801
  Qpc98 = intern ("pc98");
  staticpro (&Qpc98);
#endif

  defsubr (&Sint86);
#ifdef FEPCTRL	/* Demacs 1.1.8 91/11/29 Manabu Higashida */
  defsubr (&Sfep_init);
  defsubr (&Sfep_term);
  defsubr (&Sfep_on);
  defsubr (&Sfep_off);
  defsubr (&Sfep_force_on);
  defsubr (&Sfep_force_off);
#endif /* FEPCTRL */
#ifdef PC9801
  defsubr (&Spc98_assign_special_key);
  defsubr (&Spc98_cancel_special_key);
#endif

  DEFVAR_LISP ("dos-machine-type", &Vdos_machine_type, 
    "A symbol naming the dos-machine-type under which Emacs is running,\n"
"\(such as `ibmpc'), or nil means running on dos generic mode.");
  /* Initialize `dos-machine-type'. */
#ifdef CANNOT_DUMP
  if (noninteractive)
#endif
    Vdos_machine_type = Qnil;

  DEFVAR_BOOL ("dos-inhibit-setdisk", &InhibitSetDisk,
    "*Non-nil means that changing current drive is inhibited.");
  InhibitSetDisk = 0;

#ifdef FEPCTRL /* Demacs 1.1.8 91/11/29 Manabu Higashida */
  DEFVAR_BOOL ("inhibit-fep-control", &InhibitFEPCtrl,
    "*Non-nil means that Kana-Kanji FEP control is inhibited.");
  InhibitFEPCtrl = 1;
#endif
}
#endif /* MSDOS */
