@ECHO OFF
CLS

ECHO.
ECHO Press a Key to Restore Old Video ROM, or
ECHO <Ctrl><C> to Abort . . .
ECHO.
PAUSE

SET LGFN=C:\GOBACK.LOG
ECHO.
ECHO Output redirected to file: %LGFN%
ECHO.

ECHO Starting Video ROM Restoration > %LGFN%

Rem . . . then the command to flash the video . . . >> %LGFN%
Rem Example is for the NVIDIA flash utility: NVFLASH.EXE
Rem Edit to suit the flash utility for your video card

Rem A precaution: save another copy of old ROM
SET LSTROM=C:\LASTVROM.BIN
ECHO Save Existing ROM to %LSTROM% >> %LGFN%
NVFLASH.EXE -b%LSTROM% >> %LGFN%
DIR %LSTROM% >> %LGFN%

SET OLDROM=A:\OLDVROM.BIN
if exist %OLDROM% goto :FoundBIN
ECHO.
ECHO ROM image file %OLDROM% Not Found!
ECHO.
goto :Done
:FoundBIN

ECHO Now Flashing with %OLDROM% >> %LGFN%
NVFLASH.EXE -f%OLDROM% >> %LGFN%
ECHO Video ROM Restore Complete! >> %LGFN%

ECHO.
ECHO Video ROM Restore Complete!
ECHO.

TYPE %LGFN%
COPY %LGFN% PRN

:Done
