//Tree.js file. used only in Tree frame. Includes
//Java Script functions to show Tree, drag&drop to tree folders functions.
//Before modify something here see  JS_CSS_VERSION element in HTCOMNET\web.config file!!!

var lastid;
var oRow;
var MoveState=false;
var oMenu;
var DragDropTargetSelectedIndex=-1;
var lastOverPlus=-1;
var tree = new dFTree({name: 'tree'});

function RemoveNotExistedNodes(node, foldersarr)
{
  var a=0
  for (a;a<node._children.length;a++)
  {
      if(!node._children[a].isCaptionExistsinList(foldersarr))
       {
        tree.empty(node._children[a].id);        
       }
        
  }
}

function UpdateNodes(node, newfoldersarr)
{
	var a=0;
	var Childid;
	var Child;
	var hasChild;
	var FolderName;
	var last=lastid;
	for (a;a<newfoldersarr.length;a++)
	{
		if(a%2==0)
			FolderName=newfoldersarr[a]
		else
		{
			hasChild=newfoldersarr[a];		
			Childid=node.existChild(FolderName)
			Child=node._children[node._searchChild(Childid)];
			if(Childid==-1)
			{
				last++;
				tree.add(new dNode({id: last,caption: FolderName, haschild: hasChild}), node.id);
			}
			else
			{
				if(Child.haschild != hasChild)
				{
					Child.alter({haschild: hasChild});
					if(hasChild==false)
					{
						 tree.emptyChild(Childid);
					}
					Child._refresh();
				} 
			}
		}
	}
	return last;    
}

function DrawRoot(caption, index, gray)
{
	var s='';
	if(gray) 
		s='<div><nobr><img alt="' + FOLDER_NOT_EXISTS + '" title="' + FOLDER_NOT_EXISTS + '" class="plus" mytype="plus" border="0" width="18" height="18" src="images/spacer.gif"><img border="0" alt="' + FOLDER_NOT_EXISTS + '" src="images/GrayRootFolder.gif" width="20" height="20"><font title="' + FOLDER_NOT_EXISTS + '" class="l">' + caption + '</font></nobr></div>'
	else
		s='<div><nobr><a onclick="window.parent.topFrame.logoffclick = true;" alt="' + OPEN_FOLDER + '" target="_parent" href="Default.aspx?goto=' + index + '"><img alt="' + OPEN_FOLDER + '" title="' + OPEN_FOLDER + '" class="plus" border="0" width="18" height="18" src="images/nolines_plus.gif"><img border="0" alt="' + OPEN_FOLDER + '" src="images/RootFolder.gif" width="20" height="20"><font title="' + OPEN_FOLDER + '" class="l">' + caption + '</font></a></nobr></div>';
	document.write(s);
}

function Move(Ev)
{
	
	if(window.parent.List)
	{		
		if(window.parent.List.MoveState==true)	{			
			
			
			if(MoveState==false)
			{
				oRow=document.createElement('div');
				oRow.innerHTML = window.parent.List.oRow.innerHTML;			
				window.parent.List.oRow.style.visibility='hidden';				
				oRow.style.visibility='visible';
				oRow.style.position='absolute';
				MoveState=true
				window.parent.List.MouseSelection=false;				
				document.body.appendChild(oRow);
			}
			if(oRow)
			{
				var ScrollX=(ie)?document.body.scrollLeft:window.pageXOffset
				var ScrollY=(ie)?document.body.scrollTop:window.pageYOffset
				oRow.style.left=ScrollX + Ev.clientX+5;
				oRow.style.top=ScrollY + Ev.clientY+5;
			}
		}
	}
}

function RowEndDragDrop(index, Ev)
{
	if(MoveState==true)
	{
		if(window.parent.List)
		{
			if(DragDropTargetSelectedIndex!=-1)			{
									
				window.parent.List.ShowDragAndDropMenu(-1, Ev, true)
			}
			window.parent.List.DisableBothDrag();
		}
	}
}

function SelectRow(index)
{
	if(MoveState==true) 
	{	
		document.getElementById("l" + index).style.background= "#CDCDCD";
		DragDropTargetSelectedIndex=index;	
	}
}

function RowOut(index, Ev)
{
	if(MoveState==true) 
	{
		if (index!=-1)	
		{
			document.getElementById("l" + index).style.background='#F5F5F5';
		}
	}
}

function RowMouseUp(index, Ev)
{
	
	if(MoveState==true) 
	{
		RowEndDragDrop(index, Ev);
		return;
	}
	
}

function ClickRow(id)
{
	var Node=tree.getNodeById(id)
	Node._click();
	Node._select();
	if (!Node._io)
	{
		Node.open();	
	}
}

function UpdateFolder(id)
{
	var Node=tree._aNodes[tree._searchNode(id)];
	if(Node!=null)
	{
		window.parent.leftFrame.location.href="UpdateTree.aspx?nodeid=" + id + "&folderpath=" +  escapeplus(Node.folderpath);
	}
}

function ShowFolder(id)
{
	var Node=tree._aNodes[tree._searchNode(id)];
	if(Node!=null)
	{
		if(window.parent.List)
			window.parent.List.location.href="List.aspx?nodeid=" + id + "&opentreefolder=true&folderpath=" +  escapeplus(Node.folderpath);
	}
}

function OpenNodeWhileDrag(id)
{
	if(MoveState==true)
	{
		if(lastOverPlus==id)
		{
			UpdateFolder(id);
			tree.getNodeById(id).open();
		}

	}
}

function NodeOver(id)
{
	if(MoveState==true)
	{
		lastOverPlus=id;
		window.setTimeout('OpenNodeWhileDrag(' + id + ')', 800);
	}
}

function NodeOut(id)
{
	lastOverPlus=-1;
}

function dNode(arrayProps) {
	var i;
	this.id;
	this.caption;
	this.folderpath;
	this.haschild=false;
	this._opened = false;
	this._io = false;

	this._children = [];
	this._parent;
	this._myTree;

	for (i in arrayProps)
	{
		if (i.charAt(0) != '_')
		{
			eval('this.'+i+' = arrayProps[\''+i+'\'];');
		}
	}
}

dNode.prototype.changeState = function()
{
	if (this._io)
	{
		this.close();
	}
	else
	{
		this.open();		
		UpdateFolder(this.id)
	}
}

dNode.prototype.open = function () 
{
	if (!this._io)
	{
		this._opened = true;
		this._io = true;
		this._refresh();
	}
}


dNode.prototype.close = function() 
{
	if (this._io)
	{
		this._io = false;
		this._refresh();
	}
}

dNode.prototype.existChild = function(caption) 
{
	var a=0;
	for (a;a<this._children.length;a++)
	{
		if(this._children[a].caption==caption)
			return this._children[a].id;		
	}
	return -1;	
}

dNode.prototype.isCaptionExistsinList = function(ListArr) 
{
	var i;
	for(i=0; i<ListArr.length; i++)
	{
		if (ListArr[i]==this.caption)
		{
			return true;
		}
	}
	return false;
}

dNode.prototype.alter = function(arrayProps)
{
	var i;
	for (i in arrayProps)
	{
		if (i != 'id' && i.charAt(0) != '_')
		{
			eval('this.'+i+' = arrayProps[\''+i+'\'];');
			if((i=='haschild') && arrayProps[i]==false)
			{
				eval('this._io = false;');
				eval('this._opened = false;');
			}
		}
	}
}

dNode.prototype._refresh = function() {
	var nodeDiv = document.getElementById("n"+this.id);
	var childrenDiv  = document.getElementById("ch"+this.id);
	var fnp = document.getElementById("fnp"+this.id);
	var fnc = document.getElementById("fnc"+this.id);
	var fnf = document.getElementById("fnf"+this.id);
	if (nodeDiv != null)
	{
		if (!this._io)
		{
			childrenDiv.className = "closed";
		}
		else 
		{
			if(this.haschild)
				childrenDiv.className = "opened";
		}		
		fnp.outerHTML = this._properPlus();			
		fnc.outerHTML = this._properCaption();		
		fnf.outerHTML = this._properFolder();
		nodeDiv.innerHTML = nodeDiv.innerHTML //IE refreshes DIV text only after this
	}

}

dNode.prototype._properCaption = function()
{
	if(this._myTree._selected==this)
		return '<font mytype="row" class="sl" id="fnc'+this.id+'">' + this.caption + '</font>'
	else
		return '<font mytype="row" class="l" id="fnc'+this.id+'">' + this.caption + '</font>';
}

dNode.prototype._properPlus = function()
{
	if (!this._io) 
	{
		if(this.haschild)
			return '<font mytype="plus" id="fnp'+this.id+'"><img alt="' + OPEN_NODE + '" title="' + OPEN_NODE + '" onMouseOut="javascript: NodeOut(' + this.id + ')" onMouseOver="javascript: NodeOver(' + this.id + ')" onclick="javascript: tree.getNodeById(\''+this.id+'\').changeState();" class="plus" mytype="plus" width="18" height="18" src="images/nolines_plus.gif"></font>'
		else
			return '<font mytype="plus" id="fnp'+this.id+'"><img src="images/spacer.gif" class="plus" width="18" height="18"></font>';
	}
	else 
	{
		if(this.haschild)
			return '<font mytype="plus" id="fnp'+this.id+'"><img alt="' + CLOSE_NODE + '" title="' + CLOSE_NODE + '" onMouseOut="javascript: NodeOut(' + this.id + ')" onMouseOver="javascript: NodeOver(' + this.id + ')" onclick="javascript: tree.getNodeById(\''+this.id+'\').changeState();" class="plus" mytype="plus" width="18" height="18" src="images/nolines_minus.gif"></font>'
		else
			return '<font mytype="plus" id="fnp'+this.id+'"><img src="images/spacer.gif" class="plus" width="18" height="18"></font>';
	}
}

dNode.prototype._properFolder = function()
{
	if(this.id==0)
		return '<font mytype="row" id="fnf'+this.id+'"><img border="0" src="images/RootFolder.gif" width="20" height="20"></font>'
	else
		return '<font mytype="row" id="fnf'+this.id+'"><img border="0" src="images/foldertree.gif" width="18" height="18"></font>';
}

dNode.prototype._select = function()
{
	var captionSpan;
	if (this._myTree._selected)
	{
		this._myTree._selected._unselect();
	}
	this._myTree._selected = this;
	captionSpan  = document.getElementById("fnc"+this.id);
	if (captionSpan)
	{
		captionSpan.className = 'sl';
	}

}

dNode.prototype._click = function()
{
	ShowFolder(this.id);
	UpdateFolder(this.id);
}

dNode.prototype._unselect = function()
{
	var captionSpan  = document.getElementById("fnc"+this.id);
	this._myTree._lastSelected = this._myTree._selected;
	this._myTree._selected = null;
	if (captionSpan)
	{
		captionSpan.className = 'l';
	}
}

dNode.prototype._searchChild = function(id) 
{
	var a=0;
	for (a;a<this._children.length;a++)
	{
		if (this._children[a].id == id)
		{
			return a;
		}
	}
	return false;
}

dNode.prototype._draw = function()
{
	var Ev=GetEventStr();
	
	divN = document.createElement('div');
	divN.id = 'n'+this.id;
	if(this.id!=0)
		divN.className = 'son';

	spanP = document.createElement('span');
	spanP.id = 'p'+this.id;
	spanP.innerHTML='<span id="p'+this.id+'">'+this._properPlus()+'</span>';
	
	spanL = document.createElement('span');
	spanL.id = 'l'+this.id;
	spanL.innerHTML ='<span mytype="row" id="l'+this.id+'"  onMouseUp="RowMouseUp(' + this.id + ', ' + Ev + ');" onMouseOut="RowOut(' + this.id + ', ' + Ev + ');" onMouseOver="SelectRow(' + this.id + ');" onclick="javascript: ClickRow('+ this.id + ');" ><nobr>'+ this._properFolder() + this._properCaption() + '</nobr></span>';

	divCH = document.createElement('div');
	divCH.id = 'ch'+this.id;
	divCH.className = (this._io)? "opened" : "closed";	

	divN.appendChild(spanP);
	divN.appendChild(spanL);
	divN.appendChild(divCH);	

	if (this._parent != null)
		parentChildrenDiv = document.getElementById("ch"+this._parent.id)
	else
		parentChildrenDiv = document.getElementById("dftree_"+this._myTree.name);
	if (parentChildrenDiv)
		parentChildrenDiv.appendChild(divN);

}

function dFTree(arrayProps) {
	var i;
	this.name;
	this._root;
	this._aNodes = [];
	this._lastSelected;
	this._selected;
	for (i in arrayProps)
	{
		if (i.charAt(0) != '_')
		{
			eval('this.'+i+' = arrayProps[\''+i+'\'];');
		}
	}
}

dFTree.prototype.draw = function() {
	if (!document.getElementById("dftree_"+this.name))
	{
		document.write('<div id="dftree_'+this.name+'"></div>');
	}

	if (this._root != null)
	{
		this._root._draw();
		this._drawBranch(this._root._children);
	}
}

dFTree.prototype.empty = function(id) {

	var Node = this._aNodes[this._searchNode(id)]
	var a=0;
	for (a;a<Node._children.length;a++)
	{
		this.empty(Node._children[a].id)		
	}
	if(Node._parent!=null)
	{
		Node._parent._children.splice(Node._parent._searchChild(id),1);
	}	
	NodPos = this._searchNode(id)
	this._aNodes.splice(NodPos,1)	
	clearnode(id)
	Node=null
}

dFTree.prototype.emptyChild = function(id)
{
	var Node = this._aNodes[this._searchNode(id)]
	var a=0;
	for (a;a<Node._children.length;a++)
	{
		this.empty(Node._children[a].id)		
	}
}

function clearnode(id)
{
	
	var divN = document.getElementById('n'+id);
	divN.parentNode.removeChild(divN);
	divN=null;
}
	
dFTree.prototype._drawBranch = function(childrenArray) 
{
	var a=0;
	for (a;a<childrenArray.length;a++)
	{
		childrenArray[a]._draw();
		this._drawBranch(childrenArray[a]._children);
	}
}

dFTree.prototype.add = function(node,pid) {
	var auxPos;
	var addNode = false;
	if (typeof (auxPos = this._searchNode(node.id)) != "number")
	{
		if (typeof (auxPos = this._searchNode(pid)) == "number")
		{
			node._parent = this._aNodes[auxPos];
			this._aNodes[auxPos]._children[this._aNodes[auxPos]._children.length] = node;
			node._parent.haschild=true;
			if(node._parent.folderpath!='')
				node.folderpath=node._parent.folderpath + '\\' + node.caption
			else
				node.folderpath= node.caption;
			addNode = true;
		}
		else
		{
			if (this._root == null)
			{
				this._root = node;
				node.folderpath=''
				addNode = true;
			}
		}
		if (addNode)
		{
			this._aNodes[this._aNodes.length] = node;
			node._myTree = this;
			node._draw();
		}
	} 

}

dFTree.prototype.alter = function(arrayProps)
{
	if (arrayProps['id'])
	{
		this.getNodeById(arrayProps['id']).alter(arrayProps);
	}
}

dFTree.prototype.getNodeById = function(nodeid)
{
	return this._aNodes[this._searchNode(nodeid)];
}

dFTree.prototype._searchNode = function(id)
{
	var a=0;
	for (a;a<this._aNodes.length;a++)
	{
		if (this._aNodes[a].id == id)
		{
			return a;
		}
	}
	return false;
}