/*
 * Decompiled with CFR 0.152.
 */
public final class Gitter3D {
    private int m_LAnzahl;
    private int m_BAnzahl;
    private int m_HAnzahl;
    private Punkt3D[][][] m_P3D;
    private Bildpunkt[][][] m_PBild;
    private Zentralprojektion m_Zentral;
    private int m_Breite;
    private int m_Hoehe;
    private double m_KLaenge;

    public Gitter3D(int n, int n2, int n3, int n4, int n5) {
        this.m_LAnzahl = n2;
        this.m_BAnzahl = n;
        this.m_HAnzahl = n3;
        this.m_KLaenge = Parameter.ermLKante(this.m_LAnzahl, this.m_BAnzahl, this.m_HAnzahl);
        this.setParam(n4, n5);
        this.erz3DGitterPunkte();
        this.erzBildpunkte();
    }

    private void erz3DGitterPunkte() {
        double d = (double)this.m_BAnzahl / 2.0;
        double d2 = (double)this.m_LAnzahl / 2.0;
        double d3 = (double)this.m_HAnzahl / 2.0;
        this.m_P3D = new Punkt3D[this.m_BAnzahl + 1][][];
        int n = 0;
        while (n <= this.m_BAnzahl) {
            this.m_P3D[n] = new Punkt3D[this.m_LAnzahl + 1][];
            int n2 = 0;
            while (n2 <= this.m_LAnzahl) {
                this.m_P3D[n][n2] = new Punkt3D[this.m_HAnzahl + 1];
                int n3 = 0;
                while (n3 <= this.m_HAnzahl) {
                    this.m_P3D[n][n2][n3] = new Punkt3D(((double)n - d) * this.m_KLaenge, ((double)n3 - d3) * this.m_KLaenge, ((double)n2 - d2) * this.m_KLaenge);
                    ++n3;
                }
                ++n2;
            }
            ++n;
        }
    }

    public void erzBildpunkte() {
        int n = this.m_Breite < this.m_Hoehe ? this.m_Breite : this.m_Hoehe;
        this.m_Zentral = new Zentralprojektion((int)Math.round((double)n * 0.1), 1000.0);
        this.m_PBild = new Bildpunkt[this.m_BAnzahl + 1][][];
        int n2 = 0;
        while (n2 <= this.m_BAnzahl) {
            this.m_PBild[n2] = new Bildpunkt[this.m_LAnzahl + 1][];
            int n3 = 0;
            while (n3 <= this.m_LAnzahl) {
                this.m_PBild[n2][n3] = new Bildpunkt[this.m_HAnzahl + 1];
                int n4 = 0;
                while (n4 <= this.m_HAnzahl) {
                    this.m_PBild[n2][n3][n4] = this.m_Zentral.berechne(this.m_P3D[n2][n3][n4], (double)n, this.m_Breite, this.m_Hoehe);
                    ++n4;
                }
                ++n3;
            }
            ++n2;
        }
    }

    public void rotieren(double d, double d2, double d3) {
        int n = this.m_Breite < this.m_Hoehe ? this.m_Breite : this.m_Hoehe;
        int n2 = 0;
        while (n2 <= this.m_BAnzahl) {
            int n3 = 0;
            while (n3 <= this.m_LAnzahl) {
                int n4 = 0;
                while (n4 <= this.m_HAnzahl) {
                    if (d != 0.0) {
                        this.m_P3D[n2][n3][n4].xRot(d);
                    }
                    if (d2 != 0.0) {
                        this.m_P3D[n2][n3][n4].yRot(d2);
                    }
                    if (d3 != 0.0) {
                        this.m_P3D[n2][n3][n4].zRot(d3);
                    }
                    this.m_PBild[n2][n3][n4] = this.m_Zentral.berechne(this.m_P3D[n2][n3][n4], (double)n, this.m_Breite, this.m_Hoehe);
                    ++n4;
                }
                ++n3;
            }
            ++n2;
        }
    }

    public void rotieren(int n, int n2, int n3) {
        double d = (double)n * Math.PI / 180.0;
        double d2 = (double)n2 * Math.PI / 180.0;
        double d3 = (double)n3 * Math.PI / 180.0;
        this.rotieren(d, d2, d3);
    }

    public void setParam(int n, int n2) {
        this.m_Hoehe = n2;
        this.m_Breite = n;
    }

    public Bildpunkt ermPBild(GPunkt gPunkt) {
        int n = gPunkt.ermBIndex();
        int n2 = gPunkt.ermLIndex();
        int n3 = gPunkt.ermHIndex();
        Bildpunkt bildpunkt = null;
        try {
            bildpunkt = this.m_PBild[n][n2][n3];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            System.out.println(arrayIndexOutOfBoundsException);
            return null;
        }
        return bildpunkt;
    }

    public Punkt3D ermP3D(GPunkt gPunkt) {
        Punkt3D punkt3D;
        int n = gPunkt.ermBIndex();
        int n2 = gPunkt.ermLIndex();
        int n3 = gPunkt.ermHIndex();
        try {
            punkt3D = this.m_P3D[n][n2][n3];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            System.out.println(arrayIndexOutOfBoundsException);
            return null;
        }
        return punkt3D;
    }

    public void reset() {
        this.erz3DGitterPunkte();
        this.erzBildpunkte();
        this.rotieren(0, 0, 0);
        this.rotieren(0, -50, 0);
        this.rotieren(40, 0, 0);
    }
}

