/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.Vector;

class DreiDTetris_Canvas
extends Canvas {
    private Image m_Puffer;
    private Graphics m_GPuffer;
    private Gitter3D m_TGitter = null;
    private TetrisRaum m_TFeld;
    private int m_Ebenen = 10;
    private int m_Spalten = 3;
    private int m_Zeilen = 3;
    private TetrisSzene m_TSzene;
    private Color m_FHinter = Color.black;
    private Color m_FGrenz = Color.lightGray;
    private Color m_FBlock = Color.gray;
    private Dimension m_DimAlt = new Dimension(0, 0);
    private boolean m_IsFensterOk = false;
    private boolean m_IsPressed = false;
    private short m_PlayLevel;

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public DreiDTetris_Canvas() {
        this.setBackground(Color.black);
        SymComponent symComponent = new SymComponent();
        this.addComponentListener(symComponent);
    }

    public void beginnSzeneDreh() {
        this.m_TSzene.nurBgrLinien();
        this.repaint();
    }

    public void endeSzeneDreh() {
        this.m_TSzene.neu();
    }

    private void szeneDreh(double d, double d2, double d3) {
        this.m_TGitter.rotieren((int)d, (int)d2, (int)d3);
        this.repaint();
    }

    private void gesamtRot(int n, int n2, int n3) {
        this.m_TGitter.rotieren(n, n2, n3);
        this.m_TSzene.neu();
        this.repaint();
    }

    public void gesamtRot(double d, double d2, double d3) {
        this.m_TGitter.rotieren(d, d2, d3);
        this.m_TSzene.neu();
        this.repaint();
    }

    public void gesamtGroesse() {
        Dimension dimension = this.getSize();
        this.m_Puffer = this.createImage(dimension.width, dimension.height);
        this.m_GPuffer = this.m_Puffer.getGraphics();
        if (this.m_TGitter == null) {
            this.neuesSpiel();
            return;
        }
        if (this.m_DimAlt.equals(dimension)) {
            return;
        }
        this.m_DimAlt = dimension;
        this.m_TGitter.setParam(dimension.width, dimension.height);
        this.m_TGitter.erzBildpunkte();
    }

    public void koerperRot(int n) {
        if (!this.m_TFeld.dreheBlock(n)) {
            this.m_TSzene.setABlock(this.m_TFeld.ermABlock());
        } else {
            this.m_TSzene.blockSortieren();
            this.repaint();
        }
        this.m_TFeld.ermABlock().ermWuerfel();
    }

    public void verschieben(int n) {
        int n2 = 0;
        int n3 = 0;
        switch (n) {
            case -2: {
                n3 = -1;
                break;
            }
            case -1: {
                n2 = -1;
                break;
            }
            case 1: {
                n2 = 1;
                break;
            }
            case 2: {
                n3 = 1;
                break;
            }
        }
        if (!this.m_TFeld.verschiebeBlock(0, n3, n2)) {
            return;
        }
        this.m_TSzene.blockSortieren();
        this.repaint();
    }

    public int ebene(boolean bl) {
        int n = 0;
        if (!bl) {
            if (!this.m_TFeld.verschiebeBlock(-1, 0, 0)) {
                Vector vector = this.m_TFeld.pruefEbenen();
                this.m_TSzene.setFlaechen(this.m_TFeld.ermFlaechen());
                this.m_TSzene.setABlock(null);
                n = vector.size();
                if (n != 0) {
                    this.repaint();
                } else {
                    n = -1;
                }
            } else {
                this.m_TSzene.blockSortieren();
                this.repaint();
            }
        } else {
            while (this.m_TFeld.verschiebeBlock(-1, 0, 0)) {
            }
            Vector vector = this.m_TFeld.pruefEbenen();
            this.m_TSzene.setFlaechen(this.m_TFeld.ermFlaechen());
            this.m_TSzene.setABlock(null);
            n = vector.size();
            if (n == 0) {
                n = -1;
            }
        }
        return n;
    }

    public boolean naechster(int n) {
        if (!this.m_TFeld.setBlock(n)) {
            return false;
        }
        this.m_TSzene.setABlock(this.m_TFeld.ermABlock());
        this.repaint();
        return true;
    }

    public void Optionen(int n, int n2, int n3, Color color, Color color2, Color color3) {
        this.m_Spalten = n2;
        this.m_Zeilen = n3;
        this.m_Ebenen = n;
        this.m_FHinter = color;
        this.m_FGrenz = color2;
        this.m_FBlock = color3;
        this.neuesSpiel();
    }

    public void GameOver() {
        this.m_PlayLevel = (short)2;
        this.repaint();
    }

    public boolean isFensterOk() {
        return this.m_IsFensterOk;
    }

    public void paint(Graphics graphics) {
        int n = this.getBackground().getRGB();
        if (this.m_GPuffer != null) {
            this.m_GPuffer.fillRect(0, 0, this.getSize().width, this.getSize().height);
            Color color = graphics.getColor();
            if (!this.m_IsFensterOk) {
                this.m_GPuffer.setColor(new Color(~n));
                this.m_GPuffer.drawString((String)DreiD_Tetris.locale.get("window"), 10, this.getSize().height / 2);
                this.m_GPuffer.setColor(color);
                graphics.drawImage(this.m_Puffer, 0, 0, this);
                return;
            }
            this.m_TSzene.darstellen(this.m_GPuffer);
            this.m_GPuffer.setColor(new Color(~n));
            this.m_GPuffer.setFont(new Font("Dialog", 1, 40));
            if (this.m_PlayLevel == 2) {
                this.m_GPuffer.drawString((String)DreiD_Tetris.locale.get("end"), 10, this.getSize().height / 2);
            }
            this.m_GPuffer.setColor(color);
            graphics.drawImage(this.m_Puffer, 0, 0, this);
        }
    }

    public void neuesSpiel() {
        this.m_PlayLevel = 1;
        this.m_DimAlt = this.getSize();
        this.setBackground(this.m_FHinter);
        this.m_TGitter = new Gitter3D(this.m_Spalten, this.m_Zeilen, this.m_Ebenen, this.m_DimAlt.width, this.m_DimAlt.height);
        this.m_TGitter.rotieren(0, 0, 0);
        this.m_TGitter.rotieren(0, -50, 0);
        this.m_TGitter.rotieren(40, 0, 0);
        this.m_TSzene = new TetrisSzene(this.m_TGitter, this.m_FGrenz, this.m_FBlock);
        this.m_TFeld = new TetrisRaum(this.m_Spalten, this.m_Zeilen, this.m_Ebenen);
        this.m_TSzene.setBgrL(this.m_TFeld.ermGrenzLinien());
    }

    public void reset() {
        this.m_TGitter.reset();
        this.m_TSzene.neu();
        this.repaint();
    }

    static /* synthetic */ boolean access$0(DreiDTetris_Canvas dreiDTetris_Canvas) {
        return dreiDTetris_Canvas.m_IsFensterOk;
    }

    class SymComponent
    extends ComponentAdapter {
        public void componentResized(ComponentEvent componentEvent) {
            Object object = componentEvent.getSource();
            if (object == DreiDTetris_Canvas.this) {
                if (DreiDTetris_Canvas.this.getSize().width > 300 && DreiDTetris_Canvas.this.getSize().height > 300) {
                    DreiDTetris_Canvas.this.m_IsFensterOk = true;
                } else {
                    DreiDTetris_Canvas.this.m_IsFensterOk = false;
                }
                DreiDTetris_Canvas.this.gesamtGroesse();
            }
        }

        SymComponent() {
            DreiDTetris_Canvas.this = DreiDTetris_Canvas.this;
        }
    }
}

