/*
 * Copyright PMEase (c) 2005-2006,
 * Date: 2006-1-11
 * Time: 18:30:08
 * All rights reserved.
 */

import com.caucho.hessian.client.HessianProxyFactory;
import com.pmease.quickbuild.RemoteService;
import com.pmease.quickbuild.BuildRelatedUrls;
import com.pmease.quickbuild.model.BuildFacade;
import com.pmease.quickbuild.model.ConfigurationFacade;

import java.net.URL;
import java.net.URLConnection;
import java.io.InputStream;
import java.io.FileOutputStream;
import java.io.IOException;

import sun.misc.BASE64Encoder;

/**
 * This sample demonstrates how to get last successful build of a particular configuration. By using this program,
 * you can feed real build information (such as build versions) into other systems such as an issue tracking
 * application.
 */
public class GetLastSuccessBuild {
    public static void main(String[] args) throws IOException {
        HessianProxyFactory factory = new HessianProxyFactory();
        String loginUser = "admin";
        String loginPassword = "admin";

        // specify login information here.
        factory.setUser(loginUser);
        factory.setPassword(loginPassword);

        // specify hessian service URL of your QuickBuild installation.
        RemoteService remote = (RemoteService) factory.create(RemoteService.class,
                "http://localhost:8080/app.do?service=hessian");

        ConfigurationFacade configuration = remote.getConfigurationByHierarchyName("root.live-samples.test");
        if (configuration == null)
            throw new RuntimeException("Can not find specified configuration!");
        BuildFacade build = remote.getLastSuccessBuild(configuration.getId());
        if (build == null)
            System.out.println("There is no successful build in specified configuration!");
        else {
            System.out.println("Last successful build of specified configuation is \"" + build.getVersion() + "\".");

            // continue to get various url information of this build, so that you can link to these urls
            // from other application.
            BuildRelatedUrls urls = remote.getBuildRelatedUrls(build.getId());

            // Now we try to read the build log and save to file "build_log.txt".
            FileOutputStream output = new FileOutputStream("build_log.txt");
            URL url = new URL(urls.getBuildLogUrl());
            URLConnection urlConnection = url.openConnection();
            BASE64Encoder base64Encoder = new BASE64Encoder();
            urlConnection.setRequestProperty("Authorization", "Basic " +
                    base64Encoder.encode((loginUser + ":" + loginPassword).getBytes()));
            InputStream input = (InputStream) urlConnection.getInputStream();
            byte[] data = new byte[4096];
            int bytesRead;
            while ((bytesRead = input.read(data)) > -1) output.write(data, 0, bytesRead);
            input.close();
            output.close();
            System.out.println("Build log has been read into \"build_log.txt\" successfully!");
        }
    }
}
