//
// Base OOP/AOP
//

var OO = new Object();
OO.extend = function(self, parent) {
	self.parent = parent;
	for (p in parent) {
		if (!self[p]) {
			self[p] = parent[p];
		}
	}
};

Function.prototype.after = function(fname, afterFunc) {
	var oldFunc = this.prototype[fname];
	if (!oldFunc) throw "No such function: " + fname;
	this.prototype[fname] = function() {
		oldFunc.apply(this, arguments);
		return afterFunc.apply(this, arguments);
	};
}

Function.prototype.bind = function(object) {
	var method = this;
	return function() {
		method.apply(object, arguments);
	}
};

//
// XML HTTP Requests
//

var HttpRequest = function(url, method, body, headers) {
	this.url = url;
	this.method = method || "GET";
	this.body = body;
	this.headers = headers;
	this.transport = this.createTransport();
};

HttpRequest.prototype.started = function() {};
HttpRequest.prototype.completed = function() {};
HttpRequest.prototype.failed = function() {};

HttpRequest.prototype.send = function() {
	if (!this.transport) return true;

	var req = this;
	this.transport.onreadystatechange = function() {
		if (req.transport.readyState == 4) {
			if (req.transport.status == 200) {
				req.completed();
			} else {
				req.failed();
			}
		}
	}

	this.started();
	
	this.transport.open(this.method, this.url, true);
	if (this.headers) {
		for (name in this.headers) {
			this.transport.setRequestHeader(name, this.headers[name]);
		}
	}
	this.transport.send(this.body);
	return false;
}

HttpRequest.prototype.createTransport = function() {
	var xmlhttp = false;
	/*@cc_on @*/
	/*@if (@_jscript_version >= 5)
		try {
			xmlhttp = new ActiveXObject("Msxml2.XMLHTTP");
		} catch (e) {
			try {
				xmlhttp = new ActiveXObject("Microsoft.XMLHTTP");
			} catch (E) {
				xmlhttp = false;
			}
		}
	@end @*/
	if (!xmlhttp && typeof XMLHttpRequest!='undefined') {
		xmlhttp = new XMLHttpRequest();
	}
	return xmlhttp;
};

//
// Partial Page Rendering Requests
//

var PartRequest = function(url, parts) {
	// add part ids as service context parameters
	var partIds = "/" + parts.join("/");
	var reqUrl = url.replace(new RegExp("&sp=(.*)"), partIds + "&sp=$1");
	if (url==reqUrl) reqUrl = reqUrl + partIds;
	// cache-buster
	reqUrl = reqUrl + "&amp;rand=" + Math.random();
	OO.extend(this, new HttpRequest(reqUrl));
	this.parts = parts;
};

PartRequest.prototype.started = function() {};
PartRequest.prototype.failed = function() {};
PartRequest.prototype.completed = function() {
	// FIXME add more error checking
	var root = this.transport.responseXML.documentElement;
	var partNodes = root.childNodes;
	for (var i=0; i<partNodes.length; i++) {
		var part = partNodes.item(i);
		if (part.attributes) {
			var partId = part.attributes[0].value;
			var partElement = document.getElementById(partId);
			if (partElement) {
				if (part.childNodes != null && part.childNodes.length > 0){
					var content = "";
					for (var ii =0; ii<part.childNodes.length; ii++) {
						content += part.childNodes[ii].nodeValue;
					}
					if (partElement.innerHTML != content)
						partElement.innerHTML = content;
				} else {
					partElement.parentNode.removeChild(partElement);
				}
			}
		}
	}
};

var PartPost = function(form, parts) {
	var url = form.action;
	var headers = [];
	headers["Content-Type"] = "application/x-www-form-urlencoded; charset=UTF-8";
	var values = FormUtil.getValues(form);

	// FIXME: once Form.getLink is exposed in Tapestry 3.0.4, replace the following
	// with: values["service"] += "/" + parts.join("/");
	var s = values["service"][0].split("/");
	s[0] = "partial";
	if (s.length==4) s.splice(3,0,s[2]);
	s = s.concat(parts);
	values["service"][0] = s.join("/");
	
	var body = FormUtil.encodeValues(values);

	OO.extend(this, new HttpRequest(url, "POST", body, headers));
	this.parts = parts;
};

PartPost.prototype.started = PartRequest.prototype.started;
PartPost.prototype.failed = PartRequest.prototype.failed;
PartPost.prototype.completed = PartRequest.prototype.completed;

//
// Form support
//

var FormUtil = new Object();

FormUtil.getElements = function(form) {
	var tags = ["input","textarea","select"];
	var elements = [];
	for (ti in tags) {
		var e = form.getElementsByTagName(tags[ti]);
		for (var ei=0; ei<e.length; ei++) {
			elements.push(e[ei]);
		}
	}
	return elements;
};

FormUtil.getValues = function(form) {
	var elements = FormUtil.getElements(form);
	var values = [];
	for (ei in elements) {
		var e = elements[ei];
		var value = FormUtil.getElementValue(e);
		if (value) {
           if (values[e.name] == null) values[e.name] = [];
           values[e.name].push(value);
		}
	}
	return values;
};

FormUtil.getElementValue = function(element) {
	switch (element.tagName.toLowerCase()) {
		case "textarea":
			return element.value;			
		case "input":
			switch (element.type.toLowerCase()) {
				case 'hidden':
				case 'password':
				case 'text':
					return element.value;
				case 'checkbox':  
				case 'radio':
					return element.checked ? element.value : null;
			}
			break;
		case "select":
			var i = element.selectedIndex;
			return (i==-1) ? "" : element.options[i].value;		
	}
	return null;
};

FormUtil.encodeValues = function(values) {
	var body = "";
	var separator = "";
	for (name in values) {
		for (value in values[name]) {
			body += separator + encodeURIComponent(name)
					+ "=" + encodeURIComponent(values[name][value]);
			separator = "&";
		}
	}
	return body;
};
