/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.valid;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.apache.tapestry.ApplicationRuntimeException;
import org.apache.tapestry.IEngine;
import org.apache.tapestry.IForm;
import org.apache.tapestry.IMarkupWriter;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.IScript;
import org.apache.tapestry.Tapestry;
import org.apache.tapestry.engine.IScriptSource;
import org.apache.tapestry.form.FormEventType;
import org.apache.tapestry.form.IFormComponent;
import org.apache.tapestry.html.Body;
import org.apache.tapestry.resource.ClasspathResourceLocation;
import org.apache.tapestry.valid.IValidator;
import org.apache.tapestry.valid.ValidationConstraint;
import org.apache.tapestry.valid.ValidatorException;

public abstract class BaseValidator
implements IValidator {
    public static final String FIELD_SYMBOL = "field";
    public static final String VALIDATOR_SYMBOL = "validator";
    public static final String FORM_SYMBOL = "form";
    public static final String FUNCTION_SYMBOL = "function";
    private boolean _required;
    private String _requiredMessage;
    private boolean _clientScriptingEnabled = false;

    public BaseValidator() {
    }

    protected BaseValidator(boolean required) {
        this._required = required;
    }

    public boolean isRequired() {
        return this._required;
    }

    public void setRequired(boolean required) {
        this._required = required;
    }

    protected String getPattern(String override, String key, Locale locale) {
        if (override != null) {
            return override;
        }
        ResourceBundle strings = ResourceBundle.getBundle("org.apache.tapestry.valid.ValidationStrings", locale);
        return strings.getString(key);
    }

    protected String formatString(String pattern, Object[] args) {
        return MessageFormat.format(pattern, args);
    }

    protected String formatString(String pattern, Object arg) {
        return this.formatString(pattern, new Object[]{arg});
    }

    protected String formatString(String pattern, Object arg1, Object arg2) {
        return this.formatString(pattern, new Object[]{arg1, arg2});
    }

    protected boolean checkRequired(IFormComponent field, String value) throws ValidatorException {
        boolean isEmpty = Tapestry.isBlank(value);
        if (this._required && isEmpty) {
            throw new ValidatorException(this.buildRequiredMessage(field), ValidationConstraint.REQUIRED);
        }
        return isEmpty;
    }

    protected String buildRequiredMessage(IFormComponent field) {
        String pattern = this.getPattern(this._requiredMessage, "field-is-required", field.getPage().getLocale());
        return this.formatString(pattern, field.getDisplayName());
    }

    public void renderValidatorContribution(IFormComponent field, IMarkupWriter writer, IRequestCycle cycle) {
    }

    protected void processValidatorScript(String scriptPath, IRequestCycle cycle, IFormComponent field, Map symbols) {
        IEngine engine = field.getPage().getEngine();
        IScriptSource source = engine.getScriptSource();
        IForm form = field.getForm();
        Map finalSymbols = symbols == null ? new HashMap() : symbols;
        finalSymbols.put(FIELD_SYMBOL, field);
        finalSymbols.put(FORM_SYMBOL, form);
        finalSymbols.put(VALIDATOR_SYMBOL, this);
        ClasspathResourceLocation location = new ClasspathResourceLocation(engine.getResourceResolver(), scriptPath);
        IScript script = source.getScript(location);
        Body body = Body.get(cycle);
        if (body == null) {
            throw new ApplicationRuntimeException(Tapestry.getMessage("ValidField.must-be-contained-by-body"), field, null, null);
        }
        script.execute(cycle, body, finalSymbols);
        String functionName = (String)finalSymbols.get(FUNCTION_SYMBOL);
        form.addEventHandler(FormEventType.SUBMIT, functionName);
    }

    public boolean isClientScriptingEnabled() {
        return this._clientScriptingEnabled;
    }

    public void setClientScriptingEnabled(boolean clientScriptingEnabled) {
        this._clientScriptingEnabled = clientScriptingEnabled;
    }

    public String getRequiredMessage() {
        return this._requiredMessage;
    }

    public void setRequiredMessage(String string) {
        this._requiredMessage = string;
    }

    public abstract /* synthetic */ Object toObject(IFormComponent var1, String var2) throws ValidatorException;

    public abstract /* synthetic */ String toString(IFormComponent var1, Object var2);
}

