/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.spec;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.tapestry.IResourceLocation;
import org.apache.tapestry.Tapestry;
import org.apache.tapestry.spec.IAssetSpecification;
import org.apache.tapestry.spec.IBeanSpecification;
import org.apache.tapestry.spec.IComponentSpecification;
import org.apache.tapestry.spec.IContainedComponent;
import org.apache.tapestry.spec.IParameterSpecification;
import org.apache.tapestry.spec.IPropertySpecification;
import org.apache.tapestry.spec.LocatablePropertyHolder;

public class ComponentSpecification
extends LocatablePropertyHolder
implements IComponentSpecification {
    private String _componentClassName;
    private String _description;
    protected Map _components;
    protected Map _assets;
    protected Map _parameters;
    protected Map _beans;
    protected Set _reservedParameterNames;
    private boolean _allowBody = true;
    private boolean _allowInformalParameters = true;
    private String _publicId;
    private boolean _pageSpecification;
    private IResourceLocation _specificationLocation;
    private Map _propertySpecifications;

    public void addAsset(String name, IAssetSpecification asset) {
        if (this._assets == null) {
            this._assets = new HashMap();
        }
        if (this._assets.containsKey(name)) {
            throw new IllegalArgumentException(Tapestry.format("ComponentSpecification.duplicate-asset", this, name));
        }
        this._assets.put(name, asset);
    }

    public void addComponent(String id, IContainedComponent component) {
        if (this._components == null) {
            this._components = new HashMap();
        }
        if (this._components.containsKey(id)) {
            throw new IllegalArgumentException(Tapestry.format("ComponentSpecification.duplicate-component", this, id));
        }
        this._components.put(id, component);
    }

    public void addParameter(String name, IParameterSpecification spec) {
        if (this._parameters == null) {
            this._parameters = new HashMap();
        }
        if (this._parameters.containsKey(name)) {
            throw new IllegalArgumentException(Tapestry.format("ComponentSpecification.duplicate-parameter", this, name));
        }
        this._parameters.put(name, spec);
        this.addReservedParameterName(name);
    }

    public boolean getAllowBody() {
        return this._allowBody;
    }

    public boolean getAllowInformalParameters() {
        return this._allowInformalParameters;
    }

    public IAssetSpecification getAsset(String name) {
        return (IAssetSpecification)this.get(this._assets, name);
    }

    public List getAssetNames() {
        return this.sortedKeys(this._assets);
    }

    public IContainedComponent getComponent(String id) {
        return (IContainedComponent)this.get(this._components, id);
    }

    public String getComponentClassName() {
        return this._componentClassName;
    }

    public List getComponentIds() {
        return this.sortedKeys(this._components);
    }

    public IParameterSpecification getParameter(String name) {
        return (IParameterSpecification)this.get(this._parameters, name);
    }

    public List getParameterNames() {
        return this.sortedKeys(this._parameters);
    }

    public void setAllowBody(boolean value) {
        this._allowBody = value;
    }

    public void setAllowInformalParameters(boolean value) {
        this._allowInformalParameters = value;
    }

    public void setComponentClassName(String value) {
        this._componentClassName = value;
    }

    public void addBeanSpecification(String name, IBeanSpecification specification) {
        if (this._beans == null) {
            this._beans = new HashMap();
        } else if (this._beans.containsKey(name)) {
            throw new IllegalArgumentException(Tapestry.format("ComponentSpecification.duplicate-bean", this, name));
        }
        this._beans.put(name, specification);
    }

    public IBeanSpecification getBeanSpecification(String name) {
        if (this._beans == null) {
            return null;
        }
        return (IBeanSpecification)this._beans.get(name);
    }

    public Collection getBeanNames() {
        if (this._beans == null) {
            return Collections.EMPTY_LIST;
        }
        return Collections.unmodifiableCollection(this._beans.keySet());
    }

    public void addReservedParameterName(String value) {
        if (this._reservedParameterNames == null) {
            this._reservedParameterNames = new HashSet();
        }
        this._reservedParameterNames.add(value.toLowerCase());
    }

    public boolean isReservedParameterName(String value) {
        if (this._reservedParameterNames == null) {
            return false;
        }
        return this._reservedParameterNames.contains(value.toLowerCase());
    }

    public String toString() {
        ToStringBuilder builder = new ToStringBuilder((Object)this);
        builder.append("componentClassName", (Object)this._componentClassName);
        builder.append("pageSpecification", this._pageSpecification);
        builder.append("specificationLocation", (Object)this._specificationLocation);
        builder.append("allowBody", this._allowBody);
        builder.append("allowInformalParameter", this._allowInformalParameters);
        return builder.toString();
    }

    public String getDescription() {
        return this._description;
    }

    public void setDescription(String description) {
        this._description = description;
    }

    public String getPublicId() {
        return this._publicId;
    }

    public void setPublicId(String publicId) {
        this._publicId = publicId;
    }

    public boolean isPageSpecification() {
        return this._pageSpecification;
    }

    public void setPageSpecification(boolean pageSpecification) {
        this._pageSpecification = pageSpecification;
    }

    private List sortedKeys(Map input) {
        if (input == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList result = new ArrayList(input.keySet());
        Collections.sort(result);
        return result;
    }

    private Object get(Map map, Object key) {
        if (map == null) {
            return null;
        }
        return map.get(key);
    }

    public IResourceLocation getSpecificationLocation() {
        return this._specificationLocation;
    }

    public void setSpecificationLocation(IResourceLocation specificationLocation) {
        this._specificationLocation = specificationLocation;
    }

    public void addPropertySpecification(IPropertySpecification spec) {
        String name;
        if (this._propertySpecifications == null) {
            this._propertySpecifications = new HashMap();
        }
        if (this._propertySpecifications.containsKey(name = spec.getName())) {
            throw new IllegalArgumentException(Tapestry.format("ComponentSpecification.duplicate-property-specification", this, name));
        }
        this._propertySpecifications.put(name, spec);
    }

    public List getPropertySpecificationNames() {
        return this.sortedKeys(this._propertySpecifications);
    }

    public IPropertySpecification getPropertySpecification(String name) {
        return (IPropertySpecification)this.get(this._propertySpecifications, name);
    }
}

