/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.parse;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tapestry.ILocationHolder;
import org.apache.tapestry.IResourceLocation;
import org.apache.tapestry.IResourceResolver;
import org.apache.tapestry.Tapestry;
import org.apache.tapestry.parse.AbstractSpecificationRule;
import org.apache.tapestry.parse.ComponentCopyOfRule;
import org.apache.tapestry.parse.DisallowFrameworkNamespaceRule;
import org.apache.tapestry.parse.SetMetaPropertyRule;
import org.apache.tapestry.parse.SetPublicIdRule;
import org.apache.tapestry.parse.SpecificationDigester;
import org.apache.tapestry.parse.ValidatePublicIdRule;
import org.apache.tapestry.spec.AssetType;
import org.apache.tapestry.spec.BeanLifecycle;
import org.apache.tapestry.spec.BindingType;
import org.apache.tapestry.spec.Direction;
import org.apache.tapestry.spec.IApplicationSpecification;
import org.apache.tapestry.spec.IComponentSpecification;
import org.apache.tapestry.spec.IExtensionSpecification;
import org.apache.tapestry.spec.ILibrarySpecification;
import org.apache.tapestry.spec.SpecFactory;
import org.apache.tapestry.util.xml.DocumentParseException;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;

public class SpecificationParser {
    private static final Log LOG = LogFactory.getLog((Class)(class$org$apache$tapestry$parse$SpecificationParser == null ? (class$org$apache$tapestry$parse$SpecificationParser = SpecificationParser.class$("org.apache.tapestry.parse.SpecificationParser")) : class$org$apache$tapestry$parse$SpecificationParser));
    public static final String TAPESTRY_DTD_1_3_PUBLIC_ID = "-//Howard Lewis Ship//Tapestry Specification 1.3//EN";
    public static final String TAPESTRY_DTD_3_0_PUBLIC_ID = "-//Apache Software Foundation//Tapestry Specification 3.0//EN";
    public static final String EXTENDED_PROPERTY_NAME_PATTERN = "^_?[a-zA-Z](\\w|-|\\.)*$";
    public static final String PARAMETER_NAME_PATTERN = "^_?[a-zA-Z]\\w*$";
    public static final String PROPERTY_NAME_PATTERN = "^_?[a-zA-Z]\\w*$";
    public static final String PAGE_NAME_PATTERN = "^_?[a-zA-Z](\\w|-|\\.)*$";
    public static final String COMPONENT_ALIAS_PATTERN = "^_?[a-zA-Z]\\w*$";
    public static final String BEAN_NAME_PATTERN = "^_?[a-zA-Z]\\w*$";
    public static final String COMPONENT_ID_PATTERN = "^_?[a-zA-Z]\\w*$";
    public static final String ASSET_NAME_PATTERN = "(\\$template)|(^_?[a-zA-Z]\\w*$)";
    public static final String SERVICE_NAME_PATTERN = "^_?[a-zA-Z](\\w|-|\\.)*$";
    public static final String LIBRARY_ID_PATTERN = "^_?[a-zA-Z]\\w*$";
    public static final String EXTENSION_NAME_PATTERN = "^_?[a-zA-Z](\\w|-|\\.)*$";
    public static final String COMPONENT_TYPE_PATTERN = "^(_?[a-zA-Z]\\w*:)?[a-zA-Z_](\\w)*$";
    private static final Map CONVERSION_MAP = new HashMap();
    private SpecFactory _factory;
    private SpecificationDigester _componentDigester;
    private SpecificationDigester _pageDigester;
    private SpecificationDigester _libraryDigester;
    private IResourceResolver _resolver;
    static /* synthetic */ Class class$org$apache$tapestry$parse$SpecificationParser;

    public SpecificationParser(IResourceResolver resolver) {
        this._resolver = resolver;
        this.setFactory(new SpecFactory());
    }

    public IComponentSpecification parseComponentSpecification(IResourceLocation resourceLocation) throws DocumentParseException {
        if (this._componentDigester == null) {
            this._componentDigester = this.constructComponentDigester();
        }
        try {
            IComponentSpecification result = (IComponentSpecification)this.parse(this._componentDigester, resourceLocation);
            result.setSpecificationLocation(resourceLocation);
            return result;
        }
        catch (DocumentParseException ex) {
            this._componentDigester = null;
            throw ex;
        }
    }

    protected Object parse(SpecificationDigester digester, IResourceLocation location) throws DocumentParseException {
        try {
            URL url;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Parsing " + location));
            }
            if ((url = location.getResourceURL()) == null) {
                throw new DocumentParseException(Tapestry.format("AbstractDocumentParser.missing-resource", location), location);
            }
            InputSource source = new InputSource(url.toExternalForm());
            digester.setResourceLocation(location);
            Object result = digester.parse(source);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Result: " + result));
            }
            Object object = result;
            return object;
        }
        catch (SAXParseException ex) {
            throw new DocumentParseException(ex);
        }
        catch (DocumentParseException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new DocumentParseException(Tapestry.format("SpecificationParser.error-reading-resource", location, ex.getMessage()), location, (Throwable)ex);
        }
        finally {
            digester.setResourceLocation(null);
        }
    }

    public IComponentSpecification parsePageSpecification(IResourceLocation resourceLocation) throws DocumentParseException {
        if (this._pageDigester == null) {
            this._pageDigester = this.constructPageDigester();
        }
        try {
            IComponentSpecification result = (IComponentSpecification)this.parse(this._pageDigester, resourceLocation);
            result.setSpecificationLocation(resourceLocation);
            return result;
        }
        catch (DocumentParseException ex) {
            this._pageDigester = null;
            throw ex;
        }
    }

    public IApplicationSpecification parseApplicationSpecification(IResourceLocation resourceLocation) throws DocumentParseException {
        IApplicationSpecification result = (IApplicationSpecification)this.parse(this.constructApplicationDigester(), resourceLocation);
        result.setResourceResolver(this._resolver);
        result.setSpecificationLocation(resourceLocation);
        result.instantiateImmediateExtensions();
        return result;
    }

    public ILibrarySpecification parseLibrarySpecification(IResourceLocation resourceLocation) throws DocumentParseException {
        if (this._libraryDigester == null) {
            this._libraryDigester = this.constructLibraryDigester();
        }
        try {
            ILibrarySpecification result = (ILibrarySpecification)this.parse(this._libraryDigester, resourceLocation);
            result.setResourceResolver(this._resolver);
            result.setSpecificationLocation(resourceLocation);
            result.instantiateImmediateExtensions();
            return result;
        }
        catch (DocumentParseException ex) {
            this._libraryDigester = null;
            throw ex;
        }
    }

    public void setFactory(SpecFactory factory) {
        this._factory = factory;
    }

    public SpecFactory getFactory() {
        return this._factory;
    }

    protected SpecificationDigester constructBaseDigester(String rootElement) {
        SpecificationDigester result = new SpecificationDigester();
        result.addBeanPropertySetter("*/description", "description");
        result.addRule("*/property", new SetMetaPropertyRule());
        result.register(TAPESTRY_DTD_1_3_PUBLIC_ID, this.getURL("Tapestry_1_3.dtd"));
        result.register(TAPESTRY_DTD_3_0_PUBLIC_ID, this.getURL("Tapestry_3_0.dtd"));
        result.addDocumentRule(new ValidatePublicIdRule(new String[]{TAPESTRY_DTD_1_3_PUBLIC_ID, TAPESTRY_DTD_3_0_PUBLIC_ID}, rootElement));
        result.setValidating(true);
        return result;
    }

    protected SpecificationDigester constructApplicationDigester() {
        SpecificationDigester result = this.constructBaseDigester("application");
        String pattern = "application";
        result.addRule(pattern, new CreateApplicationSpecificationRule());
        result.addSetLimitedProperties(pattern, new String[]{"name", "engine-class"}, new String[]{"name", "engineClassName"});
        result.addRule(pattern, new SetPublicIdRule());
        this.configureLibraryCommon(result, "application");
        return result;
    }

    protected SpecificationDigester constructLibraryDigester() {
        SpecificationDigester result = this.constructBaseDigester("library-specification");
        String pattern = "library-specification";
        result.addRule(pattern, new CreateLibrarySpecificationRule());
        result.addRule(pattern, new SetPublicIdRule());
        this.configureLibraryCommon(result, "library-specification");
        return result;
    }

    protected void configureLibraryCommon(SpecificationDigester digester, String rootElementName) {
        String pattern = rootElementName + "/page";
        digester.addValidate(pattern, "name", "^_?[a-zA-Z](\\w|-|\\.)*$", "SpecificationParser.invalid-page-name");
        digester.addCallMethod(pattern, "setPageSpecificationPath", 2);
        digester.addCallParam(pattern, 0, "name");
        digester.addCallParam(pattern, 1, "specification-path");
        pattern = rootElementName + "/component-type";
        digester.addValidate(pattern, "type", "^_?[a-zA-Z]\\w*$", "SpecificationParser.invalid-component-type");
        digester.addCallMethod(pattern, "setComponentSpecificationPath", 2);
        digester.addCallParam(pattern, 0, "type");
        digester.addCallParam(pattern, 1, "specification-path");
        pattern = rootElementName + "/component-alias";
        digester.addValidate(pattern, "type", "^_?[a-zA-Z]\\w*$", "SpecificationParser.invalid-component-type");
        digester.addCallMethod(pattern, "setComponentSpecificationPath", 2);
        digester.addCallParam(pattern, 0, "type");
        digester.addCallParam(pattern, 1, "specification-path");
        pattern = rootElementName + "/service";
        digester.addValidate(pattern, "name", "^_?[a-zA-Z](\\w|-|\\.)*$", "SpecificationParser.invalid-service-name");
        digester.addCallMethod(pattern, "setServiceClassName", 2);
        digester.addCallParam(pattern, 0, "name");
        digester.addCallParam(pattern, 1, "class");
        pattern = rootElementName + "/library";
        digester.addValidate(pattern, "id", "^_?[a-zA-Z]\\w*$", "SpecificationParser.invalid-library-id");
        digester.addRule(pattern, new DisallowFrameworkNamespaceRule());
        digester.addCallMethod(pattern, "setLibrarySpecificationPath", 2);
        digester.addCallParam(pattern, 0, "id");
        digester.addCallParam(pattern, 1, "specification-path");
        pattern = rootElementName + "/extension";
        digester.addRule(pattern, new CreateExtensionSpecificationRule());
        digester.addValidate(pattern, "name", "^_?[a-zA-Z](\\w|-|\\.)*$", "SpecificationParser.invalid-extension-name");
        digester.addSetBooleanProperty(pattern, "immediate", "immediate");
        digester.addSetLimitedProperties(pattern, "class", "className");
        digester.addConnectChild(pattern, "addExtensionSpecification", "name");
        pattern = rootElementName + "/extension/configure";
        digester.addValidate(pattern, "property-name", "^_?[a-zA-Z]\\w*$", "SpecificationParser.invalid-property-name");
        digester.addRule(pattern, new ProcessExtensionConfigurationRule());
    }

    protected SpecificationDigester constructPageDigester() {
        SpecificationDigester result = this.constructBaseDigester("page-specification");
        String pattern = "page-specification";
        result.addRule(pattern, new CreateComponentSpecificationRule());
        result.addRule(pattern, new SetPublicIdRule());
        result.addInitializeProperty(pattern, "pageSpecification", Boolean.TRUE);
        result.addInitializeProperty(pattern, "allowBody", Boolean.TRUE);
        result.addInitializeProperty(pattern, "allowInformalParameters", Boolean.FALSE);
        result.addSetLimitedProperties(pattern, "class", "componentClassName");
        this.configureCommon(result, "page-specification");
        return result;
    }

    protected SpecificationDigester constructComponentDigester() {
        SpecificationDigester result = this.constructBaseDigester("component-specification");
        String pattern = "component-specification";
        result.addRule(pattern, new CreateComponentSpecificationRule());
        result.addRule(pattern, new SetPublicIdRule());
        result.addSetBooleanProperty(pattern, "allow-body", "allowBody");
        result.addSetBooleanProperty(pattern, "allow-informal-parameters", "allowInformalParameters");
        result.addSetLimitedProperties(pattern, "class", "componentClassName");
        pattern = "component-specification/parameter";
        result.addRule(pattern, new CreateParameterSpecificationRule());
        result.addValidate(pattern, "name", "^_?[a-zA-Z]\\w*$", "SpecificationParser.invalid-parameter-name");
        result.addValidate(pattern, "property-name", "^_?[a-zA-Z]\\w*$", "SpecificationParser.invalid-property-name");
        result.addSetLimitedProperties(pattern, "name", "propertyName");
        result.addSetLimitedProperties(pattern, new String[]{"property-name", "type", "java-type", "default-value"}, new String[]{"propertyName", "type", "type", "defaultValue"});
        result.addSetBooleanProperty(pattern, "required", "required");
        result.addSetConvertedProperty(pattern, CONVERSION_MAP, "direction", "direction");
        result.addConnectChild(pattern, "addParameter", "name");
        pattern = "component-specification/reserved-parameter";
        result.addCallMethod(pattern, "addReservedParameterName", 1);
        result.addCallParam(pattern, 0, "name");
        this.configureCommon(result, "component-specification");
        return result;
    }

    protected void configureCommon(SpecificationDigester digester, String rootElementName) {
        String pattern = rootElementName + "/bean";
        digester.addRule(pattern, new CreateBeanSpecificationRule());
        digester.addValidate(pattern, "name", "^_?[a-zA-Z]\\w*$", "SpecificationParser.invalid-bean-name");
        digester.addSetConvertedProperty(pattern, CONVERSION_MAP, "lifecycle", "lifecycle");
        digester.addSetLimitedProperties(pattern, "class", "className");
        digester.addConnectChild(pattern, "addBeanSpecification", "name");
        pattern = rootElementName + "/bean/set-property";
        digester.addRule(pattern, new CreateExpressionBeanInitializerRule());
        digester.addSetLimitedProperties(pattern, "name", "propertyName");
        digester.addSetExtendedProperty(pattern, "expression", "expression", true);
        digester.addSetNext(pattern, "addInitializer");
        pattern = rootElementName + "/bean/set-string-property";
        digester.addRule(pattern, new CreateStringBeanInitializerRule());
        digester.addSetLimitedProperties(pattern, new String[]{"name", "key"}, new String[]{"propertyName", "key"});
        digester.addSetNext(pattern, "addInitializer");
        pattern = rootElementName + "/bean/set-message-property";
        digester.addRule(pattern, new CreateStringBeanInitializerRule());
        digester.addSetLimitedProperties(pattern, new String[]{"name", "key"}, new String[]{"propertyName", "key"});
        digester.addSetNext(pattern, "addInitializer");
        pattern = rootElementName + "/component";
        digester.addRule(pattern, new CreateContainedComponentRule());
        digester.addValidate(pattern, "id", "^_?[a-zA-Z]\\w*$", "SpecificationParser.invalid-component-id");
        digester.addValidate(pattern, "type", COMPONENT_TYPE_PATTERN, "SpecificationParser.invalid-component-type");
        digester.addSetLimitedProperties(pattern, "type", "type");
        digester.addRule(pattern, new ComponentCopyOfRule());
        digester.addConnectChild(pattern, "addComponent", "id");
        digester.addSetBooleanProperty(pattern, "inherit-informal-parameters", "inheritInformalParameters");
        pattern = rootElementName + "/component/binding";
        CreateBindingSpecificationRule createBindingSpecificationRule = new CreateBindingSpecificationRule();
        digester.addRule(pattern, createBindingSpecificationRule);
        digester.addInitializeProperty(pattern, "type", (Object)BindingType.DYNAMIC);
        digester.addSetExtendedProperty(pattern, "expression", "value", true);
        digester.addConnectChild(pattern, "setBinding", "name");
        pattern = rootElementName + "/component/field-binding";
        digester.addRule(pattern, createBindingSpecificationRule);
        digester.addInitializeProperty(pattern, "type", (Object)BindingType.FIELD);
        digester.addSetExtendedProperty(pattern, "field-name", "value", true);
        digester.addConnectChild(pattern, "setBinding", "name");
        pattern = rootElementName + "/component/inherited-binding";
        digester.addRule(pattern, createBindingSpecificationRule);
        digester.addInitializeProperty(pattern, "type", (Object)BindingType.INHERITED);
        digester.addSetLimitedProperties(pattern, "parameter-name", "value");
        digester.addConnectChild(pattern, "setBinding", "name");
        pattern = rootElementName + "/component/static-binding";
        digester.addRule(pattern, createBindingSpecificationRule);
        digester.addInitializeProperty(pattern, "type", (Object)BindingType.STATIC);
        digester.addSetExtendedProperty(pattern, "value", "value", true);
        digester.addConnectChild(pattern, "setBinding", "name");
        pattern = rootElementName + "/component/string-binding";
        digester.addRule(pattern, createBindingSpecificationRule);
        digester.addInitializeProperty(pattern, "type", (Object)BindingType.STRING);
        digester.addSetLimitedProperties(pattern, "key", "value");
        digester.addConnectChild(pattern, "setBinding", "name");
        pattern = rootElementName + "/component/message-binding";
        digester.addRule(pattern, createBindingSpecificationRule);
        digester.addInitializeProperty(pattern, "type", (Object)BindingType.STRING);
        digester.addSetLimitedProperties(pattern, "key", "value");
        digester.addConnectChild(pattern, "setBinding", "name");
        pattern = rootElementName + "/component/listener-binding";
        digester.addRule(pattern, new CreateListenerBindingSpecificationRule());
        digester.addSetLimitedProperties(pattern, "language", "language");
        digester.addBody(pattern, "value");
        digester.addConnectChild(pattern, "setBinding", "name");
        pattern = rootElementName + "/external-asset";
        CreateAssetSpecificationRule createAssetSpecificationRule = new CreateAssetSpecificationRule();
        digester.addRule(pattern, createAssetSpecificationRule);
        digester.addInitializeProperty(pattern, "type", (Object)AssetType.EXTERNAL);
        digester.addValidate(pattern, "name", ASSET_NAME_PATTERN, "SpecificationParser.invalid-asset-name");
        digester.addSetLimitedProperties(pattern, "URL", "path");
        digester.addConnectChild(pattern, "addAsset", "name");
        pattern = rootElementName + "/context-asset";
        digester.addRule(pattern, createAssetSpecificationRule);
        digester.addInitializeProperty(pattern, "type", (Object)AssetType.CONTEXT);
        digester.addValidate(pattern, "name", ASSET_NAME_PATTERN, "SpecificationParser.invalid-asset-name");
        digester.addSetLimitedProperties(pattern, "path", "path");
        digester.addConnectChild(pattern, "addAsset", "name");
        pattern = rootElementName + "/private-asset";
        digester.addRule(pattern, createAssetSpecificationRule);
        digester.addInitializeProperty(pattern, "type", (Object)AssetType.PRIVATE);
        digester.addValidate(pattern, "name", ASSET_NAME_PATTERN, "SpecificationParser.invalid-asset-name");
        digester.addSetLimitedProperties(pattern, "resource-path", "path");
        digester.addConnectChild(pattern, "addAsset", "name");
        pattern = rootElementName + "/property-specification";
        digester.addRule(pattern, new CreatePropertySpecificationRule());
        digester.addValidate(pattern, "name", "^_?[a-zA-Z]\\w*$", "SpecificationParser.invalid-property-name");
        digester.addSetLimitedProperties(pattern, new String[]{"name", "type"}, new String[]{"name", "type"});
        digester.addSetBooleanProperty(pattern, "persistent", "persistent");
        digester.addSetExtendedProperty(pattern, "initial-value", "initialValue", false);
        digester.addSetNext(pattern, "addPropertySpecification");
    }

    private String getURL(String resource) {
        return this.getClass().getResource(resource).toExternalForm();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        CONVERSION_MAP.put("true", Boolean.TRUE);
        CONVERSION_MAP.put("t", Boolean.TRUE);
        CONVERSION_MAP.put("1", Boolean.TRUE);
        CONVERSION_MAP.put("y", Boolean.TRUE);
        CONVERSION_MAP.put("yes", Boolean.TRUE);
        CONVERSION_MAP.put("on", Boolean.TRUE);
        CONVERSION_MAP.put("false", Boolean.FALSE);
        CONVERSION_MAP.put("f", Boolean.FALSE);
        CONVERSION_MAP.put("0", Boolean.FALSE);
        CONVERSION_MAP.put("off", Boolean.FALSE);
        CONVERSION_MAP.put("no", Boolean.FALSE);
        CONVERSION_MAP.put("n", Boolean.FALSE);
        CONVERSION_MAP.put("none", BeanLifecycle.NONE);
        CONVERSION_MAP.put("request", BeanLifecycle.REQUEST);
        CONVERSION_MAP.put("page", BeanLifecycle.PAGE);
        CONVERSION_MAP.put("render", BeanLifecycle.RENDER);
        CONVERSION_MAP.put("boolean", new BooleanConverter());
        CONVERSION_MAP.put("int", new IntConverter());
        CONVERSION_MAP.put("double", new DoubleConverter());
        CONVERSION_MAP.put("String", new StringConverter());
        CONVERSION_MAP.put("long", new LongConverter());
        CONVERSION_MAP.put("in", Direction.IN);
        CONVERSION_MAP.put("form", Direction.FORM);
        CONVERSION_MAP.put("custom", Direction.CUSTOM);
        CONVERSION_MAP.put("auto", Direction.AUTO);
    }

    private static class ProcessExtensionConfigurationRule
    extends AbstractSpecificationRule {
        private String _value;
        private String _propertyName;
        private IConverter _converter;

        private ProcessExtensionConfigurationRule() {
        }

        public void begin(String namespace, String name, Attributes attributes) throws Exception {
            this._propertyName = this.getValue(attributes, "property-name");
            this._value = this.getValue(attributes, "value");
            String type = this.getValue(attributes, "type");
            this._converter = (IConverter)CONVERSION_MAP.get(type);
            if (this._converter == null) {
                throw new DocumentParseException(Tapestry.format("SpecificationParser.unknown-static-value-type", type), this.getResourceLocation());
            }
        }

        public void body(String namespace, String name, String text) throws Exception {
            if (Tapestry.isBlank(text)) {
                return;
            }
            if (this._value != null) {
                throw new DocumentParseException(Tapestry.format("SpecificationParser.no-attribute-and-body", "value", name), this.getResourceLocation());
            }
            this._value = text.trim();
        }

        public void end(String namespace, String name) throws Exception {
            if (this._value == null) {
                throw new DocumentParseException(Tapestry.format("SpecificationParser.required-extended-attribute", name, "value"), this.getResourceLocation());
            }
            Object objectValue = this._converter.convert(this._value);
            IExtensionSpecification top = (IExtensionSpecification)this.digester.peek();
            top.addConfiguration(this._propertyName, objectValue);
            this._converter = null;
            this._value = null;
            this._propertyName = null;
        }
    }

    private class CreateExtensionSpecificationRule
    extends SpecFactoryCreateRule {
        private CreateExtensionSpecificationRule() {
        }

        public ILocationHolder create() {
            return SpecificationParser.this._factory.createExtensionSpecification();
        }
    }

    private class CreateLibrarySpecificationRule
    extends SpecFactoryCreateRule {
        private CreateLibrarySpecificationRule() {
        }

        public ILocationHolder create() {
            return SpecificationParser.this._factory.createLibrarySpecification();
        }
    }

    private class CreateApplicationSpecificationRule
    extends SpecFactoryCreateRule {
        private CreateApplicationSpecificationRule() {
        }

        public ILocationHolder create() {
            return SpecificationParser.this._factory.createApplicationSpecification();
        }
    }

    private class CreatePropertySpecificationRule
    extends SpecFactoryCreateRule {
        private CreatePropertySpecificationRule() {
        }

        public ILocationHolder create() {
            return SpecificationParser.this._factory.createPropertySpecification();
        }
    }

    private class CreateAssetSpecificationRule
    extends SpecFactoryCreateRule {
        private CreateAssetSpecificationRule() {
        }

        public ILocationHolder create() {
            return SpecificationParser.this._factory.createAssetSpecification();
        }
    }

    private class CreateListenerBindingSpecificationRule
    extends SpecFactoryCreateRule {
        private CreateListenerBindingSpecificationRule() {
        }

        public ILocationHolder create() {
            return SpecificationParser.this._factory.createListenerBindingSpecification();
        }
    }

    private class CreateBeanSpecificationRule
    extends SpecFactoryCreateRule {
        private CreateBeanSpecificationRule() {
        }

        public ILocationHolder create() {
            return SpecificationParser.this._factory.createBeanSpecification();
        }
    }

    private class CreateBindingSpecificationRule
    extends SpecFactoryCreateRule {
        private CreateBindingSpecificationRule() {
        }

        public ILocationHolder create() {
            return SpecificationParser.this._factory.createBindingSpecification();
        }
    }

    private class CreateComponentSpecificationRule
    extends SpecFactoryCreateRule {
        private CreateComponentSpecificationRule() {
        }

        public ILocationHolder create() {
            return SpecificationParser.this._factory.createComponentSpecification();
        }
    }

    private class CreateParameterSpecificationRule
    extends SpecFactoryCreateRule {
        private CreateParameterSpecificationRule() {
        }

        public ILocationHolder create() {
            return SpecificationParser.this._factory.createParameterSpecification();
        }
    }

    private class CreateContainedComponentRule
    extends SpecFactoryCreateRule {
        private CreateContainedComponentRule() {
        }

        public ILocationHolder create() {
            return SpecificationParser.this._factory.createContainedComponent();
        }
    }

    private class CreateStringBeanInitializerRule
    extends SpecFactoryCreateRule {
        private CreateStringBeanInitializerRule() {
        }

        public ILocationHolder create() {
            return SpecificationParser.this._factory.createMessageBeanInitializer();
        }
    }

    private class CreateExpressionBeanInitializerRule
    extends SpecFactoryCreateRule {
        private CreateExpressionBeanInitializerRule() {
        }

        public ILocationHolder create() {
            return SpecificationParser.this._factory.createExpressionBeanInitializer();
        }
    }

    private static abstract class SpecFactoryCreateRule
    extends AbstractSpecificationRule {
        private SpecFactoryCreateRule() {
        }

        public abstract ILocationHolder create();

        public void begin(String namespace, String name, Attributes attributes) throws Exception {
            ILocationHolder holder = this.create();
            holder.setLocation(this.getLocation());
            this.digester.push((Object)holder);
        }

        public void end(String namespace, String name) throws Exception {
            this.digester.pop();
        }
    }

    private static class StringConverter
    implements IConverter {
        private StringConverter() {
        }

        public Object convert(String value) {
            return value.trim();
        }
    }

    private static class DoubleConverter
    implements IConverter {
        private DoubleConverter() {
        }

        public Object convert(String value) throws DocumentParseException {
            try {
                return new Double(value);
            }
            catch (NumberFormatException ex) {
                throw new DocumentParseException(Tapestry.format("SpecificationParser.fail-convert-double", value), ex);
            }
        }
    }

    private static class LongConverter
    implements IConverter {
        private LongConverter() {
        }

        public Object convert(String value) throws DocumentParseException {
            try {
                return new Long(value);
            }
            catch (NumberFormatException ex) {
                throw new DocumentParseException(Tapestry.format("SpecificationParser.fail-convert-long", value), ex);
            }
        }
    }

    private static class IntConverter
    implements IConverter {
        private IntConverter() {
        }

        public Object convert(String value) throws DocumentParseException {
            try {
                return new Integer(value);
            }
            catch (NumberFormatException ex) {
                throw new DocumentParseException(Tapestry.format("SpecificationParser.fail-convert-int", value), ex);
            }
        }
    }

    private static class BooleanConverter
    implements IConverter {
        private BooleanConverter() {
        }

        public Object convert(String value) throws DocumentParseException {
            Object result = CONVERSION_MAP.get(value.toLowerCase());
            if (result == null || !(result instanceof Boolean)) {
                throw new DocumentParseException(Tapestry.format("SpecificationParser.fail-convert-boolean", value));
            }
            return result;
        }
    }

    private static interface IConverter {
        public Object convert(String var1) throws DocumentParseException;
    }
}

