/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.html;

import java.util.HashMap;
import org.apache.tapestry.AbstractComponent;
import org.apache.tapestry.ApplicationRuntimeException;
import org.apache.tapestry.IAsset;
import org.apache.tapestry.IEngine;
import org.apache.tapestry.IMarkupWriter;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.IResourceLocation;
import org.apache.tapestry.IScript;
import org.apache.tapestry.Tapestry;
import org.apache.tapestry.components.ILinkComponent;
import org.apache.tapestry.components.LinkEventType;
import org.apache.tapestry.engine.IScriptSource;
import org.apache.tapestry.html.Body;

public abstract class Rollover
extends AbstractComponent {
    private IScript _parsedScript;

    protected String getAssetURL(IAsset asset, IRequestCycle cycle) {
        if (asset == null) {
            return null;
        }
        return asset.buildURL(cycle);
    }

    protected void renderComponent(IMarkupWriter writer, IRequestCycle cycle) {
        if (cycle.isRewinding()) {
            return;
        }
        String imageURL = null;
        String focusURL = null;
        String blurURL = null;
        boolean dynamic = false;
        String imageName = null;
        Body body = Body.get(cycle);
        if (body == null) {
            throw new ApplicationRuntimeException(Tapestry.getMessage("Rollover.must-be-contained-by-body"), this, null, null);
        }
        ILinkComponent serviceLink = (ILinkComponent)cycle.getAttribute("org.apache.tapestry.active-link-component");
        if (serviceLink == null) {
            throw new ApplicationRuntimeException(Tapestry.getMessage("Rollover.must-be-contained-by-link"), this, null, null);
        }
        boolean linkDisabled = serviceLink.isDisabled();
        if (linkDisabled) {
            imageURL = this.getAssetURL(this.getDisabled(), cycle);
            if (imageURL == null) {
                imageURL = this.getAssetURL(this.getImage(), cycle);
            }
        } else {
            imageURL = this.getAssetURL(this.getImage(), cycle);
            focusURL = this.getAssetURL(this.getFocus(), cycle);
            blurURL = this.getAssetURL(this.getBlur(), cycle);
            boolean bl = dynamic = focusURL != null || blurURL != null;
        }
        if (imageURL == null) {
            throw Tapestry.createRequiredParameterException(this, "image");
        }
        writer.beginEmpty("img");
        writer.attribute("src", imageURL);
        writer.attribute("border", 0);
        if (dynamic) {
            if (focusURL == null) {
                focusURL = imageURL;
            }
            if (blurURL == null) {
                blurURL = imageURL;
            }
            imageName = this.writeScript(cycle, body, serviceLink, focusURL, blurURL);
            writer.attribute("name", imageName);
        }
        this.renderInformalParameters(writer, cycle);
        writer.closeTag();
    }

    private IScript getParsedScript() {
        if (this._parsedScript == null) {
            IEngine engine = this.getPage().getEngine();
            IScriptSource source = engine.getScriptSource();
            IResourceLocation scriptLocation = this.getSpecification().getSpecificationLocation().getRelativeLocation("Rollover.script");
            this._parsedScript = source.getScript(scriptLocation);
        }
        return this._parsedScript;
    }

    private String writeScript(IRequestCycle cycle, Body body, ILinkComponent link, String focusURL, String blurURL) {
        String imageName = body.getUniqueString(this.getId());
        String focusImageURL = body.getPreloadedImageReference(focusURL);
        String blurImageURL = body.getPreloadedImageReference(blurURL);
        HashMap<String, String> symbols = new HashMap<String, String>();
        symbols.put("imageName", imageName);
        symbols.put("focusImageURL", focusImageURL);
        symbols.put("blurImageURL", blurImageURL);
        this.getParsedScript().execute(cycle, body, symbols);
        link.addEventHandler(LinkEventType.MOUSE_OVER, (String)symbols.get("onMouseOverName"));
        link.addEventHandler(LinkEventType.MOUSE_OUT, (String)symbols.get("onMouseOutName"));
        return imageName;
    }

    public abstract IAsset getBlur();

    public abstract IAsset getDisabled();

    public abstract IAsset getFocus();

    public abstract IAsset getImage();
}

