/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.ibatis.support;

import com.ibatis.db.sqlmap.SqlMap;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.orm.ibatis.SqlMapTemplate;

public abstract class SqlMapDaoSupport
implements InitializingBean {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private SqlMapTemplate sqlMapTemplate = new SqlMapTemplate();
    private boolean externalTemplate = false;

    public final void setDataSource(DataSource dataSource) {
        this.sqlMapTemplate.setDataSource(dataSource);
    }

    public final DataSource getDataSource() {
        return this.sqlMapTemplate != null ? this.sqlMapTemplate.getDataSource() : null;
    }

    public final void setSqlMap(SqlMap sqlMap) {
        this.sqlMapTemplate.setSqlMap(sqlMap);
    }

    public final SqlMap getSqlMap() {
        return this.sqlMapTemplate.getSqlMap();
    }

    public final void setSqlMapTemplate(SqlMapTemplate sqlMapTemplate) {
        if (sqlMapTemplate == null) {
            throw new IllegalArgumentException("Cannot set sqlMapTemplate to null");
        }
        this.sqlMapTemplate = sqlMapTemplate;
        this.externalTemplate = true;
    }

    public final SqlMapTemplate getSqlMapTemplate() {
        return this.sqlMapTemplate;
    }

    public final void afterPropertiesSet() throws Exception {
        if (!this.externalTemplate) {
            this.sqlMapTemplate.afterPropertiesSet();
        }
        this.initDao();
    }

    protected void initDao() throws Exception {
    }
}

