/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.hibernate;

import net.sf.hibernate.FlushMode;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.Interceptor;
import net.sf.hibernate.Session;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.orm.hibernate.HibernateAccessor;
import org.springframework.orm.hibernate.SessionFactoryUtils;
import org.springframework.orm.hibernate.SessionHolder;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class HibernateInterceptor
extends HibernateAccessor
implements MethodInterceptor,
BeanFactoryAware {
    private String entityInterceptorBeanName;
    private BeanFactory beanFactory;
    static /* synthetic */ Class class$net$sf$hibernate$Interceptor;

    public void setEntityInterceptorBeanName(String entityInterceptorBeanName) {
        this.entityInterceptorBeanName = entityInterceptorBeanName;
        this.setEntityInterceptor(null);
    }

    public Interceptor getEntityInterceptor() throws IllegalStateException, BeansException {
        if (this.entityInterceptorBeanName != null) {
            if (this.beanFactory == null) {
                throw new IllegalStateException("Cannot get entity interceptor via bean name if no bean factory set");
            }
            return (Interceptor)this.beanFactory.getBean(this.entityInterceptorBeanName, class$net$sf$hibernate$Interceptor == null ? (class$net$sf$hibernate$Interceptor = HibernateInterceptor.class$("net.sf.hibernate.Interceptor")) : class$net$sf$hibernate$Interceptor);
        }
        return super.getEntityInterceptor();
    }

    public void setBeanFactory(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    public Object invoke(MethodInvocation methodInvocation) throws Throwable {
        boolean existingTransaction = false;
        Session session = SessionFactoryUtils.getSession(this.getSessionFactory(), this.getEntityInterceptor(), this.getJdbcExceptionTranslator());
        if (TransactionSynchronizationManager.hasResource(this.getSessionFactory())) {
            this.logger.debug((Object)"Found thread-bound Session for Hibernate interceptor");
            existingTransaction = true;
        } else {
            this.logger.debug((Object)"Using new Session for Hibernate interceptor");
            if (this.getFlushMode() == 0) {
                session.setFlushMode(FlushMode.NEVER);
            }
            TransactionSynchronizationManager.bindResource(this.getSessionFactory(), new SessionHolder(session));
        }
        try {
            Object retVal = methodInvocation.proceed();
            this.flushIfNecessary(session, existingTransaction);
            Object object = retVal;
            return object;
        }
        catch (HibernateException ex) {
            throw this.convertHibernateAccessException(ex);
        }
        finally {
            if (existingTransaction) {
                this.logger.debug((Object)"Not closing pre-bound Hibernate Session after interceptor");
            } else {
                TransactionSynchronizationManager.unbindResource(this.getSessionFactory());
                SessionFactoryUtils.releaseSession(session, this.getSessionFactory());
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

