/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.core;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.springframework.jdbc.core.ResultReader;
import org.springframework.jdbc.core.RowMapper;

public class RowMapperResultReader
implements ResultReader {
    private final List results;
    private final RowMapper rowMapper;
    private int rowNum = 0;

    public RowMapperResultReader(RowMapper rowMapper) {
        this(rowMapper, 0);
    }

    public RowMapperResultReader(RowMapper rowMapper, int rowsExpected) {
        this.results = rowsExpected > 0 ? new ArrayList(rowsExpected) : new LinkedList();
        this.rowMapper = rowMapper;
    }

    public void processRow(ResultSet rs) throws SQLException {
        this.results.add(this.rowMapper.mapRow(rs, this.rowNum++));
    }

    public List getResults() {
        return this.results;
    }
}

